#!/usr/bin/env node
/**
 * DashScope API Key Retrieval Guide
 */

console.log('='.repeat(80));
console.log('DashScope API Key Retrieval Guide');
console.log('='.repeat(80));
console.log('');
console.log('Since DashScope API Key management has no public OpenAPI interface, please obtain it manually:');
console.log('');
console.log('Method 1: Copy existing API Key from Bailian console');
console.log('  1. Visit: https://bailian.console.aliyun.com/cn-beijing/#/efm/api_key');
console.log('  2. Click the copy icon on the right side of any API Key');
console.log('  3. Copy the complete API Key (format: sk-xxxxxxxxxxxx)');
console.log('');
console.log('Method 2: Create new API Key');
console.log('  1. Visit: https://bailian.console.aliyun.com/cn-beijing/#/efm/api_key');
console.log('  2. Click the "Create API Key" button');
console.log('  3. Fill in description (e.g., CosyVoice speech synthesis test)');
console.log('  4. Click confirm, copy the generated API Key');
console.log('');
console.log('='.repeat(80));
console.log('After obtaining, use the following command to set environment variable:');
console.log('');

if (process.platform === 'win32') {
  console.log('  Windows (CMD):');
  console.log('    set DASHSCOPE_API_KEY=sk-xxxxxxxxxxxx');
  console.log('');
  console.log('  Windows (PowerShell):');
  console.log('    $env:DASHSCOPE_API_KEY=\'sk-xxxxxxxxxxxx\'');
} else {
  console.log('  macOS/Linux:');
  console.log('    export DASHSCOPE_API_KEY=\'sk-xxxxxxxxxxxx\'');
}

console.log('');
console.log('Then run the startup script:');
console.log('');
console.log('  ./start.sh       (macOS/Linux)');
console.log('  start.bat        (Windows)');
console.log('  npm start        (cross-platform)');
console.log('');
console.log('='.repeat(80));
