#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
DashScope API Key Retrieval Guide
"""

import os
import sys

def main():
    print("=" * 80)
    print("DashScope API Key Retrieval Guide")
    print("=" * 80)
    print()
    print("Since DashScope API Key management currently has no public OpenAPI interface,")
    print("please obtain it manually:")
    print()
    print("Method 1: Copy existing API Key from Bailian console")
    print("  1. Visit: https://bailian.console.aliyun.com/cn-beijing/#/efm/api_key")
    print("  2. Click the copy icon on the right side of any API Key")
    print("  3. Copy the complete API Key (format: sk-xxxxxxxxxxxx)")
    print()
    print("Method 2: Create new API Key")
    print("  1. Visit: https://bailian.console.aliyun.com/cn-beijing/#/efm/api_key")
    print("  2. Click the \"Create API Key\" button")
    print("  3. Fill in description (e.g., CosyVoice speech synthesis test)")
    print("  4. Click confirm, copy the generated API Key")
    print()
    print("=" * 80)
    print("After obtaining, use the following command to set environment variable:")
    print()
    if sys.platform == 'win32':
        print("  Windows (CMD):")
        print("    set DASHSCOPE_API_KEY=sk-xxxxxxxxxxxx")
        print()
        print("  Windows (PowerShell):")
        print("    $env:DASHSCOPE_API_KEY='sk-xxxxxxxxxxxx'")
    else:
        print("  macOS/Linux:")
        print("    export DASHSCOPE_API_KEY='sk-xxxxxxxxxxxx'")
    print()
    print("Then run the startup script:")
    print()
    print("  ./start.sh       (macOS/Linux)")
    print("  python3 start.py (cross-platform)")
    print("  start.bat        (Windows)")
    print()
    print("=" * 80)

if __name__ == "__main__":
    main()
