/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.util.Arrays;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.mllib.fpm.PrefixSpan;
import org.apache.spark.mllib.fpm.PrefixSpanModel;

public class JavaPrefixSpanExample {
    public static void main(String[] args) {
        SparkConf sparkConf = new SparkConf().setAppName("JavaPrefixSpanExample");
        JavaSparkContext sc = new JavaSparkContext(sparkConf);
        JavaRDD sequences = sc.parallelize(Arrays.asList(Arrays.asList(Arrays.asList(1, 2), Arrays.asList(3)), Arrays.asList(Arrays.asList(1), Arrays.asList(3, 2), Arrays.asList(1, 2)), Arrays.asList(Arrays.asList(1, 2), Arrays.asList(5)), Arrays.asList(Arrays.asList(6))), 2);
        PrefixSpan prefixSpan = new PrefixSpan().setMinSupport(0.5).setMaxPatternLength(5);
        PrefixSpanModel model = prefixSpan.run(sequences);
        for (PrefixSpan.FreqSequence freqSeq : model.freqSequences().toJavaRDD().collect()) {
            System.out.println(String.valueOf(freqSeq.javaSequence()) + ", " + freqSeq.freq());
        }
        sc.stop();
    }
}

