#!/bin/bash

CURR_DIR=`dirname "$0"`
SYNC_HOME=`cd "$CURR_DIR/.."; pwd`

CURRENT_VERSION=`ls $SYNC_HOME | grep "jar-with-dependencies.jar" | cut -d'-' -f4`

JAR_NAME="starrocks-cluster-sync-$CURRENT_VERSION-jar-with-dependencies.jar"
PID=$(ps -ef | grep "$JAR_NAME" | grep -v grep | awk '{print $2}')

if [ -z "$PID" ]; then
  echo "not found pid $PID"
else
  kill "$PID"
  sleep 1

  if ps -p "$PID" > /dev/null; then
    kill -9 "$PID"
  else
    echo "stop pid $PID success"
  fi
fi