namespace cpp starrocks
namespace java com.starrocks.thrift

include "Status.thrift"
include "Types.thrift"

struct TReplicaReplicationInfo {
    1: optional Types.TBackend src_backend
}

struct TTabletReplicationInfo {
    1: optional i64 tablet_id
    2: optional i64 src_tablet_id
    3: optional list<TReplicaReplicationInfo> replica_replication_infos
}

struct TIndexReplicationInfo {
    1: optional i64 index_id
    2: optional i32 src_schema_hash
    3: optional map<i64, TTabletReplicationInfo> tablet_replication_infos
}

struct TPartitionReplicationInfo {
    1: optional i64 partition_id
    2: optional i64 src_version
    3: optional map<i64, TIndexReplicationInfo> index_replication_infos
    4: optional i64 src_version_epoch
    5: optional i64 src_partition_id
}

struct TTableReplicationRequest {
    1: optional string username
    2: optional string password
    3: optional i64 database_id
    4: optional i64 table_id
    5: optional string src_token
    6: optional Types.TTableType src_table_type
    7: optional i64 src_table_data_size
    8: optional map<i64, TPartitionReplicationInfo> partition_replication_infos
    9: optional string job_id
    10: optional Types.TRunMode src_cluster_run_mode
    11: optional string src_storage_volume_name
    12: optional string src_service_id
    13: optional i64 src_database_id
    14: optional i64 src_table_id
}

struct TTableReplicationResponse {
    1: optional Status.TStatus status
}

service FrontendService {
    TTableReplicationResponse startTableReplication(1: TTableReplicationRequest request)
}
