/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.sync;

import com.google.common.base.Strings;
import com.starrocks.common.AESEncrypt;
import com.starrocks.common.Base64Util;
import com.starrocks.meta.ClusterInfo;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyncConf {
    private static final Logger LOG = LogManager.getLogger(SyncConf.class);
    private final boolean oneTimeRunMode;
    private final String sourceFeHost;
    private final int sourceQueryPort;
    private final String sourceClusterUser;
    private final String sourceClusterPassword;
    private final String sourceClusterToken;
    private final String targetFeHost;
    private final int targetQueryPort;
    private final String targetClusterUser;
    private final String targetClusterPassword;
    private final String targetClusterStorageVolume;
    private final int targetClusterReplicationNum;
    private final Boolean targetClusterEnablePersistentIndex;
    private final double targetClusterMaxDiskUsedPct;
    private final int jdbcConnectTimeoutMs;
    private final int jdbcSocketTimeoutMs;
    private final int maxReplicationDataSizePerJobInGB;
    private final int metaJobIntervalSeconds;
    private final int metaJobThreads;
    private final int ddlJobIntervalSeconds;
    private final int ddlJobBatchSize;
    private final boolean ddlJobAllowDropTargetOnly;
    private final boolean ddlJobAllowDropPartitionTargetOnly;
    private final boolean ddlJobAllowDropSchemaChangeTable;
    private final boolean ddlJobAllowDropInconsistentPartition;
    private final boolean ddlJobAllowDropInconsistentTimePartition;
    private final boolean enableMaterializedViewSync;
    private final boolean ddlJobAllowDropInconsistentMaterializedView;
    private final boolean ddlJobAllowDropMaterializedViewTargetOnly;
    private final boolean enableViewSync;
    private final boolean ddlJobAllowDropInconsistentView;
    private final boolean ddlJobAllowDropViewTargetOnly;
    private final boolean enableBitmapIndexSync;
    private final boolean ddlJobAllowDropInconsistentBitmapIndex;
    private final boolean ddlJobAllowDropBitmapIndexTargetOnly;
    private final boolean enableTablePropertySync;
    private final boolean useBuiltinStorageVolumeOnTarget;
    private final int replicationJobIntervalSeconds;
    private final int replicationJobBatchSize;
    private final int reportIntervalSeconds;
    private final boolean compactionEnable;
    private final int compactionJobIntervalSeconds;
    private final int compactionJobBatchSize;
    private final int httpPort;
    private final HashSet<String> includeDbs = new HashSet();
    private final HashSet<String> includeTables = new HashSet();
    private final HashSet<String> excludeDbs = new HashSet();
    private final HashSet<String> excludeTables = new HashSet();
    private final Map<String, HostMapping> sourceClusterHosts = new HashMap<String, HostMapping>();
    private final Map<String, HostMapping> targetClusterHosts = new HashMap<String, HostMapping>();

    public boolean isOneTimeRunMode() {
        return this.oneTimeRunMode;
    }

    public String getSourceFeHost() {
        return this.sourceFeHost;
    }

    public int getSourceQueryPort() {
        return this.sourceQueryPort;
    }

    public String getSourceClusterUser() {
        return this.sourceClusterUser;
    }

    public String getSourceClusterPassword() {
        return this.sourceClusterPassword;
    }

    public String getSourceClusterToken() {
        return this.sourceClusterToken;
    }

    public String getTargetFeHost() {
        return this.targetFeHost;
    }

    public int getTargetQueryPort() {
        return this.targetQueryPort;
    }

    public String getTargetClusterUser() {
        return this.targetClusterUser;
    }

    public String getTargetClusterPassword() {
        return this.targetClusterPassword;
    }

    public String getTargetClusterStorageVolume() {
        return this.targetClusterStorageVolume;
    }

    public int getTargetClusterReplicationNum() {
        return this.targetClusterReplicationNum;
    }

    public double getTargetClusterMaxDiskUsedPct() {
        return this.targetClusterMaxDiskUsedPct;
    }

    public int getJdbcConnectTimeoutMs() {
        return this.jdbcConnectTimeoutMs;
    }

    public int getJdbcSocketTimeoutMs() {
        return this.jdbcSocketTimeoutMs;
    }

    public int getMaxReplicationDataSizePerJobInGB() {
        return this.maxReplicationDataSizePerJobInGB;
    }

    public int getDdlJobIntervalSeconds() {
        return this.ddlJobIntervalSeconds;
    }

    public int getDdlJobBatchSize() {
        return this.ddlJobBatchSize;
    }

    public boolean isDdlJobAllowDropTargetOnly() {
        return this.ddlJobAllowDropTargetOnly;
    }

    public boolean isDdlJobAllowDropPartitionTargetOnly() {
        return this.ddlJobAllowDropPartitionTargetOnly;
    }

    public boolean isDdlJobAllowDropSchemaChangeTable() {
        return this.ddlJobAllowDropSchemaChangeTable;
    }

    public boolean isDdlJobAllowDropInconsistentPartition() {
        return this.ddlJobAllowDropInconsistentPartition;
    }

    public boolean isDdlJobAllowDropInconsistentTimePartition() {
        return this.ddlJobAllowDropInconsistentTimePartition;
    }

    public boolean isEnableBitmapIndexSync() {
        return this.enableBitmapIndexSync;
    }

    public boolean isDdlJobAllowDropBitmapIndexTargetOnly() {
        return this.ddlJobAllowDropBitmapIndexTargetOnly;
    }

    public boolean isDdlJobAllowDropInconsistentBitmapIndex() {
        return this.ddlJobAllowDropInconsistentBitmapIndex;
    }

    public boolean isEnableMaterializedViewSync() {
        return this.enableMaterializedViewSync;
    }

    public boolean isDdlJobAllowDropMaterializedViewTargetOnly() {
        return this.ddlJobAllowDropMaterializedViewTargetOnly;
    }

    public boolean isDdlJobAllowDropInconsistentMaterializedView() {
        return this.ddlJobAllowDropInconsistentMaterializedView;
    }

    public boolean isEnableViewSync() {
        return this.enableViewSync;
    }

    public boolean isDdlJobAllowDropViewTargetOnly() {
        return this.ddlJobAllowDropViewTargetOnly;
    }

    public boolean isDdlJobAllowDropInconsistentView() {
        return this.ddlJobAllowDropInconsistentView;
    }

    public boolean isEnableTablePropertySync() {
        return this.enableTablePropertySync;
    }

    public boolean isUseBuiltinStorageVolumeOnTarget() {
        return this.useBuiltinStorageVolumeOnTarget;
    }

    public int getReplicationJobIntervalSeconds() {
        return this.replicationJobIntervalSeconds;
    }

    public int getReplicationJobBatchSize() {
        return this.replicationJobBatchSize;
    }

    public int getReportIntervalSeconds() {
        return this.reportIntervalSeconds;
    }

    public boolean isCompactionEnable() {
        return this.compactionEnable;
    }

    public int getCompactionJobIntervalSeconds() {
        return this.compactionJobIntervalSeconds;
    }

    public int getCompactionJobBatchSize() {
        return this.compactionJobBatchSize;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getMetaJobIntervalSeconds() {
        return this.metaJobIntervalSeconds;
    }

    public int getMetaJobThreads() {
        return this.metaJobThreads;
    }

    public HashSet<String> getIncludeDbs() {
        return this.includeDbs;
    }

    public HashSet<String> getIncludeTables() {
        return this.includeTables;
    }

    public HashSet<String> getExcludeDbs() {
        return this.excludeDbs;
    }

    public HashSet<String> getExcludeTables() {
        return this.excludeTables;
    }

    public Map<String, HostMapping> getSourceClusterHosts() {
        return this.sourceClusterHosts;
    }

    public Map<String, HostMapping> getTargetClusterHosts() {
        return this.targetClusterHosts;
    }

    public HostMapping getHostMapping(ClusterInfo.Type type, String host) {
        HostMapping mapping;
        HostMapping hostMapping = mapping = type == ClusterInfo.Type.SOURCE ? this.sourceClusterHosts.get(host) : this.targetClusterHosts.get(host);
        if (mapping == null) {
            return new IdentityHostMapping(host);
        }
        if (mapping.getMappedHost().isEmpty()) {
            return new IdentityHostMapping(host);
        }
        return mapping;
    }

    public Boolean isTargetClusterEnablePersistentIndex() {
        return this.targetClusterEnablePersistentIndex;
    }

    public boolean shouldKeepDb(String db) {
        boolean result;
        boolean include = true;
        boolean exclude = false;
        if (!this.includeDbs.isEmpty() && !this.includeDbs.contains(db)) {
            include = false;
        }
        if (!this.excludeDbs.isEmpty() && this.excludeDbs.contains(db)) {
            exclude = true;
        }
        boolean bl = result = include && !exclude;
        if (!result) {
            LOG.debug("Ignore database {} due to job configuration, include->{}, exclude->{}.", (Object)db, (Object)include, (Object)exclude);
        }
        return result;
    }

    public boolean shouldKeepTable(String db, String table) {
        boolean result;
        String key = db + "." + table;
        boolean include = true;
        boolean exclude = false;
        if (!(this.includeTables.isEmpty() || this.includeTables.contains(key) || this.includeTables.contains(db + ".*"))) {
            include = false;
        }
        if (!this.excludeTables.isEmpty() && this.excludeTables.contains(key) || !this.excludeDbs.isEmpty() && this.excludeDbs.contains(db)) {
            exclude = true;
        }
        boolean bl = result = include && !exclude;
        if (!result) {
            LOG.debug("Ignore table {}.{} due to job configuration, include->{}, exclude->{}.", (Object)db, (Object)table, (Object)include, (Object)exclude);
        }
        return result;
    }

    private void initIncludeAndExclude(Properties syncConf) {
        String includeConfig = syncConf.getProperty("include_data_list", "");
        String excludeConfig = syncConf.getProperty("exclude_data_list", "");
        Arrays.stream(includeConfig.split(",")).forEach(include -> {
            String item = include.trim();
            if (!item.isEmpty()) {
                if (item.contains(".")) {
                    this.includeDbs.add(item.split("\\.")[0]);
                    this.includeTables.add(item);
                } else {
                    this.includeDbs.add(item);
                    this.includeTables.add(item + ".*");
                }
            }
        });
        Arrays.stream(excludeConfig.split(",")).forEach(exclude -> {
            String item = exclude.trim();
            if (!item.isEmpty()) {
                if (item.contains(".")) {
                    this.excludeTables.add(item);
                } else {
                    this.excludeDbs.add(item);
                }
            }
        });
    }

    private void initHosts(Properties hostsProperties) {
        if (hostsProperties == null) {
            return;
        }
        for (String k : hostsProperties.stringPropertyNames()) {
            HostMapping mapping;
            String value = hostsProperties.getProperty(k).trim();
            if (k.startsWith("SOURCE_") && (mapping = this.parseHostMapping(k, value)) != null) {
                this.sourceClusterHosts.put(k.replace("SOURCE_", ""), mapping);
            }
            if (!k.startsWith("TARGET_") || (mapping = this.parseHostMapping(k, value)) == null) continue;
            this.targetClusterHosts.put(k.replace("TARGET_", ""), mapping);
        }
    }

    private HostMapping parseHostMapping(String key, String value) {
        String portPart;
        if (value.isEmpty()) {
            LOG.warn("Empty host mapping for {}.", (Object)key);
            return null;
        }
        String[] parts = value.split(";", 2);
        String mappedHost = parts[0].trim();
        if (mappedHost.isEmpty()) {
            LOG.warn("Invalid host mapping for {}.", (Object)key);
            return null;
        }
        HashMap<Integer, Integer> portMapping = new HashMap<Integer, Integer>();
        if (parts.length > 1 && !(portPart = parts[1].trim()).isEmpty()) {
            String[] entries;
            for (String entry : entries = portPart.split(",")) {
                String trimmed = entry.trim();
                if (trimmed.isEmpty()) continue;
                String[] ports = trimmed.split(":", 2);
                if (ports.length != 2) {
                    LOG.warn("Invalid port mapping '{}' for {}.", (Object)trimmed, (Object)key);
                    continue;
                }
                try {
                    int srcPort = Integer.parseInt(ports[0].trim());
                    int dstPort = Integer.parseInt(ports[1].trim());
                    portMapping.put(srcPort, dstPort);
                }
                catch (NumberFormatException e) {
                    LOG.warn("Invalid port mapping '{}' for {}.", (Object)trimmed, (Object)key);
                }
            }
        }
        return new ConfiguredHostMapping(mappedHost, portMapping);
    }

    public SyncConf(Properties syncProperties, Properties hostsProperties) {
        this.oneTimeRunMode = Boolean.parseBoolean(syncProperties.getProperty("one_time_run_mode", "false"));
        this.sourceFeHost = syncProperties.getProperty("source_fe_host").trim();
        this.sourceQueryPort = Integer.parseInt(syncProperties.getProperty("source_fe_query_port").trim());
        this.sourceClusterUser = syncProperties.getProperty("source_cluster_user").trim();
        String sourceClusterPassword = syncProperties.getProperty("source_cluster_password").trim();
        String sourcePasswordSecretKey = syncProperties.getProperty("source_cluster_password_secret_key", "").trim();
        this.sourceClusterPassword = sourcePasswordSecretKey.isEmpty() ? sourceClusterPassword : new String(AESEncrypt.decrypt(Base64Util.decode(sourceClusterPassword), sourcePasswordSecretKey.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        this.sourceClusterToken = syncProperties.getProperty("source_cluster_token").trim();
        this.targetFeHost = syncProperties.getProperty("target_fe_host").trim();
        this.targetQueryPort = Integer.parseInt(syncProperties.getProperty("target_fe_query_port").trim());
        this.targetClusterUser = syncProperties.getProperty("target_cluster_user").trim();
        String targetClusterPassword = syncProperties.getProperty("target_cluster_password").trim();
        String targetPasswordSecretKey = syncProperties.getProperty("target_cluster_password_secret_key", "").trim();
        this.targetClusterPassword = targetPasswordSecretKey.isEmpty() ? targetClusterPassword : new String(AESEncrypt.decrypt(Base64Util.decode(targetClusterPassword), targetPasswordSecretKey.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        this.targetClusterStorageVolume = syncProperties.getProperty("target_cluster_storage_volume", "");
        this.targetClusterReplicationNum = Integer.parseInt(syncProperties.getProperty("target_cluster_replication_num", "-1"));
        String persistentIdxKey = syncProperties.getProperty("target_cluster_enable_persistent_index", null);
        this.targetClusterEnablePersistentIndex = Strings.isNullOrEmpty(persistentIdxKey) ? null : Boolean.valueOf(Boolean.parseBoolean(persistentIdxKey.trim()));
        this.targetClusterMaxDiskUsedPct = Double.parseDouble(syncProperties.getProperty("target_cluster_max_disk_used_percent", "90"));
        this.jdbcConnectTimeoutMs = Integer.parseInt(syncProperties.getProperty("jdbc_connect_timeout_ms", "30000"));
        this.jdbcSocketTimeoutMs = Integer.parseInt(syncProperties.getProperty("jdbc_socket_timeout_ms", "60000"));
        this.maxReplicationDataSizePerJobInGB = Integer.parseInt(syncProperties.getProperty("max_replication_data_size_per_job_in_gb", "1024"));
        this.metaJobIntervalSeconds = Integer.parseInt(syncProperties.getProperty("meta_job_interval_seconds").trim());
        this.metaJobThreads = Integer.parseInt(syncProperties.getProperty("meta_job_threads", "4").trim());
        this.ddlJobIntervalSeconds = Integer.parseInt(syncProperties.getProperty("ddl_job_interval_seconds").trim());
        this.ddlJobBatchSize = Integer.parseInt(syncProperties.getProperty("ddl_job_batch_size").trim());
        this.ddlJobAllowDropTargetOnly = Boolean.parseBoolean(syncProperties.getProperty("ddl_job_allow_drop_target_only", "false").trim());
        this.ddlJobAllowDropPartitionTargetOnly = Boolean.parseBoolean(syncProperties.getProperty("ddl_job_allow_drop_partition_target_only", "true").trim());
        this.ddlJobAllowDropSchemaChangeTable = Boolean.parseBoolean(syncProperties.getProperty("ddl_job_allow_drop_schema_change_table", "true").trim());
        this.ddlJobAllowDropInconsistentPartition = Boolean.parseBoolean(syncProperties.getProperty("ddl_job_allow_drop_inconsistent_partition", "true").trim());
        this.ddlJobAllowDropInconsistentTimePartition = Boolean.parseBoolean(syncProperties.getProperty("ddl_job_allow_drop_inconsistent_time_partition", "true").trim());
        this.enableMaterializedViewSync = Boolean.parseBoolean(syncProperties.getProperty("enable_materialized_view_sync", "true").trim());
        this.ddlJobAllowDropInconsistentMaterializedView = Boolean.parseBoolean(syncProperties.getProperty("ddl_job_allow_drop_inconsistent_materialized_view", "true").trim());
        this.ddlJobAllowDropMaterializedViewTargetOnly = Boolean.parseBoolean(syncProperties.getProperty("ddl_job_allow_drop_materialized_view_target_only", "false").trim());
        this.enableViewSync = Boolean.parseBoolean(syncProperties.getProperty("enable_view_sync", "true").trim());
        this.ddlJobAllowDropInconsistentView = Boolean.parseBoolean(syncProperties.getProperty("ddl_job_allow_drop_inconsistent_view", "true").trim());
        this.ddlJobAllowDropViewTargetOnly = Boolean.parseBoolean(syncProperties.getProperty("ddl_job_allow_drop_view_target_only", "false").trim());
        this.enableBitmapIndexSync = Boolean.parseBoolean(syncProperties.getProperty("enable_bitmap_index_sync", "false").trim());
        this.ddlJobAllowDropInconsistentBitmapIndex = Boolean.parseBoolean(syncProperties.getProperty("ddl_job_allow_drop_inconsistent_bitmap_index", "true").trim());
        this.ddlJobAllowDropBitmapIndexTargetOnly = Boolean.parseBoolean(syncProperties.getProperty("ddl_job_allow_drop_bitmap_index_target_only", "true").trim());
        this.enableTablePropertySync = Boolean.parseBoolean(syncProperties.getProperty("enable_table_property_sync", "false").trim());
        this.useBuiltinStorageVolumeOnTarget = Boolean.parseBoolean(syncProperties.getProperty("target_cluster_use_builtin_storage_volume_only", "true").trim());
        this.replicationJobIntervalSeconds = Integer.parseInt(syncProperties.getProperty("replication_job_interval_seconds").trim());
        this.replicationJobBatchSize = Integer.parseInt(syncProperties.getProperty("replication_job_batch_size").trim());
        this.reportIntervalSeconds = Integer.parseInt(syncProperties.getProperty("report_interval_seconds").trim());
        this.compactionEnable = Boolean.parseBoolean(syncProperties.getProperty("compaction_enable", "false").trim());
        this.compactionJobIntervalSeconds = Integer.parseInt(syncProperties.getProperty("compaction_job_interval_seconds", "-1").trim());
        this.compactionJobBatchSize = Integer.parseInt(syncProperties.getProperty("compaction_job_batch_size", "-1").trim());
        this.httpPort = Integer.parseInt(syncProperties.getProperty("http_port", "-1").trim());
        this.initIncludeAndExclude(syncProperties);
        this.initHosts(hostsProperties);
    }

    public static class IdentityHostMapping
    implements HostMapping {
        private final String host;

        public IdentityHostMapping(String host) {
            this.host = host;
        }

        @Override
        public String getMappedHost() {
            return this.host;
        }

        @Override
        public int getMappedPort(int originalPort) {
            return originalPort;
        }

        public String toString() {
            return "HostMapping{mappedHost='" + this.host + "', mappedPorts={}}";
        }
    }

    public static class ConfiguredHostMapping
    implements HostMapping {
        private final String mappedHost;
        private final Map<Integer, Integer> mappedPorts;

        public ConfiguredHostMapping(String mappedHost, Map<Integer, Integer> mappedPorts) {
            this.mappedHost = mappedHost;
            this.mappedPorts = mappedPorts;
        }

        @Override
        public String getMappedHost() {
            return this.mappedHost;
        }

        @Override
        public int getMappedPort(int originalPort) {
            Integer mappedPort = this.mappedPorts.get(originalPort);
            return mappedPort == null ? originalPort : mappedPort;
        }

        public String toString() {
            return "HostMapping{mappedHost='" + this.mappedHost + "', mappedPorts=" + this.mappedPorts + "}";
        }
    }

    public static interface HostMapping {
        public String getMappedHost();

        public int getMappedPort(int var1);
    }
}

