/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.sync;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.starrocks.common.Utils;
import com.starrocks.meta.ClusterInfo;
import com.starrocks.thrift.TBackend;
import com.starrocks.thrift.TIndexReplicationInfo;
import com.starrocks.thrift.TPartitionReplicationInfo;
import com.starrocks.thrift.TReplicaReplicationInfo;
import com.starrocks.thrift.TRunMode;
import com.starrocks.thrift.TTableReplicationRequest;
import com.starrocks.thrift.TTableType;
import com.starrocks.thrift.TTabletReplicationInfo;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplicationJob {
    private static final Logger LOG = LogManager.getLogger(ReplicationJob.class);
    private final String userName;
    private final String password;
    private final String srcToken;
    private final String jobId;
    private final long databaseId;
    private final long tableId;
    private final String dbName;
    private final String tableName;
    private final TTableType srcTableType;
    private final long srcTableDataSize;
    private final List<PartitionInfo> partitionInfos;
    private final TRunMode srcClusterRunMode;
    private final String srcStorageVolumeName;
    private final String srcServiceId;
    private final long srcDatabaseId;
    private final long srcTableId;

    public ReplicationJob(String jobId, String userName, String password, String srcToken, long databaseId, long tableId, String dbName, String tableName, TTableType srcTableType, long srcTableDataSize, List<PartitionInfo> partitionInfos, ClusterInfo.RunMode runMode, String srcServiceId, String srcStorageVolumeName, long srcDatabaseId, long srcTableId) {
        this.jobId = jobId;
        this.userName = userName;
        this.password = password;
        this.srcToken = srcToken;
        this.databaseId = databaseId;
        this.tableId = tableId;
        this.dbName = dbName;
        this.tableName = tableName;
        this.partitionInfos = partitionInfos;
        this.srcTableType = srcTableType;
        this.srcTableDataSize = srcTableDataSize;
        this.srcClusterRunMode = ClusterInfo.toTRunMode(runMode);
        this.srcServiceId = srcServiceId;
        this.srcStorageVolumeName = srcStorageVolumeName;
        this.srcDatabaseId = srcDatabaseId;
        this.srcTableId = srcTableId;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getJobToken() {
        return this.databaseId + "-" + this.tableId + "_" + this.jobId;
    }

    public long getSrcTableDataSize() {
        return this.srcTableDataSize;
    }

    public String toString() {
        String json = Utils.toJson(this);
        JsonObject jsonObject = JsonParser.parseString(json).getAsJsonObject();
        jsonObject.addProperty("password", "xxx");
        jsonObject.addProperty("srcToken", "xxx");
        Gson gson = new Gson();
        return gson.toJson(jsonObject);
    }

    public TTableReplicationRequest toThrift() {
        TTableReplicationRequest request = new TTableReplicationRequest();
        request.setUsername(this.userName);
        request.setPassword(this.password);
        request.setSrc_token(this.srcToken);
        request.setJob_id(this.jobId);
        request.setDatabase_id(this.databaseId);
        request.setSrc_table_type(this.srcTableType);
        request.setSrc_table_data_size(this.srcTableDataSize);
        request.setTable_id(this.tableId);
        request.setSrc_cluster_run_mode(this.srcClusterRunMode);
        request.setSrc_storage_volume_name(this.srcStorageVolumeName);
        request.setSrc_service_id(this.srcServiceId);
        request.setSrc_database_id(this.srcDatabaseId);
        request.setSrc_table_id(this.srcTableId);
        for (PartitionInfo partitionInfo : this.partitionInfos) {
            request.putToPartition_replication_infos(partitionInfo.partitionId, partitionInfo.toThrift());
        }
        LOG.debug("Wrapped table replicate request: {}", (Object)Utils.toJson(request));
        return request;
    }

    public static class BackendInfo {
        private final String host;
        private final int bePort;
        private final int httpPort;

        public BackendInfo(String host, int bePort, int httpPort) {
            this.host = host;
            this.bePort = bePort;
            this.httpPort = httpPort;
        }

        public String toString() {
            return Utils.toJson(this);
        }

        public TBackend toThrift() {
            TBackend tBackend = new TBackend();
            tBackend.setHost(this.host);
            tBackend.setBe_port(this.bePort);
            tBackend.setHttp_port(this.httpPort);
            return tBackend;
        }
    }

    public static class ReplicaInfo {
        private final BackendInfo srcBackend;

        public ReplicaInfo(BackendInfo srcBackend) {
            this.srcBackend = srcBackend;
        }

        public String toString() {
            return Utils.toJson(this);
        }

        public TReplicaReplicationInfo toThrift() {
            TReplicaReplicationInfo tReplicaReplicationInfo = new TReplicaReplicationInfo();
            tReplicaReplicationInfo.setSrc_backend(this.srcBackend.toThrift());
            return tReplicaReplicationInfo;
        }
    }

    public static class TabletInfo {
        private final long tabletId;
        private final long srcTabletId;
        private final List<ReplicaInfo> replicaInfos;

        public TabletInfo(long tabletId, long srcTabletId, List<ReplicaInfo> replicaInfos) {
            this.tabletId = tabletId;
            this.srcTabletId = srcTabletId;
            this.replicaInfos = replicaInfos;
        }

        public String toString() {
            return Utils.toJson(this);
        }

        public TTabletReplicationInfo toThrift() {
            TTabletReplicationInfo tTabletReplicationInfo = new TTabletReplicationInfo();
            tTabletReplicationInfo.setTablet_id(this.tabletId);
            tTabletReplicationInfo.setSrc_tablet_id(this.srcTabletId);
            for (ReplicaInfo replicaInfo : this.replicaInfos) {
                tTabletReplicationInfo.addToReplica_replication_infos(replicaInfo.toThrift());
            }
            return tTabletReplicationInfo;
        }
    }

    public static class IndexInfo {
        private final long indexId;
        private final int srcSchemaHash;
        private final List<TabletInfo> tabletInfos;

        public IndexInfo(long indexId, int srcSchemaHash, List<TabletInfo> tabletInfos) {
            this.indexId = indexId;
            this.srcSchemaHash = srcSchemaHash;
            this.tabletInfos = tabletInfos;
        }

        public String toString() {
            return Utils.toJson(this);
        }

        public TIndexReplicationInfo toThrift() {
            TIndexReplicationInfo tIndexReplicationInfo = new TIndexReplicationInfo();
            tIndexReplicationInfo.setIndex_id(this.indexId);
            tIndexReplicationInfo.setSrc_schema_hash(this.srcSchemaHash);
            for (TabletInfo tabletInfo : this.tabletInfos) {
                tIndexReplicationInfo.putToTablet_replication_infos(tabletInfo.tabletId, tabletInfo.toThrift());
            }
            return tIndexReplicationInfo;
        }
    }

    public static class PartitionInfo {
        private final long partitionId;
        private final long srcPartitionId;
        private final long srcVersion;
        private final List<IndexInfo> indexInfos;

        public PartitionInfo(long partitionId, long srcVersion, List<IndexInfo> indexInfos, long srcPartitionId) {
            this.partitionId = partitionId;
            this.srcVersion = srcVersion;
            this.indexInfos = indexInfos;
            this.srcPartitionId = srcPartitionId;
        }

        public String toString() {
            return Utils.toJson(this);
        }

        public TPartitionReplicationInfo toThrift() {
            TPartitionReplicationInfo tPartitionReplicationInfo = new TPartitionReplicationInfo();
            tPartitionReplicationInfo.setPartition_id(this.partitionId);
            tPartitionReplicationInfo.setSrc_version(this.srcVersion);
            for (IndexInfo indexInfo : this.indexInfos) {
                tPartitionReplicationInfo.putToIndex_replication_infos(indexInfo.indexId, indexInfo.toThrift());
            }
            tPartitionReplicationInfo.setSrc_partition_id(this.srcPartitionId);
            return tPartitionReplicationInfo;
        }
    }
}

