/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.sync;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mysql.cj.util.StringUtils;
import com.starrocks.common.Utils;
import com.starrocks.meta.Backend;
import com.starrocks.meta.BitmapIndex;
import com.starrocks.meta.ClusterInfo;
import com.starrocks.meta.Database;
import com.starrocks.meta.Frontend;
import com.starrocks.meta.Index;
import com.starrocks.meta.IndexSchema;
import com.starrocks.meta.MaterializedView;
import com.starrocks.meta.Partition;
import com.starrocks.meta.Replica;
import com.starrocks.meta.Table;
import com.starrocks.meta.Tablet;
import com.starrocks.meta.TransactionState;
import com.starrocks.meta.Version;
import com.starrocks.meta.View;
import com.starrocks.sync.ReplicationJob;
import com.starrocks.sync.SyncConf;
import com.starrocks.sync.SyncJob;
import com.starrocks.thrift.TTableType;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClusterMetaKeeper {
    private static final Logger LOG = LogManager.getLogger(ClusterMetaKeeper.class);
    private long replicationJobId = 0L;
    private final ClusterInfo sourceClusterInfo;
    private final ClusterInfo targetClusterInfo;
    private final SyncJob syncJob;
    private final SyncConf syncConf;
    private final ExecutorService metaExecutorService;
    private final Map<String, Integer> skippedReplicationTables;
    private final Set<String> dynamicSkippedReplicationTables;
    private final Set<String> partialReplicationTables;

    public ClusterMetaKeeper(SyncJob syncJob) {
        this.syncJob = syncJob;
        this.syncConf = syncJob.getSyncConf();
        this.sourceClusterInfo = new ClusterInfo(ClusterInfo.Type.SOURCE, this.syncConf.getSourceClusterUser(), this.syncConf.getSourceClusterPassword(), this.syncConf.getSourceClusterToken());
        this.targetClusterInfo = new ClusterInfo(ClusterInfo.Type.TARGET, this.syncConf.getTargetClusterUser(), this.syncConf.getTargetClusterPassword(), "");
        int metaJobThreads = this.syncConf.getMetaJobThreads() > 0 ? this.syncConf.getMetaJobThreads() : Runtime.getRuntime().availableProcessors();
        this.metaExecutorService = Executors.newFixedThreadPool(metaJobThreads, new ThreadFactoryBuilder().setDaemon(false).setNameFormat("meta-collector-%d").build());
        this.skippedReplicationTables = new ConcurrentHashMap<String, Integer>();
        this.dynamicSkippedReplicationTables = Collections.newSetFromMap(new ConcurrentHashMap());
        this.partialReplicationTables = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public void updateClusterMeta() throws InterruptedException {
        Thread sourceMetaCollector = new Thread(() -> {
            this.syncJob.setSourceClusterMetaUpdated(false);
            LOG.info("Source cluster metadata synchronization started.");
            long start = System.currentTimeMillis();
            this.updateBasicMeta(this.syncConf.getSourceFeHost(), this.syncConf.getSourceQueryPort(), this.sourceClusterInfo);
            this.updateDataMeta(this.sourceClusterInfo);
            long end = System.currentTimeMillis();
            LOG.info("Source cluster metadata synchronization completed, elapsed: {}.", (Object)Utils.convertMillisecondsToMinutesAndSeconds(end - start));
            this.syncJob.setSourceClusterMetaUpdated(true);
        });
        sourceMetaCollector.setName("source-cluster-meta-collector");
        Thread targetMetaCollector = new Thread(() -> {
            this.syncJob.setTargetClusterMetaUpdated(false);
            LOG.info("Target cluster metadata synchronization started.");
            long start = System.currentTimeMillis();
            this.updateBasicMeta(this.syncConf.getTargetFeHost(), this.syncConf.getTargetQueryPort(), this.targetClusterInfo);
            this.updateDataMeta(this.targetClusterInfo);
            long end = System.currentTimeMillis();
            LOG.info("Target cluster metadata synchronization completed, elapsed: {}.", (Object)Utils.convertMillisecondsToMinutesAndSeconds(end - start));
            this.syncJob.setTargetClusterMetaUpdated(true);
        });
        targetMetaCollector.setName("target-cluster-meta-collector");
        sourceMetaCollector.start();
        targetMetaCollector.start();
        sourceMetaCollector.join();
        targetMetaCollector.join();
    }

    public void produceDDL() {
        this.handleDbDDL();
        this.handleTableDDL();
        this.handlePartitionDDL();
        this.handleMaterializedViewDDL();
        this.handleViewDDL();
    }

    public void produceReplicationJob() {
        long maxReplicationDataSize = (long)(this.syncConf.getMaxReplicationDataSizePerJobInGB() * 1024 * 1024) * 1024L;
        this.dynamicSkippedReplicationTables.clear();
        this.partialReplicationTables.clear();
        ArrayList<ReplicationJob> replicationJobs = new ArrayList<ReplicationJob>();
        Set<String> srcDbNames = this.sourceClusterInfo.getDbNames();
        Set<String> targetDbNames = this.targetClusterInfo.getDbNames();
        Set<String> commonDbNames = Utils.setIntersection(srcDbNames, targetDbNames);
        for (String dbName : commonDbNames) {
            Database srcDb = this.sourceClusterInfo.getDb(dbName);
            Database targetDb = this.targetClusterInfo.getDb(dbName);
            Set<String> srcTableNames = srcDb.getTableNames();
            Set<String> targetTableNames = targetDb.getTableNames();
            Set<String> commonTableNames = Utils.setIntersection(srcTableNames, targetTableNames);
            for (String tableName : commonTableNames) {
                Object srcPartition;
                Table srcTable = this.sourceClusterInfo.getDb(dbName).getTable(tableName);
                Table targetTable = this.targetClusterInfo.getDb(dbName).getTable(tableName);
                Set<String> srcPartitionNames = srcTable.getReadyPartitionNames();
                Set<String> targetPartitionNames = targetTable.getReadyPartitionNames();
                ArrayList<String> commonPartitionNames = new ArrayList<String>(Utils.setIntersection(srcPartitionNames, targetPartitionNames));
                boolean isDynamicPartitionTable = this.targetClusterInfo.getDb(dbName).getTable(tableName).isDynamicPartitionTable();
                ArrayList<Long> sourceVisibleVersionTimes = new ArrayList<Long>();
                ArrayList<Integer> commonPartitionIndices = new ArrayList<Integer>();
                for (int i = 0; i < commonPartitionNames.size(); ++i) {
                    srcPartition = this.sourceClusterInfo.getDb(dbName).getTable(tableName).getPartition((String)commonPartitionNames.get(i));
                    sourceVisibleVersionTimes.add(((Partition)srcPartition).getVisibleVersionTime());
                    commonPartitionIndices.add(i);
                }
                commonPartitionIndices.sort(Comparator.comparing(sourceVisibleVersionTimes::get));
                ArrayList sortedCommonPartitionNames = new ArrayList();
                srcPartition = commonPartitionIndices.iterator();
                while (srcPartition.hasNext()) {
                    int i = (Integer)srcPartition.next();
                    sortedCommonPartitionNames.add(commonPartitionNames.get(i));
                }
                long totalDataSize = 0L;
                ArrayList<ReplicationJob.PartitionInfo> partitionInfos = new ArrayList<ReplicationJob.PartitionInfo>();
                for (String partitionName : sortedCommonPartitionNames) {
                    Partition targetPartition;
                    Partition srcPartition2;
                    if (!this.checkPartitionVersion(dbName, tableName, partitionName, srcPartition2 = this.sourceClusterInfo.getDb(dbName).getTable(tableName).getPartition(partitionName), targetPartition = this.targetClusterInfo.getDb(dbName).getTable(tableName).getPartition(partitionName), targetTable.getPartitionType(), isDynamicPartitionTable)) continue;
                    if (srcPartition2.getVisibleVersion() == targetPartition.getVisibleVersion() && (this.sourceClusterInfo.getClusterRunMode() == ClusterInfo.RunMode.SHARED_DATA || this.targetClusterInfo.getClusterRunMode() == ClusterInfo.RunMode.SHARED_DATA || srcPartition2.getVisibleVersionTime() < targetPartition.getVisibleVersionTime())) {
                        LOG.debug("Ignore the same version partition. dbName: {}, tableName: {} partitionName: {},srcVersion: {}, targetVersion: {}, srcVersionTime: {}, targetVersionTime: {}", (Object)dbName, (Object)tableName, (Object)partitionName, (Object)srcPartition2.getVisibleVersion(), (Object)targetPartition.getVisibleVersion(), (Object)srcPartition2.getVisibleVersionTime(), (Object)targetPartition.getVisibleVersionTime());
                        continue;
                    }
                    Set<String> srcIndexNames = srcPartition2.getIndexNames();
                    Set<String> targetIndexNames = targetPartition.getIndexNames();
                    Set<String> commonIndexNames = Utils.setIntersection(srcIndexNames, targetIndexNames);
                    ArrayList<ReplicationJob.IndexInfo> indexInfos = new ArrayList<ReplicationJob.IndexInfo>();
                    for (String indexName : commonIndexNames) {
                        Index srcIndex = srcPartition2.getIndex(indexName);
                        Index targetIndex = targetPartition.getIndex(indexName);
                        if (srcIndex.getTablets().size() != targetIndex.getTablets().size()) {
                            LOG.error("Failed to check the bucket number. source->{}, target->{}, db->{}, table->{}, partition->{}, index->{}", (Object)srcIndex.getTablets().size(), (Object)targetIndex.getTablets().size(), (Object)dbName, (Object)tableName, (Object)partitionName, (Object)indexName);
                            continue;
                        }
                        ArrayList<ReplicationJob.TabletInfo> tabletInfos = new ArrayList<ReplicationJob.TabletInfo>();
                        int bucketNum = srcIndex.getTablets().size();
                        for (int i = 0; i < bucketNum; ++i) {
                            Tablet srcTablet = srcIndex.getTablets().get(i);
                            Tablet targetTablet = targetIndex.getTablets().get(i);
                            ArrayList<ReplicationJob.ReplicaInfo> replicaInfos = new ArrayList<ReplicationJob.ReplicaInfo>();
                            int replicaNum = srcTablet.getReplicas().size();
                            for (int j = 0; j < replicaNum; ++j) {
                                Replica srcReplica = srcTablet.getReplicas().get(j);
                                Backend srcBackend = this.sourceClusterInfo.getBackend(srcReplica.getBackendId());
                                if (srcBackend == null) {
                                    LOG.error("Failed to get source backend info for tablet {} and backend ID {}. Detail: db->{}, table->{}, partition->{}, index->{}", (Object)srcTablet.getTabletId(), (Object)srcReplica.getBackendId(), (Object)dbName, (Object)tableName, (Object)partitionName, (Object)indexName);
                                    continue;
                                }
                                ReplicationJob.BackendInfo srcBackendInfo = new ReplicationJob.BackendInfo(srcBackend.getHost(), srcBackend.getBePort(), srcBackend.getHttpPort());
                                ReplicationJob.ReplicaInfo replicaInfo = new ReplicationJob.ReplicaInfo(srcBackendInfo);
                                replicaInfos.add(replicaInfo);
                            }
                            ReplicationJob.TabletInfo tabletInfo = new ReplicationJob.TabletInfo(targetTablet.getTabletId(), srcTablet.getTabletId(), replicaInfos);
                            tabletInfos.add(tabletInfo);
                        }
                        IndexSchema schema = srcTable.getIndexSchema(srcIndex.getIndexId());
                        ReplicationJob.IndexInfo indexInfo = new ReplicationJob.IndexInfo(targetIndex.getIndexId(), schema.getSchemaHash(), tabletInfos);
                        indexInfos.add(indexInfo);
                    }
                    if (indexInfos.isEmpty()) continue;
                    ReplicationJob.PartitionInfo partitionInfo = new ReplicationJob.PartitionInfo(targetPartition.getPartitionId(), srcPartition2.getVisibleVersion(), indexInfos, srcPartition2.getPartitionId());
                    LOG.debug("Add partition {} to replication job. ", (Object)partitionInfo);
                    partitionInfos.add(partitionInfo);
                    if (maxReplicationDataSize <= 0L || (totalDataSize += Math.abs(targetPartition.getDataSize() - srcPartition2.getDataSize())) <= maxReplicationDataSize) continue;
                    LOG.info("Skip some partitions of {} due to exceeding the maximum replication data size {} GB.", (Object)(dbName + "." + tableName), (Object)this.syncConf.getMaxReplicationDataSizePerJobInGB());
                    this.partialReplicationTables.add(dbName + "." + tableName);
                    break;
                }
                if (!partitionInfos.isEmpty()) {
                    String fakedSourceStorageVolumeName = null;
                    if (this.sourceClusterInfo.getClusterRunMode() == ClusterInfo.RunMode.SHARED_DATA) {
                        String sourceStorageVolumeName = srcTable.getPropertyValue("storage_volume");
                        if (sourceStorageVolumeName == null) {
                            LOG.error("Failed to get source storage volume name for table {}.", (Object)(dbName + "." + tableName));
                            continue;
                        }
                        if (!this.sourceClusterInfo.getStorageVolumes().contains(sourceStorageVolumeName)) {
                            LOG.error("Source storage volume {} is blocked for replication, skip this table {}", (Object)sourceStorageVolumeName, (Object)(dbName + "." + tableName));
                            continue;
                        }
                        fakedSourceStorageVolumeName = "src_" + sourceStorageVolumeName;
                        if (!this.targetClusterInfo.getStorageVolumes().contains(fakedSourceStorageVolumeName)) {
                            LOG.error("Failed to find faked source storage volume name {} for table {} on target cluster.", (Object)fakedSourceStorageVolumeName, (Object)(dbName + "." + tableName));
                            System.exit(-1);
                        }
                    }
                    ReplicationJob replicationJob = new ReplicationJob(this.getReplicationJobId(), this.targetClusterInfo.getUserName(), this.targetClusterInfo.getPassword(), this.sourceClusterInfo.getToken(), targetDb.getDbId(), targetTable.getTableId(), targetDb.getDbName(), targetTable.getTableName(), srcTable.getTableType(), srcTable.getDataSize(), partitionInfos, this.sourceClusterInfo.getClusterRunMode(), this.sourceClusterInfo.getServiceId(), fakedSourceStorageVolumeName, srcDb.getDbId(), srcTable.getTableId());
                    replicationJobs.add(replicationJob);
                    continue;
                }
                if (sortedCommonPartitionNames.isEmpty()) continue;
                this.skippedReplicationTables.compute(dbName + "." + tableName, (k, v) -> v == null ? 0 : v + 1);
                this.dynamicSkippedReplicationTables.add(dbName + "." + tableName);
            }
        }
        this.syncJob.offerReplicationJob(replicationJobs);
    }

    private void sendDropIndex(String dbName, String tableName, String indexName, boolean allowDropIndex) {
        String dropIndexSql = String.format("DROP INDEX %s ON `%s`.`%s`", indexName, dbName, tableName);
        if (allowDropIndex) {
            this.syncJob.offerDDLRequest(dbName, dropIndexSql);
        } else {
            LOG.debug("Skip the DROP INDEX that only exists on the target cluster: {}", (Object)dropIndexSql);
        }
    }

    private void sendDropView(String dbName, String viewName, boolean allowDropView) {
        String dropViewSql = String.format("DROP VIEW IF EXISTS `%s`.`%s`", dbName, viewName);
        if (allowDropView) {
            this.syncJob.offerDDLRequest(dbName, dropViewSql);
        } else {
            LOG.debug("Skip the DROP VIEW that only exists on the target cluster: {}", (Object)dropViewSql);
        }
    }

    private void sendDropMaterializedView(String dbName, String materializedViewName, boolean allowDropMaterializedView) {
        String dropMaterializedViewSql = String.format("DROP MATERIALIZED VIEW IF EXISTS `%s`.`%s`", dbName, materializedViewName);
        if (allowDropMaterializedView) {
            this.syncJob.offerDDLRequest(dbName, dropMaterializedViewSql);
        } else {
            LOG.debug("Skip the DROP MATERIALIZED VIEW that only exists on the target cluster: {}", (Object)dropMaterializedViewSql);
        }
    }

    private void sendDropPartitionJob(String dbName, String tableName, String partitionName, boolean isDynamicPartitionTable, boolean allowDropPartition) {
        String dropPartitionSql = Utils.assembleDropPartitionSql(dbName, tableName, isDynamicPartitionTable, partitionName);
        if (allowDropPartition) {
            this.syncJob.offerDDLRequest(dbName, dropPartitionSql);
        } else {
            LOG.warn("Skip the DROP PARTITION that only exists on the target cluster: {}", (Object)dropPartitionSql);
        }
    }

    private void sendDropTableJob(String dbName, String tableName, boolean allowDropTable) {
        String dropTableSql = String.format("DROP TABLE IF EXISTS `%s`.`%s` FORCE", dbName, tableName);
        if (allowDropTable) {
            this.syncJob.offerDDLRequest(dbName, dropTableSql);
        } else {
            LOG.warn("Skip the DROP TABLE that only exists on the target cluster: {}", (Object)dropTableSql);
        }
        String dbAndTblName = dbName + "." + tableName;
        this.skippedReplicationTables.remove(dbAndTblName);
        this.dynamicSkippedReplicationTables.remove(dbAndTblName);
        this.partialReplicationTables.remove(dbAndTblName);
        this.syncJob.removeDroppedTableStatus(dbAndTblName);
    }

    private void handleRollupMaterializedViewDDL(Table srcTable, Table targetTable, String dbName) {
        MaterializedView srcRollupMaterializedView;
        Set<String> srcRollupMaterializedViewNames = srcTable.getRollupMaterializedViewNames();
        Set<String> targetRollupMaterializedViewNames = targetTable.getRollupMaterializedViewNames();
        Set<String> srcRollupMaterializedViewsOnly = Utils.setDifference(srcRollupMaterializedViewNames, targetRollupMaterializedViewNames);
        Set<String> targetRollupMaterializedViewsOnly = Utils.setDifference(targetRollupMaterializedViewNames, srcRollupMaterializedViewNames);
        Set<String> commonRollupMaterializedViews = Utils.setIntersection(srcRollupMaterializedViewNames, targetRollupMaterializedViewNames);
        for (String rollupMaterializedView : srcRollupMaterializedViewsOnly) {
            srcRollupMaterializedView = srcTable.getRollupMaterializedView(rollupMaterializedView);
            if (srcRollupMaterializedView == null) continue;
            this.syncJob.offerDDLRequest(dbName, srcRollupMaterializedView.getText());
        }
        for (String rollupMaterializedView : targetRollupMaterializedViewsOnly) {
            this.sendDropMaterializedView(dbName, rollupMaterializedView, this.syncConf.isDdlJobAllowDropMaterializedViewTargetOnly());
        }
        for (String rollupMaterializedView : commonRollupMaterializedViews) {
            srcRollupMaterializedView = srcTable.getRollupMaterializedView(rollupMaterializedView);
            MaterializedView targetRollupMaterializedView = targetTable.getRollupMaterializedView(rollupMaterializedView);
            if (srcRollupMaterializedView == null || targetRollupMaterializedView == null || srcRollupMaterializedView.equals(targetRollupMaterializedView)) continue;
            this.sendDropMaterializedView(dbName, rollupMaterializedView, this.syncConf.isDdlJobAllowDropInconsistentMaterializedView());
            if (!this.syncConf.isDdlJobAllowDropInconsistentMaterializedView()) continue;
            this.syncJob.offerDDLRequest(dbName, srcRollupMaterializedView.getText());
        }
    }

    private void handlePropertyDDL(Table srcTable, Table targetTable, String dbName) {
        Set<String> srcPropertyKeys = srcTable.getPropertyKeys();
        Set<String> targetPropertyKeys = targetTable.getPropertyKeys();
        Set<String> srcPropertyKeysOnly = Utils.setDifference(srcPropertyKeys, targetPropertyKeys);
        Set<String> targetPropertyKeysOnly = Utils.setDifference(targetPropertyKeys, srcPropertyKeys);
        Set<String> commonPropertyKeys = Utils.setIntersection(srcPropertyKeys, targetPropertyKeys);
        HashMap<String, String> propertyConfMap = new HashMap<String, String>();
        if (!this.syncConf.getTargetClusterStorageVolume().isEmpty()) {
            propertyConfMap.put("storage_volume", this.syncConf.getTargetClusterStorageVolume());
        }
        if (this.syncConf.getTargetClusterReplicationNum() != -1) {
            propertyConfMap.put("replication_num", String.valueOf(this.syncConf.getTargetClusterReplicationNum()));
        }
        if (this.sourceClusterInfo.getClusterRunMode() == this.targetClusterInfo.getClusterRunMode()) {
            String propertyValue;
            for (String propertyKey : srcPropertyKeysOnly) {
                propertyValue = srcTable.getPropertyValue(propertyKey);
                if (propertyConfMap.containsKey(propertyKey)) {
                    propertyValue = (String)propertyConfMap.get(propertyKey);
                }
                String createPropertySql = this.getSetPropertySql(dbName, srcTable, propertyKey, propertyValue);
                this.syncJob.offerDDLRequest(dbName, createPropertySql);
            }
            for (String propertyKey : targetPropertyKeysOnly) {
                propertyValue = "";
                if (propertyConfMap.containsKey(propertyKey)) {
                    if (((String)propertyConfMap.get(propertyKey)).equals(targetTable.getPropertyValue(propertyKey))) continue;
                    propertyValue = (String)propertyConfMap.get(propertyKey);
                }
                String updatePropertySql = this.getSetPropertySql(dbName, srcTable, propertyKey, propertyValue);
                this.syncJob.offerDDLRequest(dbName, updatePropertySql);
            }
            for (String propertyKey : commonPropertyKeys) {
                String srcPropertyValue = srcTable.getPropertyValue(propertyKey);
                String targetPropertyValue = targetTable.getPropertyValue(propertyKey);
                if (propertyConfMap.containsKey(propertyKey)) {
                    if (((String)propertyConfMap.get(propertyKey)).equals(targetPropertyValue)) continue;
                    srcPropertyValue = (String)propertyConfMap.get(propertyKey);
                } else if (srcPropertyValue.equals(targetPropertyValue)) continue;
                String updatePropertySql = this.getSetPropertySql(dbName, srcTable, propertyKey, srcPropertyValue);
                this.syncJob.offerDDLRequest(dbName, updatePropertySql);
            }
        }
    }

    private String getSetPropertySql(String dbName, Table srcTable, String propertyKey, String srcPropertyValue) {
        propertyKey = "storage_medium".equals(propertyKey) ? "default.storage_medium" : propertyKey;
        String setPropertySql = String.format("ALTER TABLE `%s`.`%s` SET (\"%s\" = \"%s\")", dbName, srcTable.getTableName(), propertyKey, srcPropertyValue);
        return setPropertySql;
    }

    private void handleBitmapIndexDDL(Table srcTable, Table targetTable, String dbName) {
        Set<String> srcIndexNames = srcTable.getBitmapIndexNames();
        Set<String> targetIndexNames = targetTable.getBitmapIndexNames();
        Set<String> srcIndexNamesOnly = Utils.setDifference(srcIndexNames, targetIndexNames);
        Set<String> targetIndexNamesOnly = Utils.setDifference(targetIndexNames, srcIndexNames);
        Set<String> commonIndexNames = Utils.setIntersection(srcIndexNames, targetIndexNames);
        for (String indexName : srcIndexNamesOnly) {
            String createIndexSql = srcTable.getBitmapIndex(indexName).getCreateIndexSql();
            this.syncJob.offerDDLRequest(dbName, createIndexSql);
        }
        for (String indexName : targetIndexNamesOnly) {
            this.sendDropIndex(dbName, targetTable.getTableName(), indexName, this.syncConf.isDdlJobAllowDropBitmapIndexTargetOnly());
        }
        for (String indexName : commonIndexNames) {
            BitmapIndex targetBitmapIndex;
            BitmapIndex srcBitmapIndex = srcTable.getBitmapIndex(indexName);
            if (srcBitmapIndex.equals(targetBitmapIndex = targetTable.getBitmapIndex(indexName))) continue;
            LOG.debug("The bitmap index of table {} is inconsistent, src index: {}, target index: {}", (Object)srcTable.getTableName(), (Object)srcBitmapIndex, (Object)targetBitmapIndex);
            this.sendDropIndex(dbName, targetTable.getTableName(), indexName, this.syncConf.isDdlJobAllowDropInconsistentBitmapIndex());
            if (!this.syncConf.isDdlJobAllowDropInconsistentBitmapIndex()) continue;
            this.syncJob.offerDDLRequest(dbName, srcBitmapIndex.getCreateIndexSql());
        }
    }

    private void handleViewDDL() {
        if (!this.syncConf.isEnableViewSync()) {
            return;
        }
        Set<String> srcDbNames = this.sourceClusterInfo.getDbNames();
        Set<String> targetDbNames = this.targetClusterInfo.getDbNames();
        Set<String> commonDbNames = Utils.setIntersection(srcDbNames, targetDbNames);
        for (String dbName : commonDbNames) {
            Set<String> srcViewNames = this.sourceClusterInfo.getDb(dbName).getViewTableNames();
            Set<String> targetViewNames = this.targetClusterInfo.getDb(dbName).getViewTableNames();
            Set<String> srcViewNamesOnly = Utils.setDifference(srcViewNames, targetViewNames);
            Set<String> targetViewNamesOnly = Utils.setDifference(targetViewNames, srcViewNames);
            Set<String> commonViewNames = Utils.setIntersection(srcViewNames, targetViewNames);
            for (String viewName : srcViewNamesOnly) {
                View view = this.sourceClusterInfo.getDb(dbName).getView(viewName);
                String createViewSql = view.getText();
                this.syncJob.offerDDLRequest(dbName, createViewSql);
            }
            for (String viewName : targetViewNamesOnly) {
                this.sendDropView(dbName, viewName, this.syncConf.isDdlJobAllowDropViewTargetOnly());
            }
            for (String viewName : commonViewNames) {
                View targetView;
                View srcView = this.sourceClusterInfo.getDb(dbName).getView(viewName);
                if (srcView.equals(targetView = this.targetClusterInfo.getDb(dbName).getView(viewName))) continue;
                this.sendDropView(dbName, viewName, this.syncConf.isDdlJobAllowDropInconsistentView());
                if (!this.syncConf.isDdlJobAllowDropInconsistentView()) continue;
                this.syncJob.offerDDLRequest(dbName, srcView.getText());
            }
        }
    }

    private void handleMaterializedViewDDL() {
        if (!this.syncConf.isEnableMaterializedViewSync()) {
            return;
        }
        Set<String> srcDbNames = this.sourceClusterInfo.getDbNames();
        Set<String> targetDbNames = this.targetClusterInfo.getDbNames();
        Set<String> commonDbNames = Utils.setIntersection(srcDbNames, targetDbNames);
        for (String dbName : commonDbNames) {
            Set<String> srcMaterializedViewNames = this.sourceClusterInfo.getDb(dbName).getMaterializedViewTableNames();
            Set<String> targetMaterializedViewNames = this.targetClusterInfo.getDb(dbName).getMaterializedViewTableNames();
            Set<String> srcMaterializedViewNamesOnly = Utils.setDifference(srcMaterializedViewNames, targetMaterializedViewNames);
            Set<String> targetMaterializedViewNamesOnly = Utils.setDifference(targetMaterializedViewNames, srcMaterializedViewNames);
            Set<String> commonMaterializedViewNames = Utils.setIntersection(srcMaterializedViewNames, targetMaterializedViewNames);
            for (String materializedViewName : srcMaterializedViewNamesOnly) {
                MaterializedView materializedView = this.sourceClusterInfo.getDb(dbName).getMaterializedView(materializedViewName);
                if (materializedView == null) continue;
                String createMaterializedViewSql = materializedView.getText();
                this.syncJob.offerDDLRequest(dbName, createMaterializedViewSql);
            }
            for (String materializedViewName : targetMaterializedViewNamesOnly) {
                this.sendDropMaterializedView(dbName, materializedViewName, this.syncConf.isDdlJobAllowDropMaterializedViewTargetOnly());
            }
            for (String materializedViewName : commonMaterializedViewNames) {
                MaterializedView srcMaterializedView = this.sourceClusterInfo.getDb(dbName).getMaterializedView(materializedViewName);
                MaterializedView targetMaterializedView = this.targetClusterInfo.getDb(dbName).getMaterializedView(materializedViewName);
                if (srcMaterializedView == null || targetMaterializedView == null || srcMaterializedView.equals(targetMaterializedView)) continue;
                this.sendDropMaterializedView(dbName, materializedViewName, this.syncConf.isDdlJobAllowDropInconsistentMaterializedView());
                if (!this.syncConf.isDdlJobAllowDropInconsistentMaterializedView()) continue;
                this.syncJob.offerDDLRequest(dbName, srcMaterializedView.getText());
            }
        }
    }

    private boolean checkPartitionVersion(String dbName, String tableName, String partitionName, Partition sourcePartition, Partition targetPartition, Table.PartitionType partitionType, boolean isDynamicPartitionTable) {
        if (sourcePartition.getVisibleVersion() < targetPartition.getVisibleVersion()) {
            LOG.info("Drop partition with inconsistent version. dbName: {}, tableName: {}, partitionName: {}, srcVersion: {}, targetVersion: {}", (Object)dbName, (Object)tableName, (Object)partitionName, (Object)sourcePartition.getVisibleVersion(), (Object)targetPartition.getVisibleVersion());
            if (partitionType == Table.PartitionType.UNPARTITIONED) {
                this.sendDropTableJob(dbName, tableName, this.syncConf.isDdlJobAllowDropInconsistentPartition());
            } else {
                this.sendDropPartitionJob(dbName, tableName, partitionName, isDynamicPartitionTable, this.syncConf.isDdlJobAllowDropInconsistentPartition());
            }
            return false;
        }
        if (sourcePartition.getVisibleVersion() == targetPartition.getVisibleVersion() && this.syncConf.isDdlJobAllowDropInconsistentTimePartition() && this.targetClusterInfo.getClusterRunMode() == ClusterInfo.RunMode.SHARED_NOTHING && sourcePartition.getVisibleVersionTime() >= targetPartition.getVisibleVersionTime()) {
            LOG.info("Drop partition with inconsistent version time. dbName: {}, tableName: {}, partitionName: {}, srcVersion: {}, targetVersion: {}, srcVersionTime: {}, targetVersionTime: {}", (Object)dbName, (Object)tableName, (Object)partitionName, (Object)sourcePartition.getVisibleVersion(), (Object)targetPartition.getVisibleVersion(), (Object)sourcePartition.getVisibleVersionTime(), (Object)targetPartition.getVisibleVersionTime());
            if (partitionType == Table.PartitionType.UNPARTITIONED) {
                this.sendDropTableJob(dbName, tableName, this.syncConf.isDdlJobAllowDropInconsistentPartition());
            } else {
                this.sendDropPartitionJob(dbName, tableName, partitionName, isDynamicPartitionTable, this.syncConf.isDdlJobAllowDropInconsistentPartition());
            }
            return false;
        }
        return true;
    }

    private void handlePartitionDDL() {
        Set<String> srcDbNames = this.sourceClusterInfo.getDbNames();
        Set<String> targetDbNames = this.targetClusterInfo.getDbNames();
        Set<String> commonDbNames = Utils.setIntersection(srcDbNames, targetDbNames);
        for (String dbName : commonDbNames) {
            Set<String> srcTableNames = this.sourceClusterInfo.getDb(dbName).getTableNames();
            Set<String> targetTableNames = this.targetClusterInfo.getDb(dbName).getTableNames();
            Set<String> commonTableNames = Utils.setIntersection(srcTableNames, targetTableNames);
            for (String tableName : commonTableNames) {
                Partition sourcePartition;
                Table srcTable = this.sourceClusterInfo.getDb(dbName).getTable(tableName);
                Set<String> srcPartitionNames = srcTable.getPartitionNames();
                Set<String> targetPartitionNames = this.targetClusterInfo.getDb(dbName).getTable(tableName).getPartitionNames();
                Set<String> sourcePartitionsOnly = Utils.setDifference(srcPartitionNames, targetPartitionNames);
                Set<String> targetPartitionsOnly = Utils.setDifference(targetPartitionNames, srcPartitionNames);
                Set<String> commonPartitionNames = Utils.setIntersection(srcPartitionNames, targetPartitionNames);
                Table.PartitionType partitionType = srcTable.getPartitionType();
                Table.ExprPartitionFunc partitionFunc = srcTable.getExprPartitionFunc();
                String partitionUnit = srcTable.getExprPartitionIntervalUnit();
                boolean isDynamicPartitionTable = srcTable.isDynamicPartitionTable();
                String partitionKey = srcTable.getPartitionKey();
                if (partitionType == Table.PartitionType.EXPR_RANGE || partitionType == Table.PartitionType.EXPR_RANGE_V2) {
                    boolean needsTrigger = Utils.needsTriggerPartitionCreation(partitionFunc, partitionKey);
                    for (String partitionName : sourcePartitionsOnly) {
                        String addPartitionSql;
                        Partition sourcePartition2 = srcTable.getPartition(partitionName);
                        if (needsTrigger) {
                            addPartitionSql = this.buildTriggerPartitionSql(dbName, tableName, partitionName);
                            LOG.info("Trigger partition creation for complex expr on target cluster for {}.{}: {}", (Object)dbName, (Object)tableName, (Object)addPartitionSql);
                        } else {
                            addPartitionSql = Utils.assembleAddExprPartitionSql(dbName, tableName, sourcePartition2.getPartitionValue(), sourcePartition2.getDistributionKey(), sourcePartition2.getBuckets(), partitionUnit);
                        }
                        if (addPartitionSql == null) continue;
                        this.syncJob.offerDDLRequest(dbName, addPartitionSql);
                    }
                } else {
                    for (String partitionName : sourcePartitionsOnly) {
                        sourcePartition = srcTable.getPartition(partitionName);
                        String addPartitionSql = Utils.assembleAddPartitionSql(dbName, tableName, isDynamicPartitionTable, partitionType, partitionName, sourcePartition.getPartitionValue(), sourcePartition.getDistributionKey(), sourcePartition.getBuckets());
                        this.syncJob.offerDDLRequest(dbName, addPartitionSql);
                    }
                }
                for (String partitionName : targetPartitionsOnly) {
                    if (partitionType == Table.PartitionType.UNPARTITIONED) {
                        this.sendDropTableJob(dbName, tableName, this.syncConf.isDdlJobAllowDropTargetOnly());
                        continue;
                    }
                    this.sendDropPartitionJob(dbName, tableName, partitionName, isDynamicPartitionTable, this.syncConf.isDdlJobAllowDropPartitionTargetOnly());
                }
                for (String partitionName : commonPartitionNames) {
                    int expectedPartitionReplicationNum;
                    Partition targetPartition;
                    if (!this.checkPartitionVersion(dbName, tableName, partitionName, sourcePartition = srcTable.getPartition(partitionName), targetPartition = this.targetClusterInfo.getDb(dbName).getTable(tableName).getPartition(partitionName), partitionType, isDynamicPartitionTable)) continue;
                    boolean needCheckReplicationNum = sourcePartition.getReplicationNum() != -1 && targetPartition.getReplicationNum() != -1;
                    int n = expectedPartitionReplicationNum = this.syncConf.getTargetClusterReplicationNum() != -1 ? this.syncConf.getTargetClusterReplicationNum() : sourcePartition.getReplicationNum();
                    if (sourcePartition.getDistributionKey().equals(targetPartition.getDistributionKey()) && sourcePartition.getBuckets() == targetPartition.getBuckets() && (!needCheckReplicationNum || expectedPartitionReplicationNum == targetPartition.getReplicationNum())) {
                        sourcePartition.setReady(true);
                        targetPartition.setReady(true);
                    }
                    if (sourcePartition.isReady() && targetPartition.isReady()) continue;
                    LOG.warn("The partition {} of {}.{} is inconsistent, source -> {}:{}:{}, target -> {}:{}:{}", (Object)partitionName, (Object)dbName, (Object)tableName, (Object)sourcePartition.getDistributionKey(), (Object)sourcePartition.getBuckets(), (Object)sourcePartition.getReplicationNum(), (Object)targetPartition.getDistributionKey(), (Object)targetPartition.getBuckets(), (Object)targetPartition.getReplicationNum());
                    if (partitionType == Table.PartitionType.UNPARTITIONED) {
                        this.sendDropTableJob(dbName, tableName, this.syncConf.isDdlJobAllowDropInconsistentPartition());
                        continue;
                    }
                    if (!sourcePartition.getDistributionKey().equals(targetPartition.getDistributionKey()) || sourcePartition.getBuckets() != targetPartition.getBuckets()) {
                        String externalAddPartitionSql = null;
                        if (Utils.needsTriggerPartitionCreation(partitionFunc, partitionKey)) {
                            externalAddPartitionSql = this.buildTriggerPartitionSql(dbName, tableName, partitionName);
                            if (externalAddPartitionSql == null) {
                                LOG.warn("Cannot alter trigger-based partition {} of {}.{}, no sample data found", (Object)partitionName, (Object)dbName, (Object)tableName);
                                continue;
                            }
                            LOG.info("Trigger partition creation for complex expr on target cluster: {}", (Object)externalAddPartitionSql);
                        }
                        String alterPartitionSql = Utils.assembleAlterPartitionSql(this.targetClusterInfo, dbName, tableName, isDynamicPartitionTable, partitionType, partitionFunc, partitionUnit, partitionKey, partitionName, sourcePartition.getPartitionValue(), sourcePartition.getDistributionKey(), sourcePartition.getBuckets(), externalAddPartitionSql);
                        if (this.syncConf.isDdlJobAllowDropInconsistentPartition()) {
                            this.syncJob.offerDDLRequest(dbName, alterPartitionSql);
                        } else {
                            LOG.warn("Skip the ALTER PARTITION that is inconsistent with the source cluster: {}", (Object)alterPartitionSql);
                        }
                    }
                    if (!needCheckReplicationNum || expectedPartitionReplicationNum == targetPartition.getReplicationNum()) continue;
                    String modifyPartitionSql = Utils.assembleModifyPartitionSql(dbName, tableName, isDynamicPartitionTable, partitionName, expectedPartitionReplicationNum);
                    this.syncJob.offerDDLRequest(dbName, modifyPartitionSql);
                }
            }
        }
    }

    private String buildTriggerPartitionSql(String dbName, String tableName, String partitionName) {
        List<String> notNullColumns = this.getNotNullColumns(dbName, tableName);
        if (notNullColumns.isEmpty()) {
            LOG.warn("No NOT NULL columns found for {}.{}, skipping partition {}", (Object)dbName, (Object)tableName, (Object)partitionName);
            return null;
        }
        List<String> sampleValues = this.fetchPartitionSampleData(dbName, tableName, partitionName, notNullColumns);
        if (sampleValues == null || sampleValues.isEmpty()) {
            LOG.info("No data found in partition {} of {}.{}, skipping partition creation", (Object)partitionName, (Object)dbName, (Object)tableName);
            return null;
        }
        return Utils.buildExprPartitionTriggerSql(dbName, tableName, notNullColumns, sampleValues);
    }

    private List<String> getNotNullColumns(String dbName, String tableName) {
        ArrayList<String> notNullColumns = new ArrayList<String>();
        String getColumnSql = String.format("SHOW COLUMNS FROM `%s`.`%s`", dbName, tableName);
        Function<ResultSet, Void> columnFunc = rs -> {
            try {
                while (rs.next()) {
                    String columnName = rs.getString("Field");
                    String nullValue = rs.getString("Null");
                    if (!"NO".equalsIgnoreCase(nullValue)) continue;
                    notNullColumns.add(columnName);
                }
            }
            catch (SQLException e) {
                LOG.error("Failed to get NOT NULL columns for {}.{}", (Object)dbName, (Object)tableName, (Object)e);
            }
            return null;
        };
        Utils.execQuerySql(getColumnSql, this.sourceClusterInfo, columnFunc);
        return notNullColumns;
    }

    private List<String> fetchPartitionSampleData(String dbName, String tableName, String partitionName, List<String> columns) {
        ArrayList<String> sampleValues = new ArrayList<String>();
        String selectSql = Utils.buildSelectPartitionSampleSql(dbName, tableName, partitionName, columns);
        Function<ResultSet, Void> dataFunc = rs -> {
            try {
                if (rs.next()) {
                    ResultSetMetaData metaData = rs.getMetaData();
                    int columnCount = metaData.getColumnCount();
                    for (int i = 1; i <= columnCount; ++i) {
                        Object value = rs.getObject(i);
                        if (value == null) {
                            sampleValues.add("NULL");
                            continue;
                        }
                        String strValue = value.toString();
                        String escapedValue = strValue.replace("'", "''");
                        sampleValues.add("'" + escapedValue + "'");
                    }
                }
            }
            catch (SQLException e) {
                LOG.error("Failed to fetch sample data from partition {} of {}.{}", (Object)partitionName, (Object)dbName, (Object)tableName, (Object)e);
            }
            return null;
        };
        Utils.execQuerySql(selectSql, this.sourceClusterInfo, dataFunc);
        return sampleValues.isEmpty() ? null : sampleValues;
    }

    private void handleTableDDL() {
        Set<String> srcDbNames = this.sourceClusterInfo.getDbNames();
        Set<String> targetDbNames = this.targetClusterInfo.getDbNames();
        Set<String> commonDbNames = Utils.setIntersection(srcDbNames, targetDbNames);
        for (String dbName : commonDbNames) {
            Set<String> srcTableNames = this.sourceClusterInfo.getDb(dbName).getTableNames();
            Set<String> targetTableNames = this.targetClusterInfo.getDb(dbName).getTableNames();
            Set<String> srcTablesOnly = Utils.setDifference(srcTableNames, targetTableNames);
            Set<String> targetTablesOnly = Utils.setDifference(targetTableNames, srcTableNames);
            Set<String> commonTableNames = Utils.setIntersection(srcTableNames, targetTableNames);
            for (String tableName : srcTablesOnly) {
                String showCreateTableSql = String.format("SHOW CREATE TABLE `%s`.`%s`", dbName, tableName);
                StringBuilder createStmtSql = new StringBuilder();
                Function<ResultSet, Void> createTableStmtFunc = rs -> {
                    String errorMsg = String.format("Failed to get create table SQL from source cluster. database: %s, table: %s", dbName, tableName);
                    try {
                        while (rs.next()) {
                            if (rs.getRow() > 1) {
                                throw new SQLException(errorMsg);
                            }
                            String createTableStmt = rs.getString("Create Table");
                            createStmtSql.append(createTableStmt);
                        }
                    }
                    catch (Exception e) {
                        LOG.error(errorMsg, (Throwable)e);
                    }
                    return null;
                };
                Utils.execQuerySql(showCreateTableSql, this.sourceClusterInfo, createTableStmtFunc);
                Table table = this.sourceClusterInfo.getDb(dbName).getTable(tableName);
                ClusterInfo.RunMode srcClusterRunMode = this.sourceClusterInfo.getClusterRunMode();
                ClusterInfo.RunMode targetClusterRunMode = this.targetClusterInfo.getClusterRunMode();
                String showCreateTableResult = createStmtSql.toString();
                String createTableSql = Utils.convertCreateTableStmt(showCreateTableResult, dbName, tableName, this.syncConf.getTargetClusterStorageVolume(), this.syncConf.getTargetClusterReplicationNum(), table.getBucketNum(), table.getBaseIndexSchema().getSchemaVersion(), this.syncConf.isTargetClusterEnablePersistentIndex(), srcClusterRunMode, targetClusterRunMode, this.syncConf.isUseBuiltinStorageVolumeOnTarget());
                this.syncJob.offerDDLRequest(dbName, createTableSql);
            }
            for (String tableName : targetTablesOnly) {
                this.sendDropTableJob(dbName, tableName, this.syncConf.isDdlJobAllowDropTargetOnly());
            }
            for (String tableName : commonTableNames) {
                Table srcTable = this.sourceClusterInfo.getDb(dbName).getTable(tableName);
                Table targetTable = this.targetClusterInfo.getDb(dbName).getTable(tableName);
                boolean needDropTable = false;
                if (this.syncConf.isDdlJobAllowDropInconsistentTimePartition() && srcTable.getCreateTime() > targetTable.getCreateTime()) {
                    LOG.warn("Schema change: the creation time of the data table in the source cluster is later than that of the data table in the target cluster. table -> {}", (Object)tableName);
                    needDropTable = true;
                } else if (!srcTable.schemaEqual(targetTable)) {
                    needDropTable = true;
                }
                if (needDropTable) {
                    this.sendDropTableJob(dbName, tableName, this.syncConf.isDdlJobAllowDropSchemaChangeTable());
                    this.sourceClusterInfo.getDb(dbName).removeTable(tableName);
                    this.targetClusterInfo.getDb(dbName).removeTable(tableName);
                }
                if (this.syncConf.isEnableBitmapIndexSync()) {
                    this.handleBitmapIndexDDL(srcTable, targetTable, dbName);
                }
                if (this.syncConf.isEnableTablePropertySync()) {
                    this.handlePropertyDDL(srcTable, targetTable, dbName);
                }
                if (!this.syncConf.isEnableMaterializedViewSync()) continue;
                this.handleRollupMaterializedViewDDL(srcTable, targetTable, dbName);
            }
        }
    }

    private void handleDbDDL() {
        Set<String> srcDbNames = this.sourceClusterInfo.getDbNames();
        Set<String> targetDbNames = this.targetClusterInfo.getDbNames();
        Set<String> srcDbsOnly = Utils.setDifference(srcDbNames, targetDbNames);
        Set<String> targetDbsOnly = Utils.setDifference(targetDbNames, srcDbNames);
        for (String dbName : srcDbsOnly) {
            String createDbSql = String.format("CREATE DATABASE IF NOT EXISTS `%s`", dbName);
            this.syncJob.offerDDLRequest(null, createDbSql);
        }
        for (String dbName : targetDbsOnly) {
            String dropDbSql = String.format("DROP DATABASE IF EXISTS `%s`", dbName);
            if (this.syncConf.isDdlJobAllowDropTargetOnly()) {
                this.syncJob.offerDDLRequest(null, dropDbSql);
                continue;
            }
            LOG.debug("Skip the DROP DATABASE that only exists on the target cluster: {}", (Object)dropDbSql);
        }
    }

    private void updateBasicMeta(String feHost, int feQueryPort, ClusterInfo clusterInfo) {
        if (clusterInfo.needUpdateClusterBasicMeta()) {
            this.updateClusterBasicMetaInfo(feHost, feQueryPort, clusterInfo);
        }
        this.checkSourceClusterToken(clusterInfo);
        this.updateFrontendsMeta(feHost, feQueryPort, clusterInfo);
        this.updateBackendsMeta(clusterInfo);
        this.checkClusterStatus(clusterInfo);
        this.updateStorageVolumeMeta(clusterInfo);
        this.checkOrUpdateSourceClusterServiceId(clusterInfo);
    }

    private void checkSourceClusterToken(ClusterInfo clusterInfo) {
        if (clusterInfo.getClusterType() == ClusterInfo.Type.SOURCE && clusterInfo.getClusterRunMode() == ClusterInfo.RunMode.SHARED_NOTHING && (clusterInfo.getToken() == null || clusterInfo.getToken().isEmpty())) {
            LOG.error("source_cluster_token cannot be empty.");
            System.exit(-1);
        }
    }

    private void checkClusterStatus(ClusterInfo clusterInfo) {
        if (clusterInfo.getClusterType() == ClusterInfo.Type.TARGET) {
            String enableConfigName = "emr_serveless_replication_enable";
            Function<ResultSet, Void> enableFunc = rs -> {
                try {
                    while (rs.next()) {
                        if (Boolean.parseBoolean(rs.getString("Value"))) continue;
                        LOG.error("Please enable the configuration {} on the TARGET cluster.", (Object)enableConfigName);
                        System.exit(-1);
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to check {} config on the {} cluster", (Object)enableConfigName, (Object)clusterInfo.getClusterType(), (Object)e);
                }
                return null;
            };
            Utils.execQuerySql(String.format("ADMIN SHOW FRONTEND CONFIG LIKE '%s'", enableConfigName), clusterInfo, enableFunc);
            String legacyConfigName = "enable_legacy_compatibility_for_replication";
            Function<ResultSet, Void> legacyFunc = rs -> {
                try {
                    while (rs.next()) {
                        if (Boolean.parseBoolean(rs.getString("Value"))) continue;
                        LOG.error("Please enable the configuration {} on the TARGET cluster.", (Object)legacyConfigName);
                        System.exit(-1);
                    }
                }
                catch (SQLException e) {
                    LOG.error("Failed to check {} config on the {} cluster", (Object)legacyConfigName, (Object)clusterInfo.getClusterType(), (Object)e);
                }
                return null;
            };
            Utils.execQuerySql(String.format("ADMIN SHOW FRONTEND CONFIG LIKE '%s'", legacyConfigName), clusterInfo, legacyFunc);
            if (clusterInfo.getClusterRunMode() == ClusterInfo.RunMode.SHARED_DATA && !Utils.canEnableCompactionInSharedData(clusterInfo.getClusterVersion())) {
                String lakeCompactionConfigName = "lake_compaction_max_tasks";
                Function<ResultSet, Void> compactFunc = rs -> {
                    try {
                        while (rs.next()) {
                            if (Integer.parseInt(rs.getString("Value")) == 0) continue;
                            LOG.error("If target cluster run in shared-data mode, compaction must be disable. Please use admin set frontend config (\"{}\"=\"0\");", (Object)lakeCompactionConfigName);
                            System.exit(-1);
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Failed to check {} config on the {} cluster", (Object)lakeCompactionConfigName, (Object)clusterInfo.getClusterType(), (Object)e);
                    }
                    return null;
                };
                Utils.execQuerySql(String.format("ADMIN SHOW FRONTEND CONFIG LIKE '%s'", lakeCompactionConfigName), clusterInfo, compactFunc);
            }
            if (clusterInfo.getClusterRunMode() == ClusterInfo.RunMode.SHARED_NOTHING) {
                for (Backend be : clusterInfo.getBackends().values()) {
                    if (!(be.getMaxDiskUsedPct() > this.syncConf.getTargetClusterMaxDiskUsedPct())) continue;
                    LOG.error("The max disk used percent of {} has exceeded {}% on the {} cluster.", (Object)be.getHost(), (Object)this.syncConf.getTargetClusterMaxDiskUsedPct(), (Object)clusterInfo.getClusterType());
                    System.exit(-1);
                }
            }
        }
    }

    private void checkOrUpdateSourceClusterServiceId(ClusterInfo clusterInfo) {
        if (clusterInfo.getClusterType() != ClusterInfo.Type.SOURCE) {
            return;
        }
        if (clusterInfo.getClusterRunMode() != ClusterInfo.RunMode.SHARED_DATA) {
            return;
        }
        if (!StringUtils.isNullOrEmpty(clusterInfo.getServiceId())) {
            LOG.info("Skip to update service id, because it has been set to {}", (Object)clusterInfo.getServiceId());
            return;
        }
        String clusterType = clusterInfo.getClusterType().toString();
        String errorMsg = String.format("Failed to get storage path on the %s cluster.", clusterType);
        Function<ResultSet, Void> function = rs -> {
            try {
                while (rs.next()) {
                    String storagePath = rs.getString("StoragePath");
                    if (StringUtils.isNullOrEmpty(storagePath)) {
                        LOG.debug("Failed to get storage path on the {} cluster, storagePath: {}", (Object)clusterType, (Object)storagePath);
                        continue;
                    }
                    String serviceId = Utils.extractServiceIdFrom(storagePath);
                    if (StringUtils.isNullOrEmpty(serviceId)) {
                        LOG.debug("Failed to get storage path on the {} cluster, storagePath: {}", (Object)clusterType, (Object)storagePath);
                        continue;
                    }
                    LOG.info("Got serviceId: {} from {} cluster", (Object)serviceId, (Object)clusterType);
                    clusterInfo.setServiceId(serviceId);
                    break;
                }
            }
            catch (SQLException e) {
                LOG.error(errorMsg, (Throwable)e);
            }
            return null;
        };
        Utils.execQuerySql("show proc '/dbs/_statistics_'", clusterInfo, function);
        if (StringUtils.isNullOrEmpty(clusterInfo.getServiceId())) {
            LOG.error("Failed to get service id on the {} cluster.", (Object)clusterInfo.getClusterType());
            System.exit(-1);
        }
    }

    private void updateDataMeta(ClusterInfo clusterInfo) {
        this.updateDbMeta(clusterInfo);
        this.updateTableMeta(clusterInfo);
        this.updatePartitionMeta(clusterInfo);
        this.updateIndexSchemaMeta(clusterInfo);
        this.updateIndexMeta(clusterInfo);
        this.updateTabletMeta(clusterInfo);
        this.updateAsyncMaterializedViewMeta(clusterInfo);
        this.updateViewMeta(clusterInfo);
        this.updateRollupMaterializedViewMeta(clusterInfo);
    }

    private void updateFrontendsMeta(String feHost, int feQueryPort, ClusterInfo clusterInfo) {
        String user = clusterInfo.getUserName();
        String password = clusterInfo.getPassword();
        String errorMsg = String.format("Failed to get frontends info. detail: FE->%s", feHost);
        Function<ResultSet, Void> feFunc = rs -> {
            try {
                ArrayList<Frontend> frontends = new ArrayList<Frontend>();
                boolean hasIsMasterColumn = false;
                ResultSetMetaData rsmd = rs.getMetaData();
                int columnCount = rsmd.getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    if (!rsmd.getColumnName(i).equals("IsMaster")) continue;
                    hasIsMasterColumn = true;
                    break;
                }
                while (rs.next()) {
                    String host = rs.getString("IP").trim();
                    SyncConf.HostMapping mapping = this.syncConf.getHostMapping(clusterInfo.getClusterType(), host);
                    String mappedHost = mapping.getMappedHost();
                    int queryPort = mapping.getMappedPort(rs.getInt("QueryPort"));
                    int httpPort = mapping.getMappedPort(rs.getInt("HttpPort"));
                    int rpcPort = mapping.getMappedPort(rs.getInt("RpcPort"));
                    if (!hasIsMasterColumn) {
                        frontends.add(new Frontend(mappedHost, queryPort, httpPort, rpcPort, rs.getString("Role"), false));
                        continue;
                    }
                    frontends.add(new Frontend(mappedHost, queryPort, httpPort, rpcPort, rs.getString("Role"), rs.getBoolean("IsMaster")));
                }
                clusterInfo.setFrontends(frontends, this.syncConf.getJdbcConnectTimeoutMs(), this.syncConf.getJdbcSocketTimeoutMs());
                LOG.info("Get {} frontends.", (Object)frontends.size());
            }
            catch (Exception e) {
                LOG.error(errorMsg, (Throwable)e);
            }
            return null;
        };
        Utils.execQuerySql("SHOW FRONTENDS", feHost, feQueryPort, user, password, this.syncConf.getJdbcConnectTimeoutMs(), this.syncConf.getJdbcSocketTimeoutMs(), feFunc);
    }

    private void updateClusterBasicMetaInfo(String feHost, int feQueryPort, ClusterInfo clusterInfo) {
        String user = clusterInfo.getUserName();
        String password = clusterInfo.getPassword();
        String clusterModeErrorMsg = String.format("Failed to get %s cluster run mode. detail: FE->%s", new Object[]{clusterInfo.getClusterType(), feHost});
        Function<ResultSet, Void> runModeFunc = rs -> {
            try {
                ClusterInfo.RunMode runMode = ClusterInfo.RunMode.SHARED_NOTHING;
                while (rs.next()) {
                    if (rs.getRow() > 1) {
                        throw new SQLException(clusterModeErrorMsg);
                    }
                    String value = rs.getString("Value");
                    runMode = ClusterInfo.RunMode.valueOf(value.toUpperCase(Locale.ROOT));
                }
                clusterInfo.setClusterRunMode(runMode);
                LOG.info("Get cluster {} run mode: {}.", (Object)feHost, (Object)clusterInfo.getClusterRunMode());
            }
            catch (Exception e) {
                LOG.error(clusterModeErrorMsg, (Throwable)e);
            }
            return null;
        };
        Utils.execQuerySql("ADMIN SHOW FRONTEND CONFIG LIKE 'run_mode'", feHost, feQueryPort, user, password, this.syncConf.getJdbcConnectTimeoutMs(), this.syncConf.getJdbcSocketTimeoutMs(), runModeFunc);
        String clusterVersionErrorMsg = String.format("Failed to get %s cluster version and set to version -1. detail: FE->%s", new Object[]{clusterInfo.getClusterType(), feHost});
        Function<ResultSet, Void> clusterVersionFunc = rs -> {
            String value = "";
            try {
                Version clusterVersion = null;
                while (rs.next()) {
                    if (rs.getRow() > 1) {
                        throw new SQLException(clusterVersionErrorMsg);
                    }
                    value = rs.getString("version");
                    clusterVersion = new Version(value);
                }
                if (clusterVersion == null) {
                    clusterVersion = new Version();
                    LOG.error("{}, version->{}", (Object)clusterVersionErrorMsg, (Object)value);
                }
                clusterInfo.setClusterVersion(clusterVersion);
                LOG.info("Get cluster {} version: {}, original version value -> {}.", (Object)feHost, (Object)clusterInfo.getClusterVersion(), (Object)value);
            }
            catch (Exception e) {
                clusterInfo.setClusterVersion(new Version());
                LOG.error("{}, version -> {}", (Object)clusterVersionErrorMsg, (Object)value);
            }
            return null;
        };
        Utils.execQuerySql("SELECT current_version() AS version", feHost, feQueryPort, user, password, this.syncConf.getJdbcConnectTimeoutMs(), this.syncConf.getJdbcSocketTimeoutMs(), clusterVersionFunc);
    }

    private void updateBackendsMeta(ClusterInfo clusterInfo) {
        String errorMsg = String.format("Failed to get backends info on the %s cluster", new Object[]{clusterInfo.getClusterType()});
        ArrayList<Backend> backends = new ArrayList<Backend>();
        Function<ResultSet, Void> beFunc = rs -> {
            try {
                while (rs.next()) {
                    String host = rs.getString("IP").trim();
                    SyncConf.HostMapping mapping = this.syncConf.getHostMapping(clusterInfo.getClusterType(), host);
                    String mappedHost = mapping.getMappedHost();
                    int bePort = mapping.getMappedPort(rs.getInt("BePort"));
                    int httpPort = mapping.getMappedPort(rs.getInt("HttpPort"));
                    double maxDiskUsedPct = Double.parseDouble(rs.getString("MaxDiskUsedPct").replace("%", "").trim());
                    if (clusterInfo.getClusterRunMode() == ClusterInfo.RunMode.SHARED_NOTHING) {
                        backends.add(new Backend(rs.getLong("BackendId"), mappedHost, bePort, httpPort, 0, maxDiskUsedPct));
                        continue;
                    }
                    int starletPort = mapping.getMappedPort(rs.getInt("StarletPort"));
                    backends.add(new Backend(rs.getLong("BackendId"), mappedHost, bePort, httpPort, starletPort, -1.0));
                }
            }
            catch (Exception e) {
                LOG.error(errorMsg, (Throwable)e);
            }
            return null;
        };
        Utils.execQuerySql("SHOW BACKENDS", clusterInfo, beFunc);
        Function<ResultSet, Void> cnFunc = rs -> {
            try {
                while (rs.next()) {
                    String host = rs.getString("IP").trim();
                    SyncConf.HostMapping mapping = this.syncConf.getHostMapping(clusterInfo.getClusterType(), host);
                    String mappedHost = mapping.getMappedHost();
                    int bePort = mapping.getMappedPort(rs.getInt("BePort"));
                    int httpPort = mapping.getMappedPort(rs.getInt("HttpPort"));
                    if (clusterInfo.getClusterRunMode() == ClusterInfo.RunMode.SHARED_NOTHING) {
                        backends.add(new Backend(rs.getLong("ComputeNodeId"), mappedHost, bePort, httpPort, 0, -1.0));
                        continue;
                    }
                    int starletPort = mapping.getMappedPort(rs.getInt("StarletPort"));
                    backends.add(new Backend(rs.getLong("ComputeNodeId"), mappedHost, bePort, httpPort, starletPort, -1.0));
                }
            }
            catch (Exception e) {
                LOG.error(errorMsg, (Throwable)e);
            }
            return null;
        };
        if (clusterInfo.getClusterRunMode() == ClusterInfo.RunMode.SHARED_DATA) {
            Utils.execQuerySql("SHOW COMPUTE NODES", clusterInfo, cnFunc);
        }
        clusterInfo.setBackends(backends);
        LOG.info("Get {} backends.", (Object)backends.size());
        if (clusterInfo.getClusterType() == ClusterInfo.Type.TARGET && clusterInfo.getBackends().isEmpty()) {
            LOG.error("the number of BEs in target cluster is zero");
            System.exit(-1);
        }
    }

    private void updateStorageVolumeMeta(ClusterInfo clusterInfo) {
        if (clusterInfo.getClusterRunMode() != ClusterInfo.RunMode.SHARED_DATA) {
            return;
        }
        ArrayList<String> svList = new ArrayList<String>();
        String showSVErrorMsg = String.format("Failed to get %s cluster storage volumes.", new Object[]{clusterInfo.getClusterType()});
        Function<ResultSet, Void> showSVFunc = rs -> {
            try {
                while (rs.next()) {
                    if (rs.getRow() < 1) {
                        throw new SQLException(showSVErrorMsg);
                    }
                    String storageVolumeName = rs.getString("Storage Volume");
                    svList.add(storageVolumeName);
                }
            }
            catch (SQLException e) {
                LOG.error(showSVErrorMsg, (Throwable)e);
            }
            return null;
        };
        Utils.execQuerySql("SHOW STORAGE VOLUMES", clusterInfo, showSVFunc);
        clusterInfo.setStorageVolumes(svList);
        LOG.info("Get {} storage volumes from {} cluster.", (Object)svList.size(), (Object)clusterInfo.getClusterType());
    }

    private void updateRollupMaterializedViewMeta(ClusterInfo clusterInfo) {
        if (!this.syncConf.isEnableMaterializedViewSync()) {
            return;
        }
        String clusterType = clusterInfo.getClusterType().toString();
        ArrayList futures = new ArrayList();
        for (Database database : clusterInfo.getDbs()) {
            Future<?> future = this.metaExecutorService.submit(() -> {
                for (Table table : db.getTables()) {
                    HashMap<String, MaterializedView> materializedViews = new HashMap<String, MaterializedView>();
                    Set<String> rollupIndexNames = table.getRollupMaterializedViewNames();
                    for (String rollupIndexName : rollupIndexNames) {
                        String getRollupMaterializedViewsSql = String.format("SHOW CREATE MATERIALIZED VIEW `%s`.`%s`", db.getDbName(), rollupIndexName);
                        Function<ResultSet, Void> getRollupMaterializedViewsFunc = rs -> {
                            try {
                                while (rs.next()) {
                                    String dataBaseName = db.getDbName();
                                    String text = rs.getString("Create Materialized View");
                                    MaterializedView materializedView = new MaterializedView(dataBaseName, rollupIndexName, text);
                                    materializedViews.put(rollupIndexName, materializedView);
                                    LOG.debug("Get {} rollup materialized views. database->{}, on the {} cluster.", (Object)materializedViews.size(), (Object)db.getDbName(), (Object)clusterType);
                                }
                            }
                            catch (Exception e) {
                                String errorMsg = String.format("Failed to get rollup materialized view field info on the %s cluster. detail: db->%s, table->%s", clusterType, db.getDbName(), rollupIndexName);
                                LOG.warn("{} cause by: {}", (Object)errorMsg, (Object)e.getMessage());
                            }
                            return null;
                        };
                        Utils.execQuerySql(getRollupMaterializedViewsSql, clusterInfo, getRollupMaterializedViewsFunc);
                    }
                    table.setRollupMaterializedViews(materializedViews);
                }
            });
            futures.add(future);
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                LOG.error("Failed to execute rollup materialized view meta task.", (Throwable)e);
            }
        }
    }

    private void updateAsyncMaterializedViewMeta(ClusterInfo clusterInfo) {
        if (!this.syncConf.isEnableMaterializedViewSync()) {
            return;
        }
        String clusterType = clusterInfo.getClusterType().toString();
        ArrayList futures = new ArrayList();
        for (Database database : clusterInfo.getDbs()) {
            Future<?> future = this.metaExecutorService.submit(() -> {
                HashMap<String, MaterializedView> materializedViews = new HashMap<String, MaterializedView>();
                for (Table table : db.getMaterializedViewTables()) {
                    String errorMsg = String.format("Failed to get async materialized view info on the %s cluster.detail: db->%s", clusterType, db.getDbName());
                    String getMaterializedViewSql = String.format("SHOW CREATE TABLE `%s`.`%s`", db.getDbName(), table.getTableName());
                    Function<ResultSet, Void> materializedViewFunc = rs -> {
                        try {
                            while (rs.next()) {
                                String dataBaseName = db.getDbName();
                                String materializedViewName = table.getTableName();
                                String text = rs.getString("Create Materialized View");
                                MaterializedView materializedView = new MaterializedView(dataBaseName, materializedViewName, text);
                                materializedViews.put(materializedViewName, materializedView);
                            }
                            LOG.debug("Get {} async materialized views. database->{}, on the {} cluster.", (Object)materializedViews.size(), (Object)db.getDbName(), (Object)clusterType);
                        }
                        catch (Exception e) {
                            LOG.error(errorMsg, (Throwable)e);
                        }
                        return null;
                    };
                    Utils.execQuerySql(getMaterializedViewSql, clusterInfo, materializedViewFunc);
                }
                db.setMaterializedViews(materializedViews);
            });
            futures.add(future);
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                LOG.error("Failed to execute async materialized view meta task.", (Throwable)e);
            }
        }
    }

    private void updateViewMeta(ClusterInfo clusterInfo) {
        if (!this.syncConf.isEnableViewSync()) {
            return;
        }
        String clusterType = clusterInfo.getClusterType().toString();
        ArrayList futures = new ArrayList();
        for (Database database : clusterInfo.getDbs()) {
            Future<?> future = this.metaExecutorService.submit(() -> {
                HashMap<String, View> views = new HashMap<String, View>();
                for (Table table : db.getViewTables()) {
                    String errorMsg = String.format("Failed to get view info on the %s cluster.detail: db->%s", clusterType, db.getDbName());
                    String getViewSql = String.format("SHOW CREATE TABLE `%s`.`%s`", db.getDbName(), table.getTableName());
                    Function<ResultSet, Void> viewFunc = rs -> {
                        try {
                            while (rs.next()) {
                                long viewId = table.getTableId();
                                String dataBaseName = db.getDbName();
                                String viewName = table.getTableName();
                                String text = rs.getString("Create View");
                                View view = new View(viewId, dataBaseName, viewName, text);
                                views.put(viewName, view);
                            }
                            LOG.debug("Get {} views. database->{}, on the {} cluster.", (Object)views.size(), (Object)db.getDbName(), (Object)clusterType);
                        }
                        catch (Exception e) {
                            LOG.error(errorMsg, (Throwable)e);
                        }
                        return null;
                    };
                    Utils.execQuerySql(getViewSql, clusterInfo, viewFunc);
                }
                db.setViews(views);
            });
            futures.add(future);
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                LOG.error("Failed to execute view meta task.", (Throwable)e);
            }
        }
    }

    private void updateTabletMeta(ClusterInfo clusterInfo) {
        String clusterType = clusterInfo.getClusterType().toString();
        ArrayList futures = new ArrayList();
        for (Database database : clusterInfo.getDbs()) {
            for (Table table : database.getTables()) {
                for (Partition partition : table.getPartitions()) {
                    Future<?> future = this.metaExecutorService.submit(() -> {
                        for (Index index : partition.getIndices()) {
                            String errorMsg = String.format("Failed to get tablet info on the %s cluster.detail: db->%s, table->%s, partition->%s, index->%s", clusterType, db.getDbName(), table.getTableName(), partition.getPartitionName(), index.getIndexId());
                            String getTabletSql = String.format("SHOW PROC '/dbs/%s/%s/partitions/%s/%s/'", db.getDbId(), table.getTableId(), partition.getPartitionId(), index.getIndexId());
                            Function<ResultSet, Void> tabletFunc = rs -> {
                                try {
                                    int replicaCount = 0;
                                    ArrayList<Tablet> tablets = new ArrayList<Tablet>();
                                    long prevTabletId = -1L;
                                    Tablet tablet = new Tablet(prevTabletId);
                                    while (rs.next()) {
                                        String backendId;
                                        long tabletId;
                                        try {
                                            String state = rs.getString("State");
                                            if (!state.equals("NORMAL")) {
                                                continue;
                                            }
                                        }
                                        catch (Exception state) {
                                            // empty catch block
                                        }
                                        if (prevTabletId != (tabletId = rs.getLong("TabletId"))) {
                                            tablet = new Tablet(tabletId);
                                            tablets.add(tablet);
                                            prevTabletId = tabletId;
                                        }
                                        try {
                                            backendId = rs.getString("BackendId");
                                        }
                                        catch (Exception e) {
                                            backendId = rs.getString("NodeId");
                                        }
                                        if (backendId.contains("[")) {
                                            String json = backendId.substring(1, backendId.length() - 1);
                                            String[] beList = json.split(",");
                                            backendId = beList[0].trim();
                                        }
                                        tablet.addReplica(Long.parseLong(backendId));
                                        ++replicaCount;
                                    }
                                    index.setTablets(tablets);
                                    LOG.debug("Get {} tablets and {} replicas. database->{}, table->{}, partition->{}, index->{} on the {} cluster.", (Object)tablets.size(), (Object)replicaCount, (Object)db.getDbName(), (Object)table.getTableName(), (Object)partition.getPartitionName(), (Object)index.getIndexName(), (Object)clusterType);
                                }
                                catch (Exception e) {
                                    LOG.error(errorMsg, (Throwable)e);
                                }
                                return null;
                            };
                            Utils.execQuerySql(getTabletSql, clusterInfo, tabletFunc);
                        }
                    });
                    futures.add(future);
                }
                table.updateLastMetaTime();
            }
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                LOG.error("Failed to execute tablet meta task.", (Throwable)e);
            }
        }
    }

    private void updateIndexMeta(ClusterInfo clusterInfo) {
        String clusterType = clusterInfo.getClusterType().toString();
        ArrayList futures = new ArrayList();
        for (Database database : clusterInfo.getDbs()) {
            for (Table table : database.getTables()) {
                for (Partition partition : table.getPartitions()) {
                    Future<?> future = this.metaExecutorService.submit(() -> {
                        String errorMsg = String.format("Failed to get index info on the %s cluster. detail: db->%s, table->%s, partition->%s", clusterType, db.getDbName(), table.getTableName(), partition.getPartitionName());
                        String getIndexSql = String.format("SHOW PROC '/dbs/%s/%s/partitions/%s/'", db.getDbId(), table.getTableId(), partition.getPartitionId());
                        Function<ResultSet, Void> indexFunc = rs -> {
                            try {
                                ArrayList<Index> indices = new ArrayList<Index>();
                                while (rs.next()) {
                                    String indexName = rs.getString("IndexName");
                                    indices.add(new Index(rs.getLong("IndexId"), indexName));
                                }
                                partition.setIndices(indices);
                                LOG.debug("Get {} indices. database->{}, table->{}, partition->{} on the {} cluster.", (Object)indices.size(), (Object)db.getDbName(), (Object)table.getTableName(), (Object)partition.getPartitionName(), (Object)clusterType);
                            }
                            catch (Exception e) {
                                LOG.error(errorMsg, (Throwable)e);
                            }
                            return null;
                        };
                        Utils.execQuerySql(getIndexSql, clusterInfo, indexFunc);
                    });
                    futures.add(future);
                }
            }
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                LOG.error("Failed to execute index meta task.", (Throwable)e);
            }
        }
    }

    private void updatePartitionMeta(ClusterInfo clusterInfo) {
        String clusterType = clusterInfo.getClusterType().toString();
        ArrayList futures = new ArrayList();
        for (Database database : clusterInfo.getDbs()) {
            for (Table table : database.getTables()) {
                Future<?> future = this.metaExecutorService.submit(() -> {
                    String errorMsg = String.format("Failed to get partition info on the %s cluster. detail: db->%s, table->%s", clusterType, db.getDbName(), table.getTableName());
                    String getPartitionSql = String.format("SHOW PROC '/dbs/%s/%s/partitions/'", db.getDbId(), table.getTableId());
                    Function<ResultSet, Void> partitionFunc = rs -> {
                        try {
                            int partitionTypeIndex = -1;
                            boolean hasReplicationNum = false;
                            ResultSetMetaData rsmd = rs.getMetaData();
                            int columnCount = rsmd.getColumnCount();
                            for (int i = 1; i <= columnCount; ++i) {
                                if (rsmd.getColumnName(i).equals("List") || rsmd.getColumnName(i).equals("Range")) {
                                    partitionTypeIndex = i;
                                }
                                if (!rsmd.getColumnName(i).equals("ReplicationNum")) continue;
                                hasReplicationNum = true;
                            }
                            ArrayList<Partition> partitions = new ArrayList<Partition>();
                            while (rs.next()) {
                                String partitionValue = rs.getString(partitionTypeIndex);
                                long visibleVersion = 0L;
                                visibleVersion = clusterInfo.getClusterType() == ClusterInfo.Type.TARGET && clusterInfo.getClusterRunMode() == ClusterInfo.RunMode.SHARED_DATA && Utils.canEnableCompactionInSharedData(clusterInfo.getClusterVersion()) ? rs.getLong("DataVersion") : rs.getLong("VisibleVersion");
                                long visibleVersionTime = -1L;
                                if (clusterInfo.getClusterRunMode() == ClusterInfo.RunMode.SHARED_NOTHING) {
                                    String visibleVersionTimeString = rs.getString("VisibleVersionTime");
                                    visibleVersionTime = Utils.formatDatetimeToLong(visibleVersionTimeString);
                                }
                                int replicationNum = hasReplicationNum ? rs.getInt("ReplicationNum") : -1;
                                long dataSize = Utils.convertDataSizeToLong(rs.getString("DataSize"));
                                partitions.add(new Partition(rs.getLong("PartitionId"), rs.getString("PartitionName"), partitionValue, Utils.makeBacktickDistributionKey(rs.getString("DistributionKey")), rs.getInt("Buckets"), replicationNum, visibleVersion, visibleVersionTime, dataSize));
                            }
                            table.setPartitions(partitions);
                            LOG.debug("Get {} partitions. database->{}, table->{} on the {} cluster.", (Object)partitions.size(), (Object)db.getDbName(), (Object)table.getTableName(), (Object)clusterType);
                        }
                        catch (Exception e) {
                            LOG.error(errorMsg, (Throwable)e);
                        }
                        return null;
                    };
                    Utils.execQuerySql(getPartitionSql, clusterInfo, partitionFunc);
                });
                futures.add(future);
            }
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                LOG.error("Failed to execute partition meta task.", (Throwable)e);
            }
        }
    }

    private void updateIndexSchemaMeta(ClusterInfo clusterInfo) {
        String clusterType = clusterInfo.getClusterType().toString();
        ArrayList futures = new ArrayList();
        for (Database database : clusterInfo.getDbs()) {
            for (Table table : database.getTables()) {
                Future<?> future = this.metaExecutorService.submit(() -> {
                    String getIndexSchemaSql = String.format("SHOW PROC '/dbs/%s/%s/index_schema/'", db.getDbId(), table.getTableId());
                    Function<ResultSet, Void> indexSchemaFunc = rs -> {
                        try {
                            ArrayList<IndexSchema> schemas = new ArrayList<IndexSchema>();
                            while (rs.next()) {
                                String indexName = rs.getString("IndexName");
                                long schemaVersion = rs.getLong("SchemaVersion");
                                if (clusterInfo.getClusterType() == ClusterInfo.Type.SOURCE && schemaVersion > 0L && table.getLastMetaUpdateTime() == -1L) {
                                    LOG.info("The schema of table {}.{} has been modified, schema version: {}.", (Object)db.getDbName(), (Object)table.getTableName(), (Object)schemaVersion);
                                }
                                schemas.add(new IndexSchema(rs.getLong("IndexId"), indexName, schemaVersion, rs.getInt("SchemaHash"), rs.getInt("ShortKeyColumnCount"), rs.getString("StorageType"), rs.getString("Keys")));
                            }
                            table.setIndexSchemaMap(schemas);
                            LOG.debug("Get {} index schemas. database->{}, table->{} on the {} cluster.", (Object)schemas.size(), (Object)db.getDbName(), (Object)table.getTableName(), (Object)clusterType);
                        }
                        catch (Exception e) {
                            String errorMsg = String.format("Failed to get index schema info on the %s cluster. detail: db->%s, table->%s", clusterType, db.getDbName(), table.getTableName());
                            LOG.error(errorMsg, (Throwable)e);
                        }
                        return null;
                    };
                    Utils.execQuerySql(getIndexSchemaSql, clusterInfo, indexSchemaFunc);
                });
                futures.add(future);
            }
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                LOG.error("Failed to execute index schema meta task.", (Throwable)e);
            }
        }
    }

    private void updateTableMeta(ClusterInfo clusterInfo) {
        String clusterType = clusterInfo.getClusterType().toString();
        for (Database db : clusterInfo.getDbs()) {
            String string = String.format("Failed to get table info on the %s cluster. detail: db->%s", clusterType, db.getDbName());
            String getTableSql = String.format("SHOW PROC '/dbs/%s/'", db.getDbId());
            Function<ResultSet, Void> tableFunc = rs -> {
                try {
                    HashMap<String, Table> tables = new HashMap<String, Table>();
                    while (rs.next()) {
                        Table.PartitionType partitionType;
                        String tableName = rs.getString("TableName");
                        String tableType = rs.getString("Type");
                        TTableType thriftTableType = Utils.toTTableType(tableType);
                        if (thriftTableType != TTableType.OLAP_TABLE && thriftTableType != TTableType.MATERIALIZED_VIEW && thriftTableType != TTableType.VIEW) {
                            LOG.debug("Ignore the table {}.{}, table type: {}", (Object)db.getDbName(), (Object)tableName, (Object)tableType);
                            continue;
                        }
                        if (!this.syncConf.shouldKeepTable(db.getDbName(), tableName)) continue;
                        String partitionKey = rs.getString("PartitionColumnName");
                        boolean hasPartitionTypeColumn = false;
                        ResultSetMetaData rsmd = rs.getMetaData();
                        int columnCount = rsmd.getColumnCount();
                        for (int i = 1; i <= columnCount; ++i) {
                            if (!rsmd.getColumnName(i).equals("PartitionType")) continue;
                            hasPartitionTypeColumn = true;
                            break;
                        }
                        if (hasPartitionTypeColumn) {
                            String partitionTypeString = rs.getString("PartitionType");
                            partitionType = Table.PartitionType.valueOf(partitionTypeString);
                        } else {
                            partitionType = partitionKey == null ? Table.PartitionType.UNPARTITIONED : Table.PartitionType.RANGE;
                            LOG.warn("Failed to get PartitionType of table {}.{}, use {} according to PartitionColumnName {}", (Object)db.getDbName(), (Object)tableName, (Object)partitionType, (Object)partitionKey);
                        }
                        tables.put(tableName, new Table(rs.getLong("TableId"), tableName, thriftTableType, partitionType, partitionKey));
                    }
                    db.updateTables(tables);
                    LOG.info("Get {} tables. database->{} on the {} cluster.", (Object)tables.size(), (Object)db.getDbName(), (Object)clusterType);
                }
                catch (Exception e) {
                    LOG.error(errorMsg, (Throwable)e);
                }
                return null;
            };
            Utils.execQuerySql(getTableSql, clusterInfo, tableFunc);
        }
        ArrayList futures = new ArrayList();
        for (Database database : clusterInfo.getDbs()) {
            for (Table table : database.getTables()) {
                if (table.getTableType() != TTableType.OLAP_TABLE) continue;
                Future<?> future = this.metaExecutorService.submit(() -> {
                    String errorMsg = String.format("Failed to get column info on the %s cluster. detail: db->%s, table->%s", clusterType, db.getDbName(), table.getTableName());
                    String getTableUpdateTimeSql = String.format("SELECT TABLE_SCHEMA, TABLE_NAME, UNIX_TIMESTAMP(CREATE_TIME) AS TBL_CREATE_TIME, UNIX_TIMESTAMP(UPDATE_TIME) AS TBL_UPDATE_TIME FROM information_schema.tables WHERE TABLE_SCHEMA = \"%s\" AND TABLE_NAME = \"%s\"", db.getDbName(), table.getTableName());
                    Function<ResultSet, Void> updateFunc = rs -> {
                        try {
                            while (rs.next()) {
                                if (rs.getRow() > 1) {
                                    throw new SQLException(errorMsg);
                                }
                                long createTime = rs.getLong("TBL_CREATE_TIME");
                                long updateTime = rs.getLong("TBL_UPDATE_TIME");
                                table.setCreateTime(createTime);
                                table.setLastUpdateTime(updateTime);
                            }
                        }
                        catch (Exception e) {
                            LOG.error(errorMsg, (Throwable)e);
                        }
                        return null;
                    };
                    Utils.execQuerySql(getTableUpdateTimeSql, clusterInfo, updateFunc);
                    String getColumnSql = String.format("SHOW COLUMNS FROM `%s`.`%s`", db.getDbName(), table.getTableName());
                    Function<ResultSet, Void> columnFunc = rs -> {
                        try {
                            ArrayList<String> columnNames = new ArrayList<String>();
                            ArrayList<String> columnTypes = new ArrayList<String>();
                            while (rs.next()) {
                                columnNames.add(rs.getString("Field"));
                                columnTypes.add(rs.getString("Type"));
                            }
                            table.setColumnNames(columnNames);
                            table.setColumnTypes(columnTypes);
                            LOG.debug("Get {} columns. database->{}, table->{}.", (Object)columnNames.size(), (Object)db.getDbName(), (Object)table.getTableName());
                        }
                        catch (Exception e) {
                            LOG.error(errorMsg, (Throwable)e);
                        }
                        return null;
                    };
                    Utils.execQuerySql(getColumnSql, clusterInfo, columnFunc);
                    String showDataSql = String.format("SHOW DATA FROM `%s`.`%s`", db.getDbName(), table.getTableName());
                    Function<ResultSet, Void> tableDataFunc = rs -> {
                        try {
                            while (rs.next()) {
                                String tableName = rs.getString("TableName");
                                if (!tableName.equals(table.getTableName())) continue;
                                String dataSize = rs.getString("Size");
                                table.setDataSize(Utils.convertDataSizeToLong(dataSize));
                            }
                        }
                        catch (Exception e) {
                            LOG.error(errorMsg, (Throwable)e);
                        }
                        return null;
                    };
                    Utils.execQuerySql(showDataSql, clusterInfo, tableDataFunc);
                    String showBucketNumSql = String.format("SHOW PARTITIONS FROM `%s`.`%s` ORDER BY PartitionId ASC;", db.getDbName(), table.getTableName());
                    Function<ResultSet, Void> bucketFunc = rs -> {
                        try {
                            while (rs.next() && rs.getRow() <= 1) {
                                int bucketNum = Integer.parseInt(rs.getString("Buckets"));
                                table.setBucketNum(bucketNum);
                            }
                        }
                        catch (Exception e) {
                            LOG.error(errorMsg, (Throwable)e);
                        }
                        return null;
                    };
                    Utils.execQuerySql(showBucketNumSql, clusterInfo, bucketFunc);
                    String showIndexSql = String.format("SHOW INDEX FROM `%s`.`%s`", db.getDbName(), table.getTableName());
                    Function<ResultSet, Void> bitmapIndexFunc = rs -> {
                        HashMap<String, BitmapIndex> bitmapIndexes = new HashMap<String, BitmapIndex>();
                        try {
                            while (rs.next()) {
                                String dbName = db.getDbName();
                                String tableName = table.getTableName();
                                String indexName = rs.getString("Key_name");
                                String columnName = rs.getString("Column_name");
                                String indexType = rs.getString("Index_type");
                                String comment = rs.getString("Comment");
                                BitmapIndex bitmapIndex = new BitmapIndex(dbName, tableName, indexName, columnName, indexType, comment);
                                bitmapIndexes.put(indexName, bitmapIndex);
                            }
                            table.setBitmapIndexes(bitmapIndexes);
                        }
                        catch (Exception e) {
                            LOG.error(errorMsg, (Throwable)e);
                        }
                        return null;
                    };
                    Utils.execQuerySql(showIndexSql, clusterInfo, bitmapIndexFunc);
                    String showCreateTableSql = String.format("SHOW CREATE TABLE `%s`.`%s`", db.getDbName(), table.getTableName());
                    Function<ResultSet, Void> setDynamicPartitionFunc = rs -> {
                        try {
                            while (rs.next() && rs.getRow() <= 1) {
                                String createTableStmt = rs.getString("Create Table");
                                this.updateTablePropertiesAndIndexes(createTableStmt, table);
                            }
                        }
                        catch (Exception e) {
                            LOG.error(errorMsg, (Throwable)e);
                        }
                        return null;
                    };
                    Utils.execQuerySql(showCreateTableSql, clusterInfo, setDynamicPartitionFunc);
                });
                futures.add(future);
            }
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                LOG.error("Failed to execute table meta task.", (Throwable)e);
            }
        }
    }

    private void updateTablePropertiesAndIndexes(String showCreateTableResult, Table table) {
        String[] splits = showCreateTableResult.split("\n");
        Pattern pattern = Pattern.compile("date_trunc\\('(.*)',");
        Pattern propertyPattern = Pattern.compile("\"(.*?)\"\\s*=\\s*\"(.*?)\"");
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String split : splits) {
            String propertyDefSql;
            Matcher matcher;
            Matcher matcher2;
            if (split.contains("\"dynamic_partition.enable\" = \"true\"")) {
                table.setDynamicPartitionTable(true);
            }
            if (split.contains("PARTITION BY date_trunc") && (matcher2 = pattern.matcher(split)).find()) {
                String unit = matcher2.group(1);
                table.setExprPartitionFunc(Table.ExprPartitionFunc.DATE_TRUNC);
                table.setExprPartitionIntervalUnit(unit);
            }
            if (split.contains("PARTITION BY time_slice")) {
                table.setExprPartitionFunc(Table.ExprPartitionFunc.TIME_SLICE);
            }
            if (split.contains("USING BITMAP")) {
                if (split.endsWith(",")) {
                    split = split.substring(0, split.length() - 1);
                }
                String[] indexInfoList = split.trim().split(" ");
                String indexName = indexInfoList[1];
                BitmapIndex bitmapIndex = table.getBitmapIndex(indexName);
                String createIndexSql = String.format("ALTER TABLE `%s`.`%s` ADD %s", bitmapIndex.getDbName(), bitmapIndex.getTableName(), split);
                bitmapIndex.setCreateIndexSql(createIndexSql);
            }
            if (!split.contains(" = ") || !(matcher = propertyPattern.matcher(propertyDefSql = split.trim())).find()) continue;
            String key = matcher.group(1);
            String value = matcher.group(2);
            properties.put(key, value);
        }
        if (!properties.isEmpty()) {
            table.setProperties(properties);
        }
    }

    private void updateDbMeta(ClusterInfo clusterInfo) {
        String clusterType = clusterInfo.getClusterType().toString();
        String errorMsg = String.format("Failed to get database info on the %s cluster.", clusterType);
        Function<ResultSet, Void> dbFunc = rs -> {
            try {
                HashMap<String, Database> dbs = new HashMap<String, Database>();
                while (rs.next()) {
                    String dbName = rs.getString("DbName");
                    String[] splits = dbName.split(":");
                    if (Utils.IGNORED_DATABASES.contains(dbName = splits[splits.length - 1])) {
                        LOG.debug("Ignore system database {}", (Object)dbName);
                        continue;
                    }
                    if (!this.syncConf.shouldKeepDb(dbName)) continue;
                    long dbId = rs.getLong("DbId");
                    dbs.put(dbName, new Database(dbId, dbName));
                }
                clusterInfo.updateDbs(dbs);
                LOG.info("Get {} databases on the {} cluster.", (Object)dbs.size(), (Object)clusterType);
            }
            catch (Exception e) {
                LOG.error(errorMsg, (Throwable)e);
            }
            return null;
        };
        Utils.execQuerySql("SHOW PROC '/dbs/'", clusterInfo, dbFunc);
        if (clusterInfo.getClusterType() == ClusterInfo.Type.TARGET) {
            for (Database db : clusterInfo.getDbs()) {
                String showDbRunningTxnsSql = String.format("SHOW PROC '/transactions/%s/running'", db.getDbId());
                Function<ResultSet, Void> runningTxnFunc = rs -> {
                    try {
                        HashMap<String, TransactionState> txns = new HashMap<String, TransactionState>();
                        while (rs.next()) {
                            String txnSource = rs.getString("LoadJobSourceType");
                            if (!txnSource.equals("REPLICATION")) continue;
                            long txnId = rs.getLong("TransactionId");
                            String txnLabel = rs.getString("Label");
                            txns.put(txnLabel, new TransactionState(txnId, txnLabel, rs.getString("Coordinator"), rs.getString("TransactionStatus"), txnSource, rs.getString("PrepareTime"), rs.getString("CommitTime"), rs.getString("PublishTime"), rs.getString("FinishTime"), rs.getString("Reason"), rs.getString("ErrorReplicasCount"), rs.getString("ListenerId"), rs.getString("TimeoutMs"), rs.getString("ErrMsg")));
                        }
                        db.setRunningReplicationTxns(txns);
                    }
                    catch (Exception e) {
                        LOG.error(errorMsg, (Throwable)e);
                    }
                    return null;
                };
                Utils.execQuerySql(showDbRunningTxnsSql, clusterInfo, runningTxnFunc);
                String showDbFinishedTxnsSql = String.format("SHOW PROC '/transactions/%s/finished'", db.getDbId());
                Function<ResultSet, Void> finishedTxnFunc = rs -> {
                    try {
                        HashMap<String, TransactionState> txns = new HashMap<String, TransactionState>();
                        while (rs.next()) {
                            String txnSource = rs.getString("LoadJobSourceType");
                            if (!txnSource.equals("REPLICATION")) continue;
                            long txnId = rs.getLong("TransactionId");
                            String txnLabel = rs.getString("Label");
                            txns.put(txnLabel, new TransactionState(txnId, txnLabel, rs.getString("Coordinator"), rs.getString("TransactionStatus"), txnSource, rs.getString("PrepareTime"), rs.getString("CommitTime"), rs.getString("PublishTime"), rs.getString("FinishTime"), rs.getString("Reason"), rs.getString("ErrorReplicasCount"), rs.getString("ListenerId"), rs.getString("TimeoutMs"), rs.getString("ErrMsg")));
                        }
                        db.setFinishedReplicationTxns(txns);
                    }
                    catch (Exception e) {
                        LOG.error(errorMsg, (Throwable)e);
                    }
                    return null;
                };
                Utils.execQuerySql(showDbFinishedTxnsSql, clusterInfo, finishedTxnFunc);
            }
        }
    }

    public ClusterInfo getSourceClusterInfo() {
        return this.sourceClusterInfo;
    }

    public ClusterInfo getTargetClusterInfo() {
        return this.targetClusterInfo;
    }

    public String getTxnStatus(String jobToken) {
        String status = SyncJob.JobState.UNKNOWN.name();
        String[] tokens = jobToken.split("_");
        String identifier = tokens[0];
        String jobId = tokens[1];
        String[] dbAndTable = identifier.split("-");
        long dbId = Long.parseLong(dbAndTable[0]);
        Database db = this.targetClusterInfo.getDb(dbId);
        for (String label : db.getRunningReplicationTxns().keySet()) {
            if (!label.endsWith(jobId)) continue;
            status = SyncJob.JobState.RUNNING.name();
            break;
        }
        for (String label : db.getFinishedReplicationTxns().keySet()) {
            if (!label.endsWith(jobId)) continue;
            TransactionState txnState = db.getFinishedReplicationTxns().get(label);
            if (txnState.getTransactionStatus().equals("VISIBLE")) {
                status = SyncJob.JobState.FINISHED.name();
                break;
            }
            status = SyncJob.JobState.FAILED.name() + "_" + txnState;
            break;
        }
        return status;
    }

    public void reportDbProgress() {
        Set<String> srcDbNames = this.sourceClusterInfo.getDbNames();
        Set<String> targetDbNames = this.targetClusterInfo.getDbNames();
        Set<String> srcDbsOnly = Utils.setDifference(srcDbNames, targetDbNames);
        Set<String> targetDbsOnly = Utils.setDifference(targetDbNames, srcDbNames);
        Set<String> commonDbNames = Utils.setIntersection(srcDbNames, targetDbNames);
        LOG.info("Databases pending synchronization: {}", (Object)srcDbsOnly);
        LOG.info("Databases that only exist in the target cluster: {}", (Object)targetDbsOnly);
        long srcDataSizeTotal = 0L;
        long targetDataSizeTotal = 0L;
        long diffDataSizeTotal = 0L;
        long srcRunningTotal = 0L;
        long targetRunningTotal = 0L;
        long srcFinishedTotal = 0L;
        long targetFinishedTotal = 0L;
        for (String dbName : commonDbNames) {
            Database srcDb = this.sourceClusterInfo.getDb(dbName);
            Database targetDb = this.targetClusterInfo.getDb(dbName);
            long srcDataSize = srcDb.getTotalDataSize();
            srcDataSizeTotal += srcDataSize;
            long targetDataSize = targetDb.getTotalDataSize();
            targetDataSizeTotal += targetDataSize;
            long diffDataSize = srcDataSize - targetDataSize;
            diffDataSizeTotal += diffDataSize;
            LOG.info("Database {}, source size: {}, target size: {}, diff: {}", (Object)dbName, (Object)Utils.convertDataSizeToString(srcDataSize), (Object)Utils.convertDataSizeToString(targetDataSize), (Object)Utils.convertDataSizeToString(Math.abs(diffDataSize)));
            int srcRunning = srcDb.getRunningReplicationTxns().size();
            srcRunningTotal += (long)srcRunning;
            int srcFinished = srcDb.getFinishedReplicationTxns().size();
            srcFinishedTotal += (long)srcFinished;
            int targetRunning = targetDb.getRunningReplicationTxns().size();
            targetRunningTotal += (long)targetRunning;
            int targetFinished = targetDb.getFinishedReplicationTxns().size();
            targetFinishedTotal += (long)targetFinished;
            LOG.info("Database {} , source running txn: {}, source finished txn: {}, target running txn: {}, target finished txn: {}", (Object)dbName, (Object)srcRunning, (Object)srcFinished, (Object)targetRunning, (Object)targetFinished);
        }
        LOG.info("Total source size: {}, total target size: {}, total diff: {}", (Object)Utils.convertDataSizeToString(srcDataSizeTotal), (Object)Utils.convertDataSizeToString(targetDataSizeTotal), (Object)Utils.convertDataSizeToString(Math.abs(diffDataSizeTotal)));
        LOG.info("Total source running txn: {}, total source finished txn: {}, total target running txn: {}, total target finished txn: {}", (Object)srcRunningTotal, (Object)srcFinishedTotal, (Object)targetRunningTotal, (Object)targetFinishedTotal);
    }

    public List<String> getAllSourceTables() {
        ArrayList<String> result = new ArrayList<String>();
        List<Database> dbs = this.sourceClusterInfo.getDbs();
        for (Database db : dbs) {
            Set<String> tableNames = db.getTableNames();
            tableNames.forEach(tableName -> result.add(db.getDbName() + "." + tableName));
        }
        return result;
    }

    public List<String> getAllIgnoredTables() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, Integer> entry : this.skippedReplicationTables.entrySet()) {
            if (entry.getValue() < 3) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public List<String> getDynamicIgnoredTables() {
        return new ArrayList<String>(this.dynamicSkippedReplicationTables);
    }

    public List<String> getPartialReplicationTables() {
        return new ArrayList<String>(this.partialReplicationTables);
    }

    private String getReplicationJobId() {
        long currentTimeMillis = System.currentTimeMillis();
        return String.format("%s-%s", currentTimeMillis, this.replicationJobId++);
    }
}

