/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.rpc;

import com.starrocks.common.ClientPool;
import com.starrocks.thrift.FrontendService;
import com.starrocks.thrift.TNetworkAddress;
import java.net.SocketTimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;

public class FrontendServiceProxy {
    private static final Logger LOG = LogManager.getLogger(FrontendServiceProxy.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T call(TNetworkAddress address, int timeoutMs, int retryTimes, MethodCallable<T> callable) throws Exception {
        FrontendService.Client client = ClientPool.frontendPool.borrowObject(address, timeoutMs);
        boolean isConnValid = false;
        try {
            for (int i = 0; i < retryTimes; ++i) {
                T t2;
                try {
                    T t3 = callable.invoke(client);
                    isConnValid = true;
                    t2 = t3;
                }
                catch (TTransportException te) {
                    try {
                        isConnValid = ClientPool.frontendPool.reopen(client, timeoutMs);
                        if (i == retryTimes - 1 || !isConnValid || te.getCause() instanceof SocketTimeoutException) {
                            LOG.warn("call frontend thrift rpc failed, addr: {}, retried: {}", (Object)address, (Object)i, (Object)te);
                            throw te;
                        }
                        LOG.debug("call frontend thrift rpc failed, addr: {}, retried: {}", (Object)address, (Object)i, (Object)te);
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        throw new Exception("unexpected");
                    }
                }
                return t2;
            }
        }
        finally {
            if (isConnValid) {
                ClientPool.frontendPool.returnObject(address, client);
            } else {
                ClientPool.frontendPool.invalidateObject(address, client);
            }
        }
    }

    public static interface MethodCallable<T> {
        public T invoke(FrontendService.Client var1) throws TException;
    }
}

