/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.netty;

import com.starrocks.common.Utils;
import com.starrocks.sync.ClusterMetaKeeper;
import com.starrocks.sync.ReplicationJob;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.CharsetUtil;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyncHttpServerHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final Logger LOG = LogManager.getLogger(SyncHttpServerHandler.class);
    private final ClusterMetaKeeper clusterMetaKeeper;
    private final Map<String, String> replicationJobState;
    private final Map<String, Map<String, String>> replicationTableStatus;
    private final Map<String, List<String>> progressReportDetail;
    private final Map<String, String> finishedTableStatus;
    private final ConcurrentLinkedDeque<ReplicationJob> replicationJobQueue;

    public SyncHttpServerHandler(ClusterMetaKeeper clusterMetaKeeper, Map<String, String> replicationJobState, Map<String, Map<String, String>> replicationTableStatus, Map<String, List<String>> progressReportDetail, Map<String, String> finishedTableStatus, ConcurrentLinkedDeque<ReplicationJob> replicationJobQueue) {
        this.clusterMetaKeeper = clusterMetaKeeper;
        this.replicationJobState = replicationJobState;
        this.replicationTableStatus = replicationTableStatus;
        this.progressReportDetail = progressReportDetail;
        this.finishedTableStatus = finishedTableStatus;
        this.replicationJobQueue = replicationJobQueue;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, HttpObject httpObject) {
        if (httpObject instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)httpObject;
            try {
                URI uri = new URI(req.uri());
                String path = uri.getPath();
                QueryStringDecoder queryStringDecoder = new QueryStringDecoder(req.uri());
                Map<String, List<String>> parameters = queryStringDecoder.parameters();
                switch (path) {
                    case "/test": {
                        this.doGet(ctx, "I'm fine, thank you");
                        break;
                    }
                    case "/clusterMetaKeeper": {
                        String db = parameters.get("db").get(0);
                        String tbl = parameters.get("tbl").get(0);
                        String sourceTableInfo = this.clusterMetaKeeper.getSourceClusterInfo().getDb(db).getTable(tbl).toString();
                        String targetTableInfo = this.clusterMetaKeeper.getTargetClusterInfo().getDb(db).getTable(tbl).toString();
                        this.doGet(ctx, sourceTableInfo);
                        this.doGet(ctx, targetTableInfo);
                        break;
                    }
                    case "/replicationJobState": {
                        this.doGet(ctx, Utils.toJson(this.replicationJobState));
                        break;
                    }
                    case "/replicationTableStatus": {
                        if (parameters.isEmpty()) {
                            this.doGet(ctx, Utils.toJson(this.replicationTableStatus));
                            break;
                        }
                        String tableStatusKey = parameters.get("key").get(0);
                        this.doGet(ctx, Utils.toJson(this.replicationTableStatus.get(tableStatusKey)));
                        break;
                    }
                    case "/progressReportDetail": {
                        if (parameters.isEmpty()) {
                            this.doGet(ctx, Utils.toJson(this.progressReportDetail));
                            break;
                        }
                        String progressKey = parameters.get("key").get(0);
                        this.doGet(ctx, Utils.toJson(this.progressReportDetail.get(progressKey)));
                        break;
                    }
                    case "/replicationJobQueue": {
                        this.doGet(ctx, Utils.toJson(this.replicationJobQueue));
                        break;
                    }
                    case "/finishedTableStatus": {
                        this.doGet(ctx, Utils.toJson(this.finishedTableStatus));
                        break;
                    }
                    default: {
                        String errorMsg = "No path for " + req.uri();
                        this.doGet(ctx, errorMsg);
                        break;
                    }
                }
            }
            catch (Exception e) {
                String errorMsg = "Are you OK? uri = " + req.uri();
                LOG.warn(errorMsg, (Throwable)e);
                this.doGet(ctx, errorMsg);
            }
        }
    }

    private void doGet(ChannelHandlerContext ctx, String msg) {
        ByteBuf byteBuf = Unpooled.copiedBuffer(msg, CharsetUtil.UTF_8);
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, byteBuf);
        defaultFullHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json; charset=UTF-8");
        defaultFullHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)byteBuf.readableBytes());
        ctx.writeAndFlush(defaultFullHttpResponse).addListener(ChannelFutureListener.CLOSE);
    }
}

