/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.meta;

import com.starrocks.common.Utils;
import com.starrocks.meta.BitmapIndex;
import com.starrocks.meta.IndexSchema;
import com.starrocks.meta.MaterializedView;
import com.starrocks.meta.Partition;
import com.starrocks.thrift.TTableType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Table {
    private static final Logger LOG = LogManager.getLogger(Table.class);
    private final long tableId;
    private final String tableName;
    private final PartitionType partitionType;
    private final String partitionKey;
    private final Map<String, Partition> partitions;
    private final List<String> columnNames;
    private final List<String> columnTypes;
    private final TTableType tableType;
    private boolean isDynamicPartitionTable;
    private ExprPartitionFunc exprPartitionFunc;
    private String exprPartitionIntervalUnit;
    private long dataSize;
    private int bucketNum;
    private long createTime = -1L;
    private long lastUpdateTime = -1L;
    private long lastMetaUpdateTime = -1L;
    private final Map<Long, IndexSchema> indexSchemaMap;
    private final Map<String, BitmapIndex> bitmapIndexes;
    private final Map<String, String> properties;
    private final Map<String, MaterializedView> rollupMaterializedViews;

    public Table(long tableId, String tableName, TTableType tableType, PartitionType partitionType, String partitionKey) {
        this.tableId = tableId;
        this.tableName = tableName;
        this.tableType = tableType;
        this.partitionType = partitionType;
        this.partitionKey = partitionKey;
        this.partitions = new HashMap<String, Partition>();
        this.columnNames = new ArrayList<String>();
        this.columnTypes = new ArrayList<String>();
        this.indexSchemaMap = new HashMap<Long, IndexSchema>();
        this.bitmapIndexes = new HashMap<String, BitmapIndex>();
        this.properties = new HashMap<String, String>();
        this.rollupMaterializedViews = new HashMap<String, MaterializedView>();
    }

    public long getTableId() {
        return this.tableId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setPartitions(List<Partition> partitions) {
        this.partitions.clear();
        partitions.forEach(partition -> this.partitions.put(partition.getPartitionName(), (Partition)partition));
    }

    public void setIndexSchemaMap(List<IndexSchema> indexSchemas) {
        this.indexSchemaMap.clear();
        indexSchemas.forEach(indexSchema -> this.indexSchemaMap.put(indexSchema.getIndexId(), (IndexSchema)indexSchema));
    }

    public IndexSchema getIndexSchema(long indexId) {
        return this.indexSchemaMap.get(indexId);
    }

    public IndexSchema getBaseIndexSchema() {
        return this.indexSchemaMap.values().stream().filter(v -> v.getIndexName().equals(this.tableName)).findFirst().orElse(null);
    }

    public Set<String> getRollupMaterializedViewNames() {
        return this.indexSchemaMap.values().stream().filter(v -> !v.getIndexName().equals(this.tableName)).map(IndexSchema::getIndexName).collect(Collectors.toSet());
    }

    public Set<String> getPartitionNames() {
        return this.partitions.keySet();
    }

    public Set<String> getReadyPartitionNames() {
        return this.partitions.values().stream().filter(Partition::isReady).map(Partition::getPartitionName).collect(Collectors.toSet());
    }

    public Partition getPartition(String partitionName) {
        return this.partitions.get(partitionName);
    }

    public PartitionType getPartitionType() {
        return this.partitionType;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public List<Partition> getPartitions() {
        return new ArrayList<Partition>(this.partitions.values());
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames.clear();
        this.columnNames.addAll(columnNames);
    }

    public void setColumnTypes(List<String> columnTypes) {
        this.columnTypes.clear();
        this.columnTypes.addAll(columnTypes);
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<String> getColumnTypes() {
        return this.columnTypes;
    }

    public boolean schemaEqual(Table other) {
        List<String> columnNames = this.getColumnNames();
        List<String> columnTypes = this.getColumnTypes();
        List<String> otherColumnNames = other.getColumnNames();
        List<String> otherColumnTypes = other.getColumnTypes();
        if (columnNames.size() != columnTypes.size() || otherColumnNames.size() != otherColumnTypes.size()) {
            LOG.warn(String.format("Schema change: get the wrong schema for table %s.", this.getTableName()));
            return false;
        }
        if (columnNames.size() != otherColumnNames.size()) {
            LOG.warn(String.format("Schema change: the schema size is different for table %s.", this.getTableName()));
            return false;
        }
        int size = columnNames.size();
        for (int i = 0; i < size; ++i) {
            if (!columnNames.get(i).equals(otherColumnNames.get(i))) {
                LOG.warn(String.format("Schema change: the column name %s is different from %s for table %s.", columnNames.get(i), otherColumnNames.get(i), this.getTableName()));
                return false;
            }
            if (columnTypes.get(i).equals(otherColumnTypes.get(i))) continue;
            if (columnTypes.get(i).startsWith("decimal") && otherColumnTypes.get(i).startsWith("decimal")) {
                LOG.warn(String.format("Schema change can be ignored: the column type %s is different from %s for table %s.", columnTypes.get(i), otherColumnTypes.get(i), this.getTableName()));
                continue;
            }
            LOG.warn(String.format("Schema change: the column type %s is different from %s for table %s.", columnTypes.get(i), otherColumnTypes.get(i), this.getTableName()));
            return false;
        }
        if (this.getBaseIndexSchema().getSchemaVersion() != other.getBaseIndexSchema().getSchemaVersion()) {
            LOG.warn("Schema change: the schema version {} is different from {} for table {}.", (Object)this.getBaseIndexSchema().getSchemaVersion(), (Object)other.getBaseIndexSchema().getSchemaVersion(), (Object)this.getTableName());
            return false;
        }
        return true;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public void updateLastMetaTime() {
        this.lastMetaUpdateTime = this.lastUpdateTime;
    }

    public boolean isLatestMeta() {
        return this.lastMetaUpdateTime != -1L && this.lastMetaUpdateTime == this.lastUpdateTime;
    }

    public long getLastMetaUpdateTime() {
        return this.lastMetaUpdateTime;
    }

    public TTableType getTableType() {
        return this.tableType;
    }

    public String toString() {
        return Utils.toJson(this);
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(long dataSize) {
        this.dataSize = dataSize;
    }

    public int getBucketNum() {
        return this.bucketNum;
    }

    public void setBucketNum(int bucketNum) {
        this.bucketNum = bucketNum;
    }

    public boolean isDynamicPartitionTable() {
        return this.isDynamicPartitionTable;
    }

    public void setDynamicPartitionTable(boolean dynamicPartitionTable) {
        this.isDynamicPartitionTable = dynamicPartitionTable;
    }

    public String getExprPartitionIntervalUnit() {
        return this.exprPartitionIntervalUnit;
    }

    public void setExprPartitionIntervalUnit(String exprPartitionIntervalUnit) {
        this.exprPartitionIntervalUnit = exprPartitionIntervalUnit;
    }

    public void setExprPartitionFunc(ExprPartitionFunc exprPartitionFunc) {
        this.exprPartitionFunc = exprPartitionFunc;
    }

    public ExprPartitionFunc getExprPartitionFunc() {
        return this.exprPartitionFunc;
    }

    public BitmapIndex getBitmapIndex(String indexName) {
        return this.bitmapIndexes.get(indexName);
    }

    public Set<String> getBitmapIndexNames() {
        return this.bitmapIndexes.keySet();
    }

    public void setBitmapIndexes(Map<String, BitmapIndex> bitmapIndexes) {
        this.bitmapIndexes.clear();
        this.bitmapIndexes.putAll(bitmapIndexes);
    }

    public void setProperties(Map<String, String> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
    }

    public String getPropertyValue(String key) {
        return this.properties.get(key);
    }

    public Set<String> getPropertyKeys() {
        return this.properties.keySet();
    }

    public void setRollupMaterializedViews(Map<String, MaterializedView> materializedViews) {
        this.rollupMaterializedViews.clear();
        this.rollupMaterializedViews.putAll(materializedViews);
    }

    public MaterializedView getRollupMaterializedView(String materializedViewName) {
        return this.rollupMaterializedViews.get(materializedViewName);
    }

    public static enum ExprPartitionFunc {
        DATE_TRUNC,
        TIME_SLICE;

    }

    public static enum PartitionType {
        LIST,
        RANGE,
        EXPR_RANGE,
        EXPR_RANGE_V2,
        UNPARTITIONED;

    }
}

