/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.meta;

import com.starrocks.common.Utils;
import com.starrocks.meta.Index;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Partition {
    private final long partitionId;
    private final String partitionName;
    private final String partitionValue;
    private final long visibleVersion;
    private final long visibleVersionTime;
    private final Map<String, Index> indices;
    private final String distributionKey;
    private final int buckets;
    private final int replicationNum;
    private final long dataSize;
    private boolean isReady = false;

    public Partition(long partitionId, String partitionName, String partitionValue, String distributionKey, int buckets, int replicationNum, long visibleVersion, long visibleVersionTime, long dataSize) {
        this.partitionId = partitionId;
        this.partitionName = partitionName;
        this.partitionValue = partitionValue;
        this.distributionKey = distributionKey;
        this.buckets = buckets;
        this.replicationNum = replicationNum;
        this.visibleVersion = visibleVersion;
        this.visibleVersionTime = visibleVersionTime;
        this.dataSize = dataSize;
        this.indices = new HashMap<String, Index>();
    }

    public long getPartitionId() {
        return this.partitionId;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public String getPartitionValue() {
        return this.partitionValue;
    }

    public long getVisibleVersion() {
        return this.visibleVersion;
    }

    public long getVisibleVersionTime() {
        return this.visibleVersionTime;
    }

    public void setIndices(List<Index> indices) {
        this.indices.clear();
        indices.forEach(index -> this.indices.put(index.getIndexName(), (Index)index));
    }

    public Set<String> getIndexNames() {
        return this.indices.keySet();
    }

    public Index getIndex(String indexName) {
        return this.indices.get(indexName);
    }

    public List<Index> getIndices() {
        return new ArrayList<Index>(this.indices.values());
    }

    public void setReady(boolean isReady) {
        this.isReady = isReady;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public String getDistributionKey() {
        return this.distributionKey;
    }

    public int getBuckets() {
        return this.buckets;
    }

    public int getReplicationNum() {
        return this.replicationNum;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public String toString() {
        return Utils.toJson(this);
    }
}

