/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.meta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JobProgress {
    private final List<String> abortedIds;
    private final List<String> committedIds;
    private final List<RunningJob> running;

    public JobProgress() {
        this.abortedIds = new ArrayList<String>();
        this.committedIds = new ArrayList<String>();
        this.running = new ArrayList<RunningJob>();
    }

    public JobProgress(List<String> abortedIds, List<String> committedIds, List<RunningJob> running) {
        this.abortedIds = abortedIds;
        this.committedIds = committedIds;
        this.running = running;
    }

    public Map<String, RunningJob> getRunningJobs() {
        HashMap<String, RunningJob> runningJobMap = new HashMap<String, RunningJob>();
        for (RunningJob job : this.getRunning()) {
            runningJobMap.put(job.jobId, job);
        }
        return runningJobMap;
    }

    public List<String> getAbortedIds() {
        return this.abortedIds;
    }

    public List<String> getCommittedIds() {
        return this.committedIds;
    }

    public List<RunningJob> getRunning() {
        return this.running;
    }

    public static class RunningJob {
        String jobId;
        long txnId;
        String state;
        int finishedTaskNum;
        int totalTaskNum;

        public RunningJob(String jobId, long txnId, String state, int finishedTaskNum, int totalTaskNum) {
            this.jobId = jobId;
            this.txnId = txnId;
            this.state = state;
            this.finishedTaskNum = finishedTaskNum;
            this.totalTaskNum = totalTaskNum;
        }

        public String getJobId() {
            return this.jobId;
        }

        public long getTxnId() {
            return this.txnId;
        }

        public String getState() {
            return this.state;
        }

        public int getFinishedTaskNum() {
            return this.finishedTaskNum;
        }

        public int getTotalTaskNum() {
            return this.totalTaskNum;
        }

        public double calculateRunningProgress() {
            double current = (double)this.finishedTaskNum * 1.0 / (double)this.totalTaskNum;
            return this.getState().equals("REPLICATING") ? 0.5 + current / 2.0 : current / 2.0;
        }
    }
}

