/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.meta;

import com.starrocks.common.Utils;
import com.starrocks.meta.MaterializedView;
import com.starrocks.meta.Table;
import com.starrocks.meta.TransactionState;
import com.starrocks.meta.View;
import com.starrocks.thrift.TTableType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class Database {
    private final long dbId;
    private final String dbName;
    private final Map<String, Table> tables;
    private final Map<Long, String> tableIdToName;
    private final Map<String, TransactionState> runningReplicationTxns;
    private final Map<String, TransactionState> finishedReplicationTxns;
    private final Map<String, MaterializedView> materializedViews;
    private final Map<String, View> views;

    public Database(long dbId, String dbName) {
        this.dbId = dbId;
        this.dbName = dbName;
        this.tables = new ConcurrentHashMap<String, Table>();
        this.tableIdToName = new ConcurrentHashMap<Long, String>();
        this.runningReplicationTxns = new ConcurrentHashMap<String, TransactionState>();
        this.finishedReplicationTxns = new ConcurrentHashMap<String, TransactionState>();
        this.materializedViews = new ConcurrentHashMap<String, MaterializedView>();
        this.views = new ConcurrentHashMap<String, View>();
    }

    public long getDbId() {
        return this.dbId;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void updateTables(Map<String, Table> tables) {
        Set<String> source = tables.keySet();
        Set<String> current = this.tables.keySet();
        Set<String> sourceOnly = Utils.setDifference(source, current);
        Set<String> common = Utils.setIntersection(source, current);
        Set<String> currentOnly = Utils.setDifference(current, source);
        for (String tableName : sourceOnly) {
            this.tables.put(tableName, tables.get(tableName));
            this.tableIdToName.put(tables.get(tableName).getTableId(), tableName);
        }
        for (String tableName : currentOnly) {
            Table table = this.tables.remove(tableName);
            this.tableIdToName.remove(table.getTableId());
        }
        for (String tableName : common) {
            if (this.tables.get(tableName).getTableId() == tables.get(tableName).getTableId()) continue;
            long originalId = this.tables.get(tableName).getTableId();
            this.tableIdToName.remove(originalId);
            this.tables.put(tableName, tables.get(tableName));
            this.tableIdToName.put(tables.get(tableName).getTableId(), tableName);
        }
    }

    public Table getTable(long tableId) {
        String tableName = this.tableIdToName.get(tableId);
        if (tableName != null) {
            return this.getTable(tableName);
        }
        return null;
    }

    public Table getTable(String tableName) {
        return this.tables.get(tableName);
    }

    public void removeTable(String tableName) {
        this.tables.remove(tableName);
    }

    public Set<String> getTableNames() {
        return this.getTableNamesByTableType(TTableType.OLAP_TABLE);
    }

    public List<Table> getTables() {
        return this.getTablesByTableType(TTableType.OLAP_TABLE);
    }

    public Set<String> getMaterializedViewTableNames() {
        return this.getTableNamesByTableType(TTableType.MATERIALIZED_VIEW);
    }

    public List<Table> getMaterializedViewTables() {
        return this.getTablesByTableType(TTableType.MATERIALIZED_VIEW);
    }

    public Set<String> getViewTableNames() {
        return this.getTableNamesByTableType(TTableType.VIEW);
    }

    public List<Table> getViewTables() {
        return this.getTablesByTableType(TTableType.VIEW);
    }

    public Set<String> getTableNamesByTableType(TTableType tableType) {
        return this.tables.entrySet().stream().filter(entry -> tableType.equals(((Table)entry.getValue()).getTableType())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public List<Table> getTablesByTableType(TTableType tableType) {
        return this.tables.values().stream().filter(table -> tableType.equals(table.getTableType())).collect(Collectors.toList());
    }

    public List<Table> getUpdatedTables(double clusterVersion) {
        if (clusterVersion >= 2.5) {
            return this.getTables().stream().filter(tbl -> !tbl.isLatestMeta()).collect(Collectors.toList());
        }
        return new ArrayList<Table>(this.tables.values());
    }

    public Map<String, TransactionState> getRunningReplicationTxns() {
        return this.runningReplicationTxns;
    }

    public Map<String, TransactionState> getFinishedReplicationTxns() {
        return this.finishedReplicationTxns;
    }

    public void setRunningReplicationTxns(Map<String, TransactionState> txns) {
        this.runningReplicationTxns.clear();
        this.runningReplicationTxns.putAll(txns);
    }

    public void setFinishedReplicationTxns(Map<String, TransactionState> txns) {
        this.finishedReplicationTxns.clear();
        this.finishedReplicationTxns.putAll(txns);
    }

    public void setMaterializedViews(Map<String, MaterializedView> materializedViews) {
        this.materializedViews.clear();
        this.materializedViews.putAll(materializedViews);
    }

    public void setViews(Map<String, View> views) {
        this.views.clear();
        this.views.putAll(views);
    }

    public MaterializedView getMaterializedView(String materializedViewName) {
        return this.materializedViews.get(materializedViewName);
    }

    public View getView(String viewName) {
        return this.views.get(viewName);
    }

    public long getTotalDataSize() {
        long dataSize = 0L;
        for (Table table : this.getTables()) {
            dataSize += table.getDataSize();
        }
        return dataSize;
    }

    public String toString() {
        return Utils.toJson(this);
    }
}

