/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.meta;

import com.starrocks.common.Utils;
import com.starrocks.meta.Backend;
import com.starrocks.meta.Database;
import com.starrocks.meta.Frontend;
import com.starrocks.meta.Version;
import com.starrocks.thrift.TRunMode;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClusterInfo {
    private static final Logger LOG = LogManager.getLogger(ClusterInfo.class);
    private final Type clusterType;
    private RunMode clusterRunMode;
    private Version clusterVersion;
    private final String userName;
    private final String password;
    private final String token;
    private String serviceId;
    List<Frontend> frontends;
    private final Map<Long, Backend> backends;
    private final Map<String, Database> dbs;
    private final Map<Long, String> dbIdToName;
    private final Map<String, HikariDataSource> feDataSources;
    private boolean connectionReady = false;
    private List<String> storageVolumeNameList;

    public static TRunMode toTRunMode(RunMode mode) {
        if (mode == RunMode.SHARED_DATA) {
            return TRunMode.SHARED_DATA;
        }
        return TRunMode.SHARED_NOTHING;
    }

    public ClusterInfo(Type clusterType, String userName, String password, String token) {
        this.userName = userName;
        this.password = password;
        this.token = token;
        this.dbs = new ConcurrentHashMap<String, Database>();
        this.dbIdToName = new ConcurrentHashMap<Long, String>();
        this.frontends = Collections.synchronizedList(new ArrayList());
        this.backends = new ConcurrentHashMap<Long, Backend>();
        this.clusterType = clusterType;
        this.feDataSources = new ConcurrentHashMap<String, HikariDataSource>();
    }

    public Set<String> getDbNames() {
        return this.dbs.keySet();
    }

    public Database getDb(long dbId) {
        return this.getDb(this.dbIdToName.get(dbId));
    }

    public Database getDb(String dbName) {
        return this.dbs.get(dbName);
    }

    public List<Database> getDbs() {
        return new ArrayList<Database>(this.dbs.values());
    }

    public void updateDbs(Map<String, Database> dbs) {
        Set<String> source = dbs.keySet();
        Set<String> current = this.dbs.keySet();
        Set<String> sourceOnly = Utils.setDifference(source, current);
        Set<String> common = Utils.setIntersection(source, current);
        Set<String> currentOnly = Utils.setDifference(current, source);
        for (String dbName : sourceOnly) {
            this.dbs.put(dbName, dbs.get(dbName));
            this.dbIdToName.put(dbs.get(dbName).getDbId(), dbName);
        }
        for (String dbName : currentOnly) {
            Database db = this.dbs.remove(dbName);
            this.dbIdToName.remove(db.getDbId());
        }
        for (String dbName : common) {
            if (this.dbs.get(dbName).getDbId() == dbs.get(dbName).getDbId()) continue;
            long originalId = this.dbs.get(dbName).getDbId();
            this.dbIdToName.remove(originalId);
            this.dbs.put(dbName, dbs.get(dbName));
            this.dbIdToName.put(dbs.get(dbName).getDbId(), dbName);
        }
    }

    public Backend getBackend(long backendId) {
        return this.backends.get(backendId);
    }

    public Map<Long, Backend> getBackends() {
        return this.backends;
    }

    public void setBackends(List<Backend> backends) {
        this.backends.clear();
        backends.forEach(be -> this.backends.put(be.getBackendId(), (Backend)be));
    }

    public void setFrontends(List<Frontend> frontends, int connectTimeoutMs, int socketTimeoutMs) {
        this.frontends.clear();
        this.frontends.addAll(frontends);
        for (Frontend fe2 : frontends) {
            if (this.feDataSources.containsKey(fe2.getHost())) continue;
            this.updateDataSource(fe2, connectTimeoutMs, socketTimeoutMs);
        }
        ArrayList<String> needRemove = new ArrayList<String>();
        for (String dataSourceFeHost : this.feDataSources.keySet()) {
            if (!frontends.stream().noneMatch(fe -> fe.getHost().equals(dataSourceFeHost))) continue;
            needRemove.add(dataSourceFeHost);
        }
        for (String dataSourceFeHost : needRemove) {
            HikariDataSource oldDataSource = this.feDataSources.get(dataSourceFeHost);
            if (oldDataSource != null) {
                try {
                    oldDataSource.close();
                    LOG.info("Closed old data source {} successfully.", (Object)oldDataSource.getJdbcUrl());
                }
                catch (Exception e) {
                    LOG.error("Failed to close old data source {}.", (Object)oldDataSource.getJdbcUrl(), (Object)e);
                }
            }
            this.feDataSources.remove(dataSourceFeHost);
        }
        this.connectionReady = true;
    }

    public void setStorageVolumes(List<String> storageVolumes) {
        this.storageVolumeNameList = storageVolumes;
    }

    public List<String> getStorageVolumes() {
        return this.storageVolumeNameList;
    }

    public RunMode getClusterRunMode() {
        return this.clusterRunMode;
    }

    public void setClusterRunMode(RunMode runMode) {
        this.clusterRunMode = runMode;
    }

    public void setClusterVersion(Version clusterVersion) {
        this.clusterVersion = clusterVersion;
    }

    public Version getClusterVersion() {
        return this.clusterVersion;
    }

    public boolean needUpdateClusterBasicMeta() {
        return this.getClusterRunMode() == null || this.getClusterVersion() == null;
    }

    public String getToken() {
        return this.token;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public Type getClusterType() {
        return this.clusterType;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public Connection getConnection() throws SQLException {
        return this.feDataSources.get(this.getRandomFrontend().getHost()).getConnection();
    }

    public Frontend getRandomFrontend() {
        if (this.frontends.isEmpty()) {
            LOG.error("Cannot get a valid frontend from {} cluster, please check your network.", (Object)this.clusterType);
            System.exit(-1);
        }
        int random = new Random().nextInt(this.frontends.size());
        return this.frontends.get(random);
    }

    public Frontend getLeaderFrontend() {
        for (Frontend fe : this.frontends) {
            if (!fe.getRole().equals("LEADER") && !fe.getIsMaster()) continue;
            return fe;
        }
        LOG.warn("Cannot get leader frontend.");
        return null;
    }

    public boolean isConnectionReady() {
        return this.connectionReady;
    }

    private void updateDataSource(Frontend fe, int connectTimeoutMs, int socketTimeoutMs) {
        HikariConfig config = new HikariConfig();
        String url = String.format("jdbc:mysql://%s:%d/", fe.getHost(), fe.getQueryPort());
        config.setJdbcUrl(url);
        config.setUsername(this.userName);
        config.setPassword(this.password);
        config.setConnectionTimeout(connectTimeoutMs);
        config.addDataSourceProperty("connectTimeout", connectTimeoutMs);
        config.addDataSourceProperty("socketTimeout", socketTimeoutMs);
        config.setMinimumIdle(2);
        config.setMaximumPoolSize(8);
        config.setPoolName("starrocks-conn-pool");
        HikariDataSource newDataSource = new HikariDataSource(config);
        this.feDataSources.put(fe.getHost(), newDataSource);
        LOG.info("Updated data source: {}, Role: {}.", (Object)newDataSource.getJdbcUrl(), (Object)fe.getRole());
    }

    public String toString() {
        return Utils.toJson(this);
    }

    public static enum RunMode {
        SHARED_NOTHING,
        SHARED_DATA,
        EXPERIMENTAL_HYBRID;

    }

    public static enum Type {
        SOURCE,
        TARGET;

    }
}

