/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.common;

import com.google.gson.Gson;
import com.starrocks.meta.ClusterInfo;
import com.starrocks.meta.Frontend;
import com.starrocks.meta.JobProgress;
import com.starrocks.meta.ReplicationState;
import com.starrocks.meta.Table;
import com.starrocks.meta.Version;
import com.starrocks.rpc.FrontendServiceProxy;
import com.starrocks.sync.DDLJob;
import com.starrocks.sync.ReplicationJob;
import com.starrocks.thrift.TNetworkAddress;
import com.starrocks.thrift.TStatusCode;
import com.starrocks.thrift.TTableReplicationRequest;
import com.starrocks.thrift.TTableReplicationResponse;
import com.starrocks.thrift.TTableType;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Utils {
    private static final Logger LOG = LogManager.getLogger(Utils.class);
    public static Set<String> incompatibleDDL = new HashSet<String>();
    private static int REPLICATION_TABLE_COUNT_LIMIT_LOG_COUNTER = 0;
    private static int REPLICATION_REPLICA_COUNT_LIMIT_LOG_COUNTER = 0;
    private static int REPLICATION_DATA_SIZE_LIMIT_LOG_COUNTER = 0;
    private static final ThreadLocal<SimpleDateFormat> SIMPLE_DATE_FORMATTER = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    private static final ThreadLocal<NumberFormat> PERCENT_FORMATTER = ThreadLocal.withInitial(() -> {
        NumberFormat formater = NumberFormat.getPercentInstance();
        formater.setMinimumFractionDigits(2);
        formater.setMaximumFractionDigits(2);
        return formater;
    });
    public static final String SHOW_CLUSTER_VERSION_SQL = "SELECT current_version() AS version";
    public static final String ADMIN_SHOW_RUN_MODE_SQL = "ADMIN SHOW FRONTEND CONFIG LIKE 'run_mode'";
    public static final String SHOW_FRONTENDS_SQL_PATTERN = "SHOW FRONTENDS";
    public static final String SHOW_BACKENDS_SQL_PATTERN = "SHOW BACKENDS";
    public static final String SHOW_COMPUTE_NODES_SQL_PATTERN = "SHOW COMPUTE NODES";
    public static final String SHOW_STORAGE_VOLUME_SQL_PATTERN = "SHOW STORAGE VOLUMES";
    public static final String DESCRIBE_STORAGE_VOLUME_SQL_PATTERN = "DESCRIBE STORAGE VOLUME";
    public static final String QUEURY_TABLES_PROC_SQL_PATTERN = "show proc '/dbs/_statistics_'";
    public static final String ADMIN_SHOW_FRONTEND_CONFIG_SQL_PATTERN = "ADMIN SHOW FRONTEND CONFIG LIKE '%s'";
    public static final String SHOW_PROC_REPLICATIONS = "SHOW PROC '/replications'";
    public static final String SHOW_PROC_DB_SQL_PATTERN = "SHOW PROC '/dbs/'";
    public static final String SHOW_PROC_TXNS_RUNNING_PATTERN = "SHOW PROC '/transactions/%s/running'";
    public static final String SHOW_PROC_TXNS_FINISHED_PATTERN = "SHOW PROC '/transactions/%s/finished'";
    public static final String SHOW_PROC_TABLE_SQL_PATTERN = "SHOW PROC '/dbs/%s/'";
    public static final String SHOW_DATA_SQL_PATTERN = "SHOW DATA FROM `%s`.`%s`";
    public static final String SHOW_BUCKET_NUM_SQL_PATTERN = "SHOW PARTITIONS FROM `%s`.`%s` ORDER BY PartitionId ASC;";
    public static final String SHOW_COLUMNS_SQL_PATTERN = "SHOW COLUMNS FROM `%s`.`%s`";
    public static final String SHOW_PROC_PARTITION_SQL_PATTERN = "SHOW PROC '/dbs/%s/%s/partitions/'";
    public static final String SHOW_PROC_SCHEMA_SQL_PATTERN = "SHOW PROC '/dbs/%s/%s/index_schema/'";
    public static final String SHOW_PROC_INDEX_SQL_PATTERN = "SHOW PROC '/dbs/%s/%s/partitions/%s/'";
    public static final String SHOW_PROC_TABLET_SQL_PATTERN = "SHOW PROC '/dbs/%s/%s/partitions/%s/%s/'";
    public static final String DROP_DB_SQL_PATTERN = "DROP DATABASE IF EXISTS `%s`";
    public static final String CREATE_DB_SQL_PATTERN = "CREATE DATABASE IF NOT EXISTS `%s`";
    public static final String DROP_TABLE_SQL_PATTERN = "DROP TABLE IF EXISTS `%s`.`%s` FORCE";
    public static final String SHOW_CREATE_TABLE_SQL_PATTERN = "SHOW CREATE TABLE `%s`.`%s`";
    public static final String SHOW_INDEX_SQL_PATTERN = "SHOW INDEX FROM `%s`.`%s`";
    public static final String DROP_INDEX_SQL_PATTERN = "DROP INDEX %s ON `%s`.`%s`";
    public static final String SHOW_CREATE_MATERIALIZED_VIEW_SQL_PATTERN = "SHOW CREATE MATERIALIZED VIEW `%s`.`%s`";
    public static final String DROP_MATERIALIZED_VIEWS_SQL_PATTERN = "DROP MATERIALIZED VIEW IF EXISTS `%s`.`%s`";
    public static final String DROP_VIEWS_SQL_PATTERN = "DROP VIEW IF EXISTS `%s`.`%s`";
    public static final String ADD_INDEX_SQL_PATTERN = "ALTER TABLE `%s`.`%s` ADD %s";
    public static final String ADD_PARTITION_SQL_PATTERN = "ALTER TABLE `%s`.`%s` ADD PARTITION IF NOT EXISTS %s VALUES %s DISTRIBUTED BY %s BUCKETS %s";
    public static final String ADD_EXPR_PARTITION_SQL_PATTERN = "ALTER TABLE `%s`.`%s` ADD PARTITIONS START ('%s') END ('%s') EVERY (INTERVAL 1 %s) DISTRIBUTED BY %s BUCKETS %s";
    public static final String MODIFY_PARTITION_SQL_PATTERN = "ALTER TABLE `%s`.`%s` MODIFY PARTITION %s SET(\"replication_num\" = \"%s\")";
    public static final String ALTER_DYNAMIC_PARTITION_SQL_PATTERN = "ALTER TABLE `%s`.`%s` SET(\"dynamic_partition.enable\" = \"false\"); %s; ALTER TABLE `%s`.`%s` SET(\"dynamic_partition.enable\" = \"true\")";
    public static final String DROP_PARTITION_SQL_PATTERN = "ALTER TABLE `%s`.`%s` DROP PARTITION IF EXISTS %s FORCE";
    public static final String ALTER_TABLE_PROPERTY_SQL_PATTERN = "ALTER TABLE `%s`.`%s` SET (\"%s\" = \"%s\")";
    public static final String TRIGGER_EXPR_PARTITION_SQL_PATTERN = "EXPLAIN ANALYZE INSERT INTO `%s`.`%s` (%s) VALUES (%s)";
    public static final String SELECT_PARTITION_SAMPLE_SQL_PATTERN = "SELECT %s FROM `%s`.`%s` PARTITION(%s) LIMIT 1";
    public static final String GENERATED_PARTITION_COLUMN_KEYWORD = "_generated_partition_column_";
    public static final String ALTER_TABLE_COMPACTION_SQL_PATTERN = "ALTER TABLE %s BASE COMPACT";
    public static final List<String> IGNORED_DATABASES = new ArrayList<String>();
    public static final String STORAGE_VOLUME_PROPERTY_KEY = "storage_volume";
    public static final String SOURCE_STORAGE_VOLUME_NAME_PREFIX = "src_";
    public static final Pattern SERVICE_ID_IN_STORAGE_PATH_PATTERN = Pattern.compile("([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})(?=/(?:db)?\\d+)");
    public static final String GET_TABLE_TIME_META_SQL_PATTERN = "SELECT TABLE_SCHEMA, TABLE_NAME, UNIX_TIMESTAMP(CREATE_TIME) AS TBL_CREATE_TIME, UNIX_TIMESTAMP(UPDATE_TIME) AS TBL_UPDATE_TIME FROM information_schema.tables WHERE TABLE_SCHEMA = \"%s\" AND TABLE_NAME = \"%s\"";
    private static final long TB = 0x10000000000L;
    private static final long GB = 0x40000000L;
    private static final long MB = 0x100000L;
    private static final long KB = 1024L;
    public static final String PROP_STORAGE_MEDIUM = "storage_medium";
    public static final String DEFAULT_STORAGE_MEDIUM = "default.storage_medium";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JobProgress getJobProgress(ClusterInfo clusterInfo) {
        JobProgress jobProgress = new JobProgress();
        Frontend leader = clusterInfo.getLeaderFrontend();
        if (leader == null) {
            return jobProgress;
        }
        String url = "http://" + leader.getHost() + ":" + leader.getHttpPort() + "/api/replication?type=show";
        String username = clusterInfo.getUserName();
        String password = clusterInfo.getPassword();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(username, password));
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(5000).setConnectionRequestTimeout(5000).build();
        try (CloseableHttpClient httpClient = HttpClients.custom().setDefaultCredentialsProvider(credentialsProvider).setDefaultRequestConfig(requestConfig).build();){
            HttpGet request = new HttpGet(url);
            try (CloseableHttpResponse response = httpClient.execute(request);){
                String jsonResponse = EntityUtils.toString(response.getEntity());
                if (response.getStatusLine().getStatusCode() == 200) {
                    JobProgress jobProgress2 = new Gson().fromJson(jsonResponse, JobProgress.class);
                    return jobProgress2;
                }
                LOG.info("Cannot get replication progress from {} and retry it from SQL, HTTP status: {}, HTTP response: {}", (Object)url, (Object)response.getStatusLine().getStatusCode(), (Object)jsonResponse);
                jobProgress = Utils.getJobProgressFromSql(clusterInfo);
                return jobProgress;
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to request replication progress from {}", (Object)url, (Object)e);
        }
        return jobProgress;
    }

    public static JobProgress getJobProgressFromSql(ClusterInfo clusterInfo) {
        ArrayList replications = new ArrayList();
        Function<ResultSet, Void> replicationStmtFunc = rs -> {
            String errorMsg = "Failed to get replication state from target cluster.";
            try {
                while (rs.next()) {
                    String jobID = rs.getString("JobID").trim();
                    String databaseID = rs.getString("DatabaseID").trim();
                    String tableID = rs.getString("TableID").trim();
                    String txnID = rs.getString("TxnID").trim();
                    String createdTime = rs.getString("CreatedTime").trim();
                    String finishedTime = "-1";
                    if (rs.getString("FinishedTime") != null) {
                        finishedTime = rs.getString("FinishedTime").trim();
                    }
                    String state = rs.getString("State").trim();
                    String progress = rs.getString("Progress").trim();
                    String error = rs.getString("Error").trim();
                    replications.add(new ReplicationState(jobID, databaseID, tableID, txnID, createdTime, finishedTime, state, progress, error));
                }
            }
            catch (Exception e) {
                LOG.error(errorMsg, (Throwable)e);
            }
            return null;
        };
        Utils.execQuerySql(SHOW_PROC_REPLICATIONS, clusterInfo, replicationStmtFunc);
        ArrayList<String> abortedIds = new ArrayList<String>();
        ArrayList<String> committedIds = new ArrayList<String>();
        ArrayList<JobProgress.RunningJob> running = new ArrayList<JobProgress.RunningJob>();
        for (ReplicationState replication : replications) {
            if (replication.getState().equalsIgnoreCase("ABORTED")) {
                abortedIds.add(replication.getJobID());
                continue;
            }
            if (replication.getState().equalsIgnoreCase("COMMITTED")) {
                committedIds.add(replication.getJobID());
                continue;
            }
            String progress = replication.getProgress();
            int runningTaskNum = progress.contains("/") ? Integer.parseInt(progress.split("/")[0]) : 0;
            int totalTaskNum = progress.contains("/") ? Integer.parseInt(progress.split("/")[1]) : 0;
            running.add(new JobProgress.RunningJob(replication.getJobID(), Long.parseLong(replication.getTxnID()), replication.getState(), totalTaskNum - runningTaskNum, totalTaskNum));
        }
        return new JobProgress(abortedIds, committedIds, running);
    }

    public static void execQuerySql(String sql, String feHost, int feQueryPort, String user, String password, int connectTimeoutMs, int socketTimeoutMs, Function<ResultSet, Void> func) {
        String url = String.format("jdbc:mysql://%s:%d", feHost, feQueryPort);
        Properties properties = new Properties();
        properties.setProperty("user", user);
        properties.setProperty("password", password);
        properties.setProperty("connectTimeout", String.valueOf(connectTimeoutMs));
        properties.setProperty("socketTimeout", String.valueOf(socketTimeoutMs));
        try (Connection connection = DriverManager.getConnection(url, properties);
             Statement stmt = connection.createStatement();){
            LOG.debug("Executing query on {}:{} {}", (Object)feHost, (Object)feQueryPort, (Object)sql);
            boolean hasResultSet = stmt.execute(sql);
            if (!hasResultSet) {
                LOG.error("query has no resultSet: {} on {}", (Object)sql, (Object)feHost);
                return;
            }
            ResultSet rs = stmt.getResultSet();
            func.apply(rs);
        }
        catch (Exception e) {
            LOG.error("Failed to execute sql on {}:{} {} ", (Object)feHost, (Object)feQueryPort, (Object)sql, (Object)e);
        }
    }

    public static void execQuerySql(String sql, ClusterInfo clusterInfo, Function<ResultSet, Void> func) {
        String clusterType = clusterInfo.getClusterType().toString();
        try (Connection connection = clusterInfo.getConnection();
             Statement stmt = connection.createStatement();){
            LOG.debug("Executing query {} on the {} cluster.", (Object)sql, (Object)clusterType);
            boolean hasResultSet = stmt.execute(sql);
            if (!hasResultSet) {
                LOG.error("query has no resultSet: {} on the {} cluster.", (Object)sql, (Object)clusterType);
                return;
            }
            ResultSet rs = stmt.getResultSet();
            func.apply(rs);
        }
        catch (Exception e) {
            String errorMsg = String.format("Failed to execute %s on the %s cluster.", sql, clusterType);
            if (e.getMessage().contains("Unknown proc node path")) {
                LOG.info("{}, detail: {}.", (Object)errorMsg, (Object)e.getMessage());
            }
            LOG.error("{}, sql:{}, detail: {}", (Object)errorMsg, (Object)sql, (Object)e.getMessage());
        }
    }

    public static void execDDLJob(DDLJob ddlJob, ClusterInfo clusterInfo) {
        block50: {
            String clusterType = clusterInfo.getClusterType().toString();
            String sql = ddlJob.getDdlSql();
            String dbName = ddlJob.getDbName();
            try (Connection connection = clusterInfo.getConnection();){
                Throwable throwable;
                LOG.info("Executing DDL on the {} cluster: {}", (Object)clusterType, (Object)sql);
                if (!dbName.isEmpty()) {
                    throwable = null;
                    try (Statement useStmt = connection.createStatement();){
                        useStmt.execute("USE `" + dbName + "`");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                throwable = null;
                try (Statement stmt = connection.createStatement();){
                    String[] sqlList;
                    if (sql.startsWith("CREATE ")) {
                        try {
                            stmt.execute(sql);
                        }
                        catch (Exception e) {
                            String errorMsg = String.format("Failed to execute %s of %s on the %s cluster.", sql, dbName, clusterType);
                            if (e.getMessage().contains("No matching function with signature")) {
                                incompatibleDDL.add(sql);
                                LOG.info("Ignore the incompatible DDL job {}.", (Object)sql);
                                break block50;
                            }
                            LOG.error(errorMsg, (Object)sql, (Object)e);
                        }
                        break block50;
                    }
                    for (String s2 : sqlList = sql.split(";")) {
                        try {
                            stmt.execute(s2);
                        }
                        catch (Exception e) {
                            String errorMsg = String.format("Failed to execute %s of %s on the %s cluster.", s2, dbName, clusterType);
                            if (e.getMessage().contains("Please wait until the current operation completes") || e.getMessage().contains("Unknown table")) {
                                LOG.info("{}, error message: {}", (Object)errorMsg, (Object)e.getMessage());
                                continue;
                            }
                            if (e.getMessage().contains("Duplicate partition name")) {
                                LOG.debug("Ignore duplicated partition DDL job {}.", (Object)s2);
                                continue;
                            }
                            LOG.error(errorMsg, (Object)s2, (Object)e);
                        }
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Exception e) {
                if (e.getMessage().contains("already exists")) {
                    LOG.info("Failed to execute DDL {} of {} on the {} cluster due to 'already exists'.", (Object)sql, (Object)dbName, (Object)clusterType);
                }
                LOG.error("Failed to execute DDL {} of {} on the {} cluster.", (Object)sql, (Object)dbName, (Object)clusterType, (Object)e);
            }
        }
    }

    public static void execCompactionJob(String sql, ClusterInfo clusterInfo) {
        String clusterType = clusterInfo.getClusterType().toString();
        try (Connection connection = clusterInfo.getConnection();){
            LOG.info(String.format("Executing compaction job on the %s cluster: %s", clusterType, sql));
            try (Statement stmt = connection.createStatement();){
                stmt.execute(sql);
            }
        }
        catch (SQLException e) {
            String errorMsg = String.format("Failed to execute %s on the %s cluster.", sql, clusterType);
            LOG.error(errorMsg, (Object)sql, (Object)e);
        }
    }

    public static List<Boolean> sendReplicationJob(ReplicationJob job, ClusterInfo clusterInfo) {
        boolean result = false;
        boolean needRetry = false;
        boolean canIgnore = false;
        Frontend targetClusterFE = clusterInfo.getRandomFrontend();
        String feHost = targetClusterFE.getHost();
        int feRpcPort = targetClusterFE.getRpcPort();
        TNetworkAddress addr = new TNetworkAddress(feHost, feRpcPort);
        TTableReplicationRequest request = job.toThrift();
        LOG.debug("Sending replication job: {}", (Object)job);
        try {
            TTableReplicationResponse response = FrontendServiceProxy.call(addr, 10000, 3, client -> client.startTableReplication(request));
            if (response.status.getStatus_code() != TStatusCode.OK) {
                String errMsg = response.status.getError_msgs() != null ? String.join((CharSequence)",", response.status.getError_msgs()) : "Unknown reason";
                if (errMsg.contains("The replication jobs exceeds the replication_max_parallel_table_count")) {
                    if (++REPLICATION_TABLE_COUNT_LIMIT_LOG_COUNTER >= 30) {
                        LOG.info("Ignore the replication job {} to {}, table: {}.{}, detail message: {}", (Object)job.getJobToken(), (Object)addr, (Object)job.getDbName(), (Object)job.getTableName(), (Object)errMsg);
                        REPLICATION_TABLE_COUNT_LIMIT_LOG_COUNTER = 0;
                    }
                    needRetry = true;
                } else if (errMsg.contains("The replicating data size in all running replication jobs") && errMsg.contains("exceeds replication_max_parallel_data_size_mb")) {
                    if (++REPLICATION_DATA_SIZE_LIMIT_LOG_COUNTER >= 30) {
                        LOG.info("Ignore the replication job {} to {}, table: {}.{}, detail message: {}", (Object)job.getJobToken(), (Object)addr, (Object)job.getDbName(), (Object)job.getTableName(), (Object)errMsg);
                        REPLICATION_DATA_SIZE_LIMIT_LOG_COUNTER = 0;
                    }
                    needRetry = true;
                } else if (errMsg.contains("The replicating replica count in all running replication jobs") && errMsg.contains("exceeds replication_max_parallel_replica_count")) {
                    if (++REPLICATION_REPLICA_COUNT_LIMIT_LOG_COUNTER >= 30) {
                        LOG.info("Ignore the replication job {} to {}, table: {}.{}, detail message: {}", (Object)job.getJobToken(), (Object)addr, (Object)job.getDbName(), (Object)job.getTableName(), (Object)errMsg);
                        REPLICATION_REPLICA_COUNT_LIMIT_LOG_COUNTER = 0;
                    }
                    needRetry = true;
                } else if (errMsg.contains("is already running")) {
                    LOG.debug("Ignore the replication job {} to {}, table: {}.{}, detail message: {}", (Object)job.getJobToken(), (Object)addr, (Object)job.getDbName(), (Object)job.getTableName(), (Object)errMsg);
                    canIgnore = true;
                } else if (errMsg.contains("No data need to replicate")) {
                    LOG.info("Ignore the replication job {} to {}, table: {}.{}, detail message: {}", (Object)job.getJobToken(), (Object)addr, (Object)job.getDbName(), (Object)job.getTableName(), (Object)errMsg);
                    canIgnore = true;
                } else if (errMsg.contains("forward request to fe master failed")) {
                    LOG.warn("Failed to send the replication job {} to {}, table: {}.{}, detail message: {}", (Object)job.getJobToken(), (Object)addr, (Object)job.getDbName(), (Object)job.getTableName(), (Object)errMsg);
                    needRetry = true;
                } else {
                    LOG.warn("Failed to send the replication job {} to {}, table: {}.{}, detail message: {}", (Object)job.getJobToken(), (Object)addr, (Object)job.getDbName(), (Object)job.getTableName(), (Object)errMsg);
                }
            } else {
                LOG.info("Sent replication request, job token: {}, table: {}.{}", (Object)job.getJobToken(), (Object)job.getDbName(), (Object)job.getTableName());
                result = true;
            }
        }
        catch (Exception e) {
            if (e.getMessage().contains("Socket is closed by peer.")) {
                LOG.warn("Failed to send the replication job {} to {}, detail message: {}", (Object)job.getJobToken(), (Object)addr, (Object)e.getMessage());
                needRetry = true;
            }
            LOG.error("Failed to send the replication job {} to {}.", (Object)job.getJobToken(), (Object)addr, (Object)e);
        }
        return Arrays.asList(result, needRetry, canIgnore);
    }

    public static Set<String> setIntersection(Set<String> src, Set<String> target) {
        HashSet<String> result = new HashSet<String>(src);
        result.retainAll(target);
        return result;
    }

    public static Set<String> setDifference(Set<String> src, Set<String> target) {
        HashSet<String> result = new HashSet<String>(src);
        result.removeAll(target);
        return result;
    }

    public static String toJson(Object o) {
        Gson gson = new Gson();
        return gson.toJson(o);
    }

    public static TTableType toTTableType(String type) {
        switch (type) {
            case "MYSQL": {
                return TTableType.MYSQL_TABLE;
            }
            case "OLAP": 
            case "OLAP_EXTERNAL": 
            case "CLOUD_NATIVE": {
                return TTableType.OLAP_TABLE;
            }
            case "SCHEMA": {
                return TTableType.SCHEMA_TABLE;
            }
            case "BROKER": {
                return TTableType.BROKER_TABLE;
            }
            case "ELASTICSEARCH": {
                return TTableType.ES_TABLE;
            }
            case "HIVE": {
                return TTableType.HDFS_TABLE;
            }
            case "ICEBERG": {
                return TTableType.ICEBERG_TABLE;
            }
            case "HUDI": {
                return TTableType.HUDI_TABLE;
            }
            case "JDBC": {
                return TTableType.JDBC_TABLE;
            }
            case "VIEW": {
                return TTableType.VIEW;
            }
            case "MATERIALIZED_VIEW": 
            case "CLOUD_NATIVE_MATERIALIZED_VIEW": {
                return TTableType.MATERIALIZED_VIEW;
            }
            case "DELTALAKE": {
                return TTableType.DELTALAKE_TABLE;
            }
            case "FILE": {
                return TTableType.FILE_TABLE;
            }
            case "TABLE_FUNCTION": {
                return TTableType.TABLE_FUNCTION_TABLE;
            }
            case "PAIMON": {
                return TTableType.PAIMON_TABLE;
            }
        }
        return null;
    }

    public static long convertDataSizeToLong(String dataSize) {
        if (dataSize.contains("TB")) {
            return (long)(Double.parseDouble(dataSize.replace("TB", "")) * 1.099511627776E12);
        }
        if (dataSize.contains("GB")) {
            return (long)(Double.parseDouble(dataSize.replace("GB", "")) * 1.073741824E9);
        }
        if (dataSize.contains("MB")) {
            return (long)(Double.parseDouble(dataSize.replace("MB", "")) * 1048576.0);
        }
        if (dataSize.contains("KB")) {
            return (long)(Double.parseDouble(dataSize.replace("KB", "")) * 1024.0);
        }
        if (dataSize.contains("B")) {
            return (long)Double.parseDouble(dataSize.replace("B", ""));
        }
        return (long)Double.parseDouble(dataSize);
    }

    public static String convertDataSizeToString(long value) {
        String unit;
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        double doubleValue = value;
        if (value >= 0x10000000000L) {
            unit = "TB";
            doubleValue /= 1.099511627776E12;
        } else if (value >= 0x40000000L) {
            unit = "GB";
            doubleValue /= 1.073741824E9;
        } else if (value >= 0x100000L) {
            unit = "MB";
            doubleValue /= 1048576.0;
        } else if (value >= 1024L) {
            unit = "KB";
            doubleValue /= 1024.0;
        } else {
            unit = "B";
        }
        return decimalFormat.format(doubleValue) + " " + unit;
    }

    public static String assembleDynamicPartitionSql(String dbName, String tableName, String partitionDdlSql) {
        return String.format(ALTER_DYNAMIC_PARTITION_SQL_PATTERN, dbName, tableName, partitionDdlSql, dbName, tableName);
    }

    public static String assembleAddPartitionSql(String dbName, String tableName, boolean isDynamicPartitionTable, Table.PartitionType partitionType, String partitionName, String partitionValue, String distributionKey, int buckets) {
        String addPartitionSql;
        String distributeBy = Utils.assembleDistributeBy(distributionKey);
        if (partitionType == Table.PartitionType.LIST) {
            String listPartitionValue = partitionValue.replace('[', '(').replace(']', ')');
            addPartitionSql = String.format(ADD_PARTITION_SQL_PATTERN, dbName, tableName, partitionName, "IN " + listPartitionValue, distributeBy, buckets);
        } else {
            Pattern pattern = Pattern.compile("keys: \\[(.*?)\\]");
            Matcher matcher = pattern.matcher(partitionValue);
            String partitionStart = "";
            String partitionEnd = "";
            if (matcher.find()) {
                partitionStart = matcher.group(1);
            }
            if (matcher.find()) {
                partitionEnd = matcher.group(1);
            }
            String range = String.format("[(%s), (%s))", Utils.addQuotesToWords(partitionStart), Utils.addQuotesToWords(partitionEnd));
            addPartitionSql = String.format(ADD_PARTITION_SQL_PATTERN, dbName, tableName, partitionName, range, distributeBy, buckets);
        }
        if (isDynamicPartitionTable) {
            return Utils.assembleDynamicPartitionSql(dbName, tableName, addPartitionSql);
        }
        return addPartitionSql;
    }

    public static String addQuotesToWords(String input) {
        String[] words = input.split(",");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            result.append("'").append(words[i].trim()).append("'");
            if (i >= words.length - 1) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public static String assembleAddExprPartitionSql(String dbName, String tableName, String partitionValue, String distributionKey, int buckets, String intervalUnit) {
        Pattern pattern = Pattern.compile("types: \\[(?:DATETIME|DATE)\\]; keys: \\[((?:\\d{4}-\\d{2}-\\d{2}(?: \\d{2}:\\d{2}:\\d{2})?))\\];");
        Matcher matcher = pattern.matcher(partitionValue);
        String startDateTime = "";
        String endDateTime = "";
        if (matcher.find()) {
            startDateTime = matcher.group(1);
        }
        if (matcher.find()) {
            endDateTime = matcher.group(1);
        }
        String distributeBy = Utils.assembleDistributeBy(distributionKey);
        try {
            return String.format(ADD_EXPR_PARTITION_SQL_PATTERN, dbName, tableName, startDateTime, endDateTime, intervalUnit, distributeBy, buckets);
        }
        catch (Exception e) {
            LOG.error("Failed to assemble ADD Partition SQL for {} of {}.{}.", (Object)partitionValue, (Object)dbName, (Object)tableName, (Object)e);
            return null;
        }
    }

    public static String assembleDropPartitionSql(String dbName, String tableName, boolean isDynamicPartitionTable, String partitionName) {
        String dropPartitionSql = String.format(DROP_PARTITION_SQL_PATTERN, dbName, tableName, partitionName);
        if (isDynamicPartitionTable) {
            return Utils.assembleDynamicPartitionSql(dbName, tableName, dropPartitionSql);
        }
        return dropPartitionSql;
    }

    public static String assembleModifyPartitionSql(String dbName, String tableName, boolean isDynamicPartitionTable, String partitionName, int replicationNum) {
        String modifyPartitionSql = String.format(MODIFY_PARTITION_SQL_PATTERN, dbName, tableName, partitionName, replicationNum);
        if (isDynamicPartitionTable) {
            return Utils.assembleDynamicPartitionSql(dbName, tableName, modifyPartitionSql);
        }
        return modifyPartitionSql;
    }

    public static boolean isComplexExprPartition(String partitionKey) {
        return partitionKey != null && partitionKey.contains(GENERATED_PARTITION_COLUMN_KEYWORD);
    }

    public static boolean isTimeSlicePartitionFunc(Table.ExprPartitionFunc partitionFunc) {
        return partitionFunc == Table.ExprPartitionFunc.TIME_SLICE;
    }

    public static boolean needsTriggerPartitionCreation(Table.ExprPartitionFunc partitionFunc, String partitionKey) {
        return Utils.isTimeSlicePartitionFunc(partitionFunc) || Utils.isComplexExprPartition(partitionKey);
    }

    public static String buildSelectPartitionSampleSql(String dbName, String tableName, String partitionName, List<String> notNullColumns) {
        String columnList = notNullColumns.stream().map(col -> "`" + col + "`").collect(Collectors.joining(", "));
        return String.format(SELECT_PARTITION_SAMPLE_SQL_PATTERN, columnList, dbName, tableName, partitionName);
    }

    public static String buildExprPartitionTriggerSql(String dbName, String tableName, List<String> notNullColumns, List<String> sampleValues) {
        if (notNullColumns == null || sampleValues == null || notNullColumns.isEmpty() || notNullColumns.size() != sampleValues.size()) {
            LOG.error("Invalid parameters for building expr partition trigger SQL: notNullColumns={}, sampleValues={}", (Object)notNullColumns, (Object)sampleValues);
            return null;
        }
        String columnList = notNullColumns.stream().map(col -> "`" + col + "`").collect(Collectors.joining(", "));
        String valueList = String.join((CharSequence)", ", sampleValues);
        return String.format(TRIGGER_EXPR_PARTITION_SQL_PATTERN, dbName, tableName, columnList, valueList);
    }

    public static String assembleAlterPartitionSql(ClusterInfo clusterInfo, String dbName, String tableName, boolean isDynamicPartitionTable, Table.PartitionType partitionType, Table.ExprPartitionFunc partitionFunc, String partitionUnit, String partitionName, String partitionValue, String distributionKey, int buckets) {
        return Utils.assembleAlterPartitionSql(clusterInfo, dbName, tableName, isDynamicPartitionTable, partitionType, partitionFunc, partitionUnit, null, partitionName, partitionValue, distributionKey, buckets, null);
    }

    public static String assembleAlterPartitionSql(ClusterInfo clusterInfo, String dbName, String tableName, boolean isDynamicPartitionTable, Table.PartitionType partitionType, Table.ExprPartitionFunc partitionFunc, String partitionUnit, String partitionKey, String partitionName, String partitionValue, String distributionKey, int buckets, String externalAddPartitionSql) {
        String dropPartitionSql = Utils.assembleDropPartitionSql(dbName, tableName, isDynamicPartitionTable, partitionName);
        if (partitionType == Table.PartitionType.EXPR_RANGE || partitionType == Table.PartitionType.EXPR_RANGE_V2) {
            String addPartitionSql;
            if (Utils.needsTriggerPartitionCreation(partitionFunc, partitionKey) && externalAddPartitionSql != null) {
                addPartitionSql = externalAddPartitionSql;
            } else if (!Utils.needsTriggerPartitionCreation(partitionFunc, partitionKey)) {
                addPartitionSql = Utils.assembleAddExprPartitionSql(dbName, tableName, partitionValue, distributionKey, buckets, partitionUnit);
            } else {
                LOG.warn("Cannot alter trigger-based partition {} of {}.{} without sample data", (Object)partitionName, (Object)dbName, (Object)tableName);
                return dropPartitionSql;
            }
            if (addPartitionSql != null) {
                return dropPartitionSql + "; " + addPartitionSql;
            }
            return dropPartitionSql;
        }
        String addPartitionSql = Utils.assembleAddPartitionSql(dbName, tableName, isDynamicPartitionTable, partitionType, partitionName, partitionValue, distributionKey, buckets);
        return dropPartitionSql + "; " + addPartitionSql;
    }

    private static String assembleDistributeBy(String distributionKey) {
        String distributeBy = distributionKey.equals("`ALL KEY`") ? "RANDOM" : String.format("HASH(%s)", distributionKey);
        return distributeBy;
    }

    public static String formatCurrentTimeMillis(long currentTimeMillis) {
        return SIMPLE_DATE_FORMATTER.get().format(currentTimeMillis);
    }

    public static long formatDatetimeToLong(String datetime) {
        long result = -1L;
        try {
            Date date = SIMPLE_DATE_FORMATTER.get().parse(datetime);
            result = date.getTime() / 1000L;
        }
        catch (Exception e) {
            LOG.error("Invalid date format: datetime = {}, ", (Object)datetime, (Object)e);
        }
        return result;
    }

    public static String formatDoubleToPercent(double value) {
        return PERCENT_FORMATTER.get().format(value);
    }

    public static String convertMillisecondsToMinutesAndSeconds(long milliseconds) {
        long totalSeconds = milliseconds / 1000L;
        long minutes = totalSeconds / 60L;
        long seconds = totalSeconds % 60L;
        if (minutes == 0L && seconds == 0L) {
            ++seconds;
        }
        return String.format("%d minutes and %d seconds", minutes, seconds);
    }

    public static String makeBacktickDistributionKey(String distributionKey) {
        CharSequence[] splits = distributionKey.split(",");
        for (int i = 0; i < splits.length; ++i) {
            splits[i] = "`" + ((String)splits[i]).trim() + "`";
        }
        return String.join((CharSequence)",", splits);
    }

    public static String convertCreateTableStmt(String showCreateTableResult, String dbName, String tableName, String storageVolume, int replicationNum, int bucketNum, long schemaVersion, Boolean enablePersistentIndex, ClusterInfo.RunMode srcClusterRunMode, ClusterInfo.RunMode targetClusterRunMode, boolean useBuiltinStorageVolumeOnTarget) {
        boolean isPkTable = showCreateTableResult.contains("PRIMARY KEY");
        CharSequence[] splits = showCreateTableResult.split("\n");
        int engineIndex = -1;
        for (int i = 0; i < splits.length; ++i) {
            String split = splits[i];
            if (split.contains("AUTO_INCREMENT")) {
                LOG.warn("{}.{} includes AUTO_INCREMENT field, detail: {}.", (Object)dbName, (Object)tableName, (Object)split);
            }
            if (split.startsWith(") ENGINE=")) {
                engineIndex = i;
            }
            try {
                if (engineIndex == -1 && split.contains("COMMENT \"") && !split.startsWith("COMMENT \"")) {
                    int commentIndex = split.indexOf("COMMENT \"");
                    String beginComment = split.substring(commentIndex);
                    int lastDoubleQuoteIndex = commentIndex + beginComment.lastIndexOf(34);
                    String afterComment = split.substring(lastDoubleQuoteIndex + 1);
                    String columnComment = split.substring(commentIndex + 9, lastDoubleQuoteIndex);
                    int doubleQuoteIndex = columnComment.indexOf("\"");
                    if (doubleQuoteIndex != -1) {
                        splits[i] = split.substring(0, commentIndex + 8) + "'" + columnComment + "'" + afterComment;
                    }
                }
            }
            catch (Exception e) {
                LOG.debug("Failed to convert column comment {} of {}.{}.", (Object)split, (Object)dbName, (Object)tableName, (Object)e);
            }
            if (split.contains("DISTRIBUTED BY") && !split.contains("BUCKETS") && bucketNum > 0) {
                CharSequence distributeInfo = splits[i];
                splits[i] = distributeInfo = (String)distributeInfo + " BUCKETS " + bucketNum;
            }
            String targetStorageVolume = storageVolume;
            if (useBuiltinStorageVolumeOnTarget) {
                targetStorageVolume = "builtin_storage_volume";
            }
            if (srcClusterRunMode == ClusterInfo.RunMode.SHARED_DATA) {
                if (split.contains(STORAGE_VOLUME_PROPERTY_KEY) && !targetStorageVolume.isEmpty() && split.contains(STORAGE_VOLUME_PROPERTY_KEY)) {
                    splits[i] = split.replaceAll("\"storage_volume\"\\s*=\\s*\"[^\"]*\"", "\"storage_volume\" = \"" + targetStorageVolume + "\"");
                }
            } else if (split.startsWith("PROPERTIES (") && !targetStorageVolume.isEmpty()) {
                String storageVolumeProperty = "\n\"storage_volume\" = \"" + targetStorageVolume + "\",";
                int n = i;
                splits[n] = (String)splits[n] + storageVolumeProperty;
            }
            if (split.startsWith("PROPERTIES (") && schemaVersion > 0L) {
                String schemaVersionProperty = "\n\"schema_version\" = \"" + schemaVersion + "\",";
                int n = i;
                splits[n] = (String)splits[n] + schemaVersionProperty;
            }
            if (replicationNum != -1 && split.startsWith("\"replication_num\" = ")) {
                String replicationNumProp = split.replaceFirst("\\d+", String.valueOf(replicationNum));
                splits[i] = replicationNumProp;
            }
            if (isPkTable && enablePersistentIndex != null && split.startsWith("\"enable_persistent_index\" = ")) {
                String persistentIndexProp = "\"enable_persistent_index\" = \"" + enablePersistentIndex + "\",";
                splits[i] = persistentIndexProp;
                LOG.debug("Enable persistent index for target table: {}.{}", (Object)dbName, (Object)tableName);
            }
            if (!isPkTable || srcClusterRunMode != ClusterInfo.RunMode.SHARED_DATA || targetClusterRunMode != ClusterInfo.RunMode.SHARED_DATA || !split.contains("\"persistent_index_type\"")) continue;
            boolean hasPersistentIndexEnabled = showCreateTableResult.contains("\"enable_persistent_index\" = \"true\"");
            boolean hasLocalPersistentIndexType = split.contains("\"persistent_index_type\" = \"LOCAL\"");
            if (!hasPersistentIndexEnabled || !hasLocalPersistentIndexType) continue;
            splits[i] = split.replace("\"persistent_index_type\" = \"LOCAL\"", "\"persistent_index_type\" = \"CLOUD_NATIVE\"");
            LOG.info("Changed persistent_index_type from LOCAL to CLOUD_NATIVE for target table: {}.{}", (Object)dbName, (Object)tableName);
        }
        return String.join((CharSequence)"\n", splits);
    }

    public static boolean canEnableCompactionInSharedData(Version version) {
        return version.compareTo(new Version(3, 3, 10)) >= 0 && version.compareTo(new Version(3, 4, 0)) != 0;
    }

    public static String extractServiceIdFrom(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        Matcher matcher = SERVICE_ID_IN_STORAGE_PATH_PATTERN.matcher(path);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    static {
        IGNORED_DATABASES.add("sys");
        IGNORED_DATABASES.add("information_schema");
        IGNORED_DATABASES.add("_statistics_");
        IGNORED_DATABASES.add("starrocks_audit_db__");
        IGNORED_DATABASES.add("_starrocks_audit_db_");
    }
}

