/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.common;

import com.starrocks.thrift.TNetworkAddress;
import java.lang.reflect.Constructor;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class GenericPool<VALUE extends TServiceClient> {
    private static final Logger LOG = LogManager.getLogger(GenericPool.class);
    private GenericKeyedObjectPool<TNetworkAddress, VALUE> pool;
    private String className;
    private int timeoutMs;

    public GenericPool(String className, GenericKeyedObjectPoolConfig config, int timeoutMs) {
        this.className = "com.starrocks.thrift." + className + "$Client";
        ThriftClientFactory factory = new ThriftClientFactory();
        this.pool = new GenericKeyedObjectPool(factory, config);
        this.timeoutMs = timeoutMs;
    }

    public boolean reopen(VALUE object, int timeoutMs) {
        boolean ok = true;
        ((TServiceClient)object).getOutputProtocol().getTransport().close();
        try {
            ((TServiceClient)object).getOutputProtocol().getTransport().open();
            TSocket socket = (TSocket)((TServiceClient)object).getOutputProtocol().getTransport();
            socket.setTimeout(timeoutMs);
        }
        catch (TTransportException e) {
            ok = false;
        }
        return ok;
    }

    public boolean reopen(VALUE object) {
        boolean ok = true;
        ((TServiceClient)object).getOutputProtocol().getTransport().close();
        try {
            ((TServiceClient)object).getOutputProtocol().getTransport().open();
        }
        catch (TTransportException e) {
            LOG.warn("reopen error", (Throwable)e);
            ok = false;
        }
        return ok;
    }

    public void clearPool(TNetworkAddress addr) {
        this.pool.clear(addr);
    }

    public boolean peak(VALUE object) {
        return ((TServiceClient)object).getOutputProtocol().getTransport().peek();
    }

    public VALUE borrowObject(TNetworkAddress address) throws Exception {
        return (VALUE)((TServiceClient)this.pool.borrowObject(address));
    }

    public VALUE borrowObject(TNetworkAddress address, int timeoutMs) throws Exception {
        TServiceClient value = (TServiceClient)this.pool.borrowObject(address);
        TSocket socket = (TSocket)value.getOutputProtocol().getTransport();
        socket.setTimeout(timeoutMs);
        return (VALUE)value;
    }

    public void returnObject(TNetworkAddress address, VALUE object) {
        if (address == null || object == null) {
            return;
        }
        this.pool.returnObject(address, object);
    }

    public void invalidateObject(TNetworkAddress address, VALUE object) {
        if (address == null || object == null) {
            return;
        }
        try {
            this.pool.invalidateObject(address, object);
        }
        catch (Exception e) {
            LOG.warn(e);
        }
    }

    private class ThriftClientFactory
    extends BaseKeyedPooledObjectFactory<TNetworkAddress, VALUE> {
        private ThriftClientFactory() {
        }

        private Object newInstance(String className, TProtocol protocol) throws Exception {
            Class<?> newoneClass = Class.forName(className);
            Constructor<?> cons = newoneClass.getConstructor(TProtocol.class);
            return cons.newInstance(protocol);
        }

        @Override
        public VALUE create(TNetworkAddress key) throws Exception {
            if (LOG.isDebugEnabled()) {
                LOG.debug("before create socket hostname={} key.port={} timeoutMs={}", (Object)key.hostname, (Object)key.port, (Object)GenericPool.this.timeoutMs);
            }
            TSocket transport = new TSocket(key.hostname, key.port, GenericPool.this.timeoutMs);
            ((TTransport)transport).open();
            TBinaryProtocol protocol = new TBinaryProtocol(transport);
            TServiceClient client = (TServiceClient)this.newInstance(GenericPool.this.className, protocol);
            return client;
        }

        @Override
        public PooledObject<VALUE> wrap(VALUE client) {
            return new DefaultPooledObject(client);
        }

        @Override
        public boolean validateObject(TNetworkAddress key, PooledObject<VALUE> p) {
            boolean isOpen = ((TServiceClient)p.getObject()).getOutputProtocol().getTransport().isOpen();
            LOG.debug("isOpen={}", (Object)isOpen);
            return isOpen;
        }

        @Override
        public void destroyObject(TNetworkAddress key, PooledObject<VALUE> p) {
            if (((TServiceClient)p.getObject()).getOutputProtocol().getTransport().isOpen()) {
                ((TServiceClient)p.getObject()).getOutputProtocol().getTransport().close();
            }
        }
    }
}

