package com.aliyun.lindorm.sql.demo;

import com.alibaba.druid.pool.DruidDataSource;

import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.UUID;

/**
 * @author jianhong.hjh
 * @date 2022/7/27 2:48 PM
 */
public class UpsertDemo {
  private static final Logger LOG = LoggerFactory.getLogger(UpsertDemo.class);

  public static void main(String[] args) throws Exception {
    // Avatica 协议
    {
      String url = "jdbc:lindorm:table:url=http://ld-bp1q9j6ybl3************-proxy-lindorm-pub.lindorm.rds.aliyuncs.com:30060";
      String user = "root";
      String password = "root";
      String database = "default";

      DataSource dataSource = getAvaticaDataSource(url, user, password, database);
      String tableName = "t_condition_message";
      log("---------------- avatica begin ---------");
      upsertTest(dataSource, tableName);
      log("---------------- avatica end ---------");
    }

    // MySQL 协议
    {
      String database = "default";
      String url = "jdbc:mysql://ld-bp1q9j6ybl3komwmh***********-proxy-sql-lindorm-public.lindorm.rds.aliyuncs.com:33060/" + database + "?useServerPrepStmts=true";
      String user = "root";
      String password = "root";

      DataSource dataSource = getMySQLDataSource(url, user, password);
      String tableName = "t_condition_message";
      log("---------------- mysql begin ---------");
      upsertTest(dataSource, tableName);
      log("---------------- mysql end ---------");
    }
  }

  private static void log(String msg) {
    // TODO 调整日志的输出目标
    System.out.println(msg);
    LOG.info(msg);
  }

  private static void upsertTest(DataSource dataSource, String tableName) throws SQLException {
    createTable(dataSource, tableName);
    writeByStatement(dataSource, tableName);
    writeByPreparedStatement(dataSource, tableName);
  }

  private static void createTable(DataSource dataSource, String tableName) throws SQLException {
    // 创建表
    try (Connection connection = dataSource.getConnection()) {
      try (Statement statement = connection.createStatement()) {
        String sql = "create table if not exists " + tableName + "("
            + "imsi varchar, vin varchar, reportTime bigint, source varchar,"
            + "transactionId varchar, conditionMsg varchar, canVersion varchar,"
            + "detail varchar, createTime bigint, createUser varchar, primary key(imsi, vin, reportTime desc, source))";
        int ret = statement.executeUpdate(sql);
        log("Create table status: " + ret);
      }
    }
  }

  private static void writeByStatement(DataSource dataSource, String tableName) throws SQLException {
    // TODO 将params可以换成实际的数据
    Object[] params = {
        UUID.randomUUID().toString(),
        UUID.randomUUID().toString(),
        System.currentTimeMillis(),
        "test",
        UUID.randomUUID().toString(),
        "test",
        "test",
        "test",
        System.currentTimeMillis(),
        "test"
    };

    StringBuilder builder = new StringBuilder();
    builder.append("upsert into ")
        .append(tableName)
        .append("(imsi, vin, reportTime, source, transactionId, conditionMsg, canVersion, detail, createTime, createUser) values(")
        .append("'").append(params[0]).append("'").append(",")
        .append("'").append(params[1]).append("'").append(",")
        .append(params[2]).append(",")
        .append("'").append(params[3]).append("'").append(",")
        .append("'").append(params[4]).append("'").append(",")
        .append("'").append(params[5]).append("'").append(",")
        .append("'").append(params[6]).append("'").append(",")
        .append("'").append(params[7]).append("'").append(",")
        .append(params[8]).append(",")
        .append("'").append(params[9]).append("'")
        .append(")");
    String sql = builder.toString();
    log(sql);
    long getConnElapsed, getStatementElapsed, executeElapsed;
    int ret;
    long t1 = System.currentTimeMillis();
    try (Connection connection = dataSource.getConnection()) {
      long t2 = System.currentTimeMillis();
      getConnElapsed = t2 - t1;
      try (Statement stmt = connection.createStatement()) {
        long t3 = System.currentTimeMillis();
        getStatementElapsed = t3 - t2;
        ret = stmt.executeUpdate(sql);
        long t4 = System.currentTimeMillis();
        executeElapsed = t4 - t3;
      }
    }
    long t5 = System.currentTimeMillis();
    long totalElapsed = t5 - t1;
    String logMsg = "statement write details: getConnElapsed: " + getConnElapsed + "ms, getStatementElapsed: " + getStatementElapsed + "ms,"
        + " executeElapsed: " + executeElapsed + "ms, totalElapsed: " + totalElapsed + "ms, ret: " + ret;
    log(logMsg);
  }

  private static void writeByPreparedStatement(DataSource dataSource, String tableName) throws SQLException {
    // TODO 将params可以换成实际的数据
    Object[] params = {
        UUID.randomUUID().toString(),
        UUID.randomUUID().toString(),
        System.currentTimeMillis(),
        "test",
        UUID.randomUUID().toString(),
        "test",
        "test",
        "test",
        System.currentTimeMillis(),
        "test"
    };
    long getConnElapsed, getStatementElapsed, executeElapsed;
    int ret;
    long t1 = System.currentTimeMillis();
    try (Connection connection = dataSource.getConnection()) {
      long t2 = System.currentTimeMillis();
      getConnElapsed = t2 - t1;
      String sql = "upsert into "
          + tableName
          + "(imsi, vin, reportTime, source, transactionId, conditionMsg, canVersion,"
          + "detail, createTime, createUser) values(?,?,?,?,?,?,?,?,?,?)";
      try (PreparedStatement ps = connection.prepareStatement(sql)) {
        long t3 = System.currentTimeMillis();
        getStatementElapsed = t3 - t2;
        ps.setString(1, (String) params[0]);
        ps.setString(2, (String) params[1]);
        ps.setLong(3, (Long) params[2]);
        ps.setString(4, (String) params[3]);
        ps.setString(5, (String) params[4]);
        ps.setString(6, (String) params[5]);
        ps.setString(7, (String) params[6]);
        ps.setString(8, (String) params[7]);
        ps.setLong(9, (Long) params[8]);
        ps.setString(10, (String) params[9]);
        ret = ps.executeUpdate();
        long t4 = System.currentTimeMillis();
        executeElapsed = t4 - t3;
      }
    }
    long t5 = System.currentTimeMillis();
    long totalElapsed = t5 - t1;
    String logMsg = "prepared statement write details: getConnElapsed: " + getConnElapsed + "ms, getStatementElapsed: " + getStatementElapsed + "ms,"
        + " executeElapsed: " + executeElapsed + "ms, totalElapsed: " + totalElapsed + "ms, ret: " + ret;
    log(logMsg);
  }

  public static DataSource getAvaticaDataSource(String url, String username, String password, String database) throws Exception {
    Properties properties = new Properties();
    properties.setProperty("database", database);
    DruidDataSource dataSource = new DruidDataSource();
    dataSource.setUrl(url);
    dataSource.setDriverClassName("com.aliyun.lindorm.table.client.Driver");
    dataSource.setUsername(username);
    dataSource.setPassword(password);
    dataSource.setConnectProperties(properties);
    dataSource.init();
    return dataSource;
  }

  public static DataSource getMySQLDataSource(String url, String username, String password) throws Exception {
    DruidDataSource dataSource = new DruidDataSource();
    dataSource.setUrl(url);
    dataSource.setDriverClassName("com.mysql.jdbc.Driver");
    dataSource.setUsername(username);
    dataSource.setPassword(password);
    dataSource.init();
    return dataSource;
  }
}
