/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.analyticdb.adb4pgclient.hash.util;

import com.alibaba.cloud.analyticdb.adb4pgclient.hash.util.UInt;

public class UInt32
extends UInt<UInt32> {
    static final long LONG = 0xFFFFFFFFL;

    public UInt32(int value) {
        super(value);
    }

    public UInt32(byte value) {
        super(value & 0xFF);
    }

    @Override
    public UInt32 divide(UInt32 other) {
        long div = ((long)this.uintVal & 0xFFFFFFFFL) / ((long)other.uintVal & 0xFFFFFFFFL);
        int result = (int)div;
        return new UInt32(result);
    }

    @Override
    public UInt32 mod(UInt32 other) {
        long mod = ((long)this.uintVal & 0xFFFFFFFFL) % ((long)other.uintVal & 0xFFFFFFFFL);
        int result = (int)mod;
        return new UInt32(result);
    }

    @Override
    public UInt32 multiply(UInt32 other) {
        long multi = ((long)this.uintVal & 0xFFFFFFFFL) * ((long)other.uintVal & 0xFFFFFFFFL);
        int result = (int)multi;
        return new UInt32(result);
    }

    @Override
    public UInt32 pow(int exp) {
        long pow = 0L;
        for (int i = 0; i < exp; ++i) {
            pow = ((long)this.uintVal & 0xFFFFFFFFL) * ((long)this.uintVal & 0xFFFFFFFFL);
        }
        int result = (int)pow;
        return new UInt32(result);
    }

    @Override
    public UInt32 not() {
        int result = ~this.uintVal;
        return new UInt32(result);
    }

    @Override
    public UInt32 and(UInt32 other) {
        int result = this.uintVal & other.uintVal;
        return new UInt32(result);
    }

    @Override
    public UInt32 or(UInt32 other) {
        int result = this.uintVal | other.uintVal;
        return new UInt32(result);
    }

    @Override
    public UInt32 xor(UInt32 other) {
        int result = this.uintVal ^ other.uintVal;
        return new UInt32(result);
    }

    @Override
    public UInt32 add(UInt32 other) {
        long sum = ((long)this.uintVal & 0xFFFFFFFFL) + ((long)other.uintVal & 0xFFFFFFFFL);
        int out = (int)sum;
        return new UInt32(out);
    }

    @Override
    public UInt32 add(char other) {
        long sum = ((long)this.uintVal & 0xFFFFFFFFL) + ((long)other & 0xFFFFFFFFL);
        int out = (int)sum;
        return new UInt32(out);
    }

    @Override
    public UInt32 add(byte other) {
        long sum = ((long)this.uintVal & 0xFFFFFFFFL) + (long)(other & 0xFF);
        int out = (int)sum;
        return new UInt32(out);
    }

    @Override
    public UInt32 subtract(UInt32 other) {
        long sub = ((long)this.uintVal & 0xFFFFFFFFL) - ((long)other.uintVal & 0xFFFFFFFFL);
        int result = (int)sub;
        return new UInt32(result);
    }

    @Override
    public UInt32 shiftLeft(int places) {
        long lShift = 0L;
        lShift = 0 < places ? ((long)this.uintVal & 0xFFFFFFFFL) << places : ((long)this.uintVal & 0xFFFFFFFFL) >>> -places;
        int result = (int)lShift;
        return new UInt32(result);
    }

    @Override
    public UInt32 shiftRight(int places) {
        long rShift = 0L;
        rShift = 0 < places ? ((long)this.uintVal & 0xFFFFFFFFL) >>> places : ((long)this.uintVal & 0xFFFFFFFFL) << -places;
        int result = (int)rShift;
        return new UInt32(result);
    }

    @Override
    public int compareTo(UInt32 o) {
        if (o.uintVal == this.uintVal) {
            return 1;
        }
        return 0;
    }

    @Override
    public int intValue() {
        return this.uintVal;
    }

    @Override
    public long longValue() {
        return (long)this.uintVal & 0xFFFFFFFFL;
    }

    @Override
    public float floatValue() {
        return this.uintVal;
    }

    @Override
    public double doubleValue() {
        return this.uintVal;
    }
}

