/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.writer;

import com.alicloud.openservices.tablestore.core.CallbackImpledFuture;
import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.writer.WriterResult;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Group {
    private static Logger logger = LoggerFactory.getLogger(Group.class);
    private static AtomicLong idGenerator = new AtomicLong(0L);
    private final long groupId;
    private final int totalCount;
    private final AtomicInteger remainCounter;
    private final AtomicReferenceArray<WriterResult.RowChangeStatus> rowChangeStatusList;
    private final CallbackImpledFuture<RowChange, WriterResult> future = new CallbackImpledFuture();

    public Group(int totalCount) {
        this.totalCount = totalCount;
        this.remainCounter = new AtomicInteger(totalCount);
        this.rowChangeStatusList = new AtomicReferenceArray(totalCount);
        this.groupId = idGenerator.incrementAndGet();
    }

    public CallbackImpledFuture<RowChange, WriterResult> getFuture() {
        return this.future;
    }

    public void succeedOneRow(RowChange rowChange) {
        this.finishOneRow(true, rowChange, null);
    }

    public void failedOneRow(RowChange rowChange, Exception exception) {
        this.finishOneRow(false, rowChange, exception);
    }

    private void finishOneRow(boolean isSucceed, RowChange rowChange, Exception exception) {
        int counter = this.remainCounter.decrementAndGet();
        if (counter < 0) {
            IllegalStateException exp = new IllegalStateException(String.format("[%d] WriterResult shouldn't finish more rows than total count", this.groupId));
            logger.error("Group OnFinishOneRow Failed", (Throwable)exp);
            throw exp;
        }
        WriterResult.RowChangeStatus status = new WriterResult.RowChangeStatus(isSucceed, rowChange, exception);
        this.rowChangeStatusList.set(this.totalCount - counter - 1, status);
        if (counter == 0) {
            this.completeGroup();
        }
    }

    private void completeGroup() {
        WriterResult writerResult = new WriterResult(this.totalCount, this.rowChangeStatusList);
        this.future.onCompleted(null, writerResult);
    }

    public long getGroupId() {
        return this.groupId;
    }
}

