/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timeserieswriter.manager;

import com.alicloud.openservices.tablestore.AsyncTimeseriesClientInterface;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.model.timeseries.PutTimeseriesDataRequest;
import com.alicloud.openservices.tablestore.model.timeseries.TimeseriesTableRow;
import com.alicloud.openservices.tablestore.timeserieswriter.TimeseriesWriterException;
import com.alicloud.openservices.tablestore.timeserieswriter.callback.TimeseriesRowResult;
import com.alicloud.openservices.tablestore.timeserieswriter.config.TimeseriesBucketConfig;
import com.alicloud.openservices.tablestore.timeserieswriter.config.TimeseriesWriterConfig;
import com.alicloud.openservices.tablestore.timeserieswriter.group.TimeseriesGroup;
import com.alicloud.openservices.tablestore.timeserieswriter.group.TimeseriesRequestWithGroups;
import com.alicloud.openservices.tablestore.timeserieswriter.group.TimeseriesRowWithGroup;
import com.alicloud.openservices.tablestore.timeserieswriter.handle.TimeseriesWriterHandleStatistics;
import com.alicloud.openservices.tablestore.timeserieswriter.manager.TimeseriesBaseRequestManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeseriesBatchRequestManager
extends TimeseriesBaseRequestManager {
    private static Logger logger = LoggerFactory.getLogger(TimeseriesBatchRequestManager.class);

    public TimeseriesBatchRequestManager(AsyncTimeseriesClientInterface ots, TimeseriesWriterConfig timeseriesWriterConfig, TimeseriesBucketConfig timeseriesBucketConfig, Executor executor, TimeseriesWriterHandleStatistics timeseriesWriterHandleStatistics, TableStoreCallback<TimeseriesTableRow, TimeseriesRowResult> callback, Semaphore callbackSemaphore, Semaphore bucketSemaphore) {
        super(ots, timeseriesWriterConfig, timeseriesBucketConfig, executor, timeseriesWriterHandleStatistics, callback, callbackSemaphore, bucketSemaphore);
    }

    @Override
    public TimeseriesRequestWithGroups makeRequest(String tableName) {
        if (this.timeseriesRowWithGroups.size() > 0) {
            PutTimeseriesDataRequest request = new PutTimeseriesDataRequest(tableName);
            ArrayList<TimeseriesGroup> groupFutureList = new ArrayList<TimeseriesGroup>(this.timeseriesRowWithGroups.size());
            for (TimeseriesRowWithGroup timeseriesRowWithGroup : this.timeseriesRowWithGroups) {
                request.addRow(timeseriesRowWithGroup.timeseriesTableRow.getTimeseriesRow());
                groupFutureList.add(timeseriesRowWithGroup.timeseriesGroup);
            }
            this.clear();
            return new TimeseriesRequestWithGroups(request, groupFutureList);
        }
        return null;
    }

    @Override
    public void sendRequest(TimeseriesRequestWithGroups timeseriesRequestWithGroups) {
        PutTimeseriesDataRequest finalRequest = (PutTimeseriesDataRequest)timeseriesRequestWithGroups.getRequest();
        List<TimeseriesGroup> finalGroupFuture = timeseriesRequestWithGroups.getGroupList();
        TableStoreCallback tableStoreCallback = this.callbackFactory.newInstance(finalGroupFuture);
        try {
            this.ots.putTimeseriesData(finalRequest, tableStoreCallback);
        }
        catch (Exception e) {
            logger.error("Failed while send request:", (Throwable)e);
            tableStoreCallback.onFailed(finalRequest, new TimeseriesWriterException(e.getMessage(), e, "SendRequestError"));
        }
    }
}

