/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timeline.model;

import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DynamicRow<T> {
    private Map<String, Column> fields = new HashMap<String, Column>();

    public Map<String, Column> getFields() {
        return Collections.unmodifiableMap(this.fields);
    }

    public T setField(String name, String value) {
        this.fields.put(name, new Column(name, ColumnValue.fromString(value)));
        return (T)this;
    }

    public T setField(String name, boolean value) {
        this.fields.put(name, new Column(name, ColumnValue.fromBoolean(value)));
        return (T)this;
    }

    public T setField(String name, double value) {
        this.fields.put(name, new Column(name, ColumnValue.fromDouble(value)));
        return (T)this;
    }

    public T setField(String name, long value) {
        this.fields.put(name, new Column(name, ColumnValue.fromLong(value)));
        return (T)this;
    }

    public T setField(String name, List<String> value) {
        Gson gson = new Gson();
        this.fields.put(name, new Column(name, ColumnValue.fromString(gson.toJson(value))));
        return (T)this;
    }

    public T setFields(List<Column> columns) {
        for (Column column : columns) {
            this.fields.put(column.getName(), column);
        }
        return (T)this;
    }

    public T setField(String name, String[] value) {
        Gson gson = new Gson();
        this.fields.put(name, new Column(name, ColumnValue.fromString(gson.toJson((Object)value))));
        return (T)this;
    }

    public T setField(Column column) {
        this.fields.put(column.getName(), column);
        return (T)this;
    }

    public boolean contains(String name) {
        return this.fields.containsKey(name);
    }

    public String getString(String name) {
        return this.fields.get(name).getValue().asString();
    }

    public long getLong(String name) {
        return this.fields.get(name).getValue().asLong();
    }

    public boolean getBoolean(String name) {
        return this.fields.get(name).getValue().asBoolean();
    }

    public double getDouble(String name) {
        return this.fields.get(name).getValue().asDouble();
    }

    public List<String> getStringList(String name) {
        String jsonArray = this.fields.get(name).getValue().asString();
        Gson gson = new Gson();
        try {
            String[] strArray = (String[])gson.fromJson(jsonArray, String[].class);
            return Arrays.asList(strArray);
        }
        catch (JsonSyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<Map.Entry<String, Column>> list = new ArrayList<Map.Entry<String, Column>>(this.fields.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Column>>(){

            @Override
            public int compare(Map.Entry<String, Column> o1, Map.Entry<String, Column> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        for (Map.Entry entry : list) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(((Column)entry.getValue()).getName() + ":" + ((Column)entry.getValue()).getValue());
        }
        return sb.toString();
    }
}

