/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.protocol.PlainBufferCrc8;
import com.alicloud.openservices.tablestore.core.utils.Bytes;
import com.alicloud.openservices.tablestore.core.utils.CalculateHelper;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.Measurable;
import com.alicloud.openservices.tablestore.model.PrimaryKeyType;
import java.io.IOException;
import java.util.Arrays;

public class PrimaryKeyValue
implements Comparable<PrimaryKeyValue>,
Measurable {
    public static final PrimaryKeyValue INF_MAX = new PrimaryKeyValue("INF_MAX", null);
    public static final PrimaryKeyValue INF_MIN = new PrimaryKeyValue("INF_MIN", null);
    @Deprecated
    public static final PrimaryKeyValue AUTO_INCRMENT = new PrimaryKeyValue("AUTO_INCREMENT", null);
    public static final PrimaryKeyValue AUTO_INCREMENT = new PrimaryKeyValue("AUTO_INCREMENT", null);
    private Object value;
    private byte[] rawData;
    private PrimaryKeyType type;
    private int dataSize = 0;

    private PrimaryKeyValue(Object value, PrimaryKeyType type) {
        this.value = value;
        this.type = type;
        if (this.type != null) {
            switch (this.type) {
                case INTEGER: {
                    this.dataSize = 8;
                    break;
                }
                case STRING: {
                    this.dataSize = CalculateHelper.calcStringSizeInBytes(this.asString());
                    break;
                }
                case BINARY: {
                    this.dataSize = this.asBinary().length;
                    break;
                }
                default: {
                    throw new IllegalStateException("Bug: not support the type : " + (Object)((Object)type));
                }
            }
        }
    }

    public PrimaryKeyType getType() {
        return this.type;
    }

    @Deprecated
    public int getSize() {
        return this.getDataSize();
    }

    @Override
    public int getDataSize() {
        return this.dataSize;
    }

    public static PrimaryKeyValue fromString(String value) {
        Preconditions.checkNotNull(value, "The value of primary key should not be null.");
        return new PrimaryKeyValue(value, PrimaryKeyType.STRING);
    }

    public static PrimaryKeyValue fromString(String value, byte[] rawData) {
        Preconditions.checkNotNull(value, "The value of primary key should not be null.");
        Preconditions.checkNotNull(rawData, "The value of rawData should not be null.");
        PrimaryKeyValue primaryKeyValue = new PrimaryKeyValue(value, PrimaryKeyType.STRING);
        primaryKeyValue.rawData = rawData;
        return primaryKeyValue;
    }

    public static PrimaryKeyValue fromLong(long value) {
        return new PrimaryKeyValue(value, PrimaryKeyType.INTEGER);
    }

    public static PrimaryKeyValue fromBinary(byte[] value) {
        Preconditions.checkNotNull(value, "The value of primary key should not be null.");
        return new PrimaryKeyValue(value, PrimaryKeyType.BINARY);
    }

    public static PrimaryKeyValue fromColumn(ColumnValue value) {
        switch (value.getType()) {
            case STRING: {
                return PrimaryKeyValue.fromString(value.asString());
            }
            case INTEGER: {
                return PrimaryKeyValue.fromLong(value.asLong());
            }
            case BINARY: {
                return PrimaryKeyValue.fromBinary(value.asBinary());
            }
        }
        throw new IllegalArgumentException("Can not convert from column with not compatible type: " + (Object)((Object)value.getType()));
    }

    public byte getChecksum(byte crc) throws IOException {
        if (this.isInfMin()) {
            crc = PlainBufferCrc8.crc8(crc, (byte)9);
            return crc;
        }
        if (this.isInfMax()) {
            crc = PlainBufferCrc8.crc8(crc, (byte)10);
            return crc;
        }
        if (this.isPlaceHolderForAutoIncr()) {
            crc = PlainBufferCrc8.crc8(crc, (byte)11);
            return crc;
        }
        switch (this.getType()) {
            case STRING: {
                byte[] rawData = this.asStringInBytes();
                crc = PlainBufferCrc8.crc8(crc, (byte)3);
                crc = PlainBufferCrc8.crc8(crc, rawData.length);
                crc = PlainBufferCrc8.crc8(crc, rawData);
                break;
            }
            case INTEGER: {
                crc = PlainBufferCrc8.crc8(crc, (byte)0);
                crc = PlainBufferCrc8.crc8(crc, this.asLong());
                break;
            }
            case BINARY: {
                byte[] rawData = this.asBinary();
                crc = PlainBufferCrc8.crc8(crc, (byte)7);
                crc = PlainBufferCrc8.crc8(crc, rawData.length);
                crc = PlainBufferCrc8.crc8(crc, rawData);
                break;
            }
            default: {
                throw new IOException("Bug: unsupported column type: " + (Object)((Object)this.getType()));
            }
        }
        return crc;
    }

    public ColumnValue toColumnValue() throws IOException {
        ColumnValue value = null;
        if (this.isInfMin() || this.isInfMax() || this.isPlaceHolderForAutoIncr()) {
            throw new IOException("Can not convert INF_MIN or INF_MAX or AUTO_INCREMENT into column value.");
        }
        switch (this.getType()) {
            case INTEGER: {
                value = ColumnValue.fromLong(this.asLong());
                break;
            }
            case STRING: {
                value = ColumnValue.fromString(this.asString());
                break;
            }
            case BINARY: {
                value = ColumnValue.fromBinary(this.asBinary());
                break;
            }
            default: {
                throw new IOException("Unsupported primary key type: " + (Object)((Object)this.getType()));
            }
        }
        return value;
    }

    public String asString() {
        if (this.type != PrimaryKeyType.STRING) {
            throw new IllegalStateException("The type of primary key is not STRING.");
        }
        return (String)this.value;
    }

    public byte[] asStringInBytes() {
        if (this.rawData == null) {
            this.rawData = Bytes.toBytes(this.asString());
        }
        return this.rawData;
    }

    public long asLong() {
        if (this.type != PrimaryKeyType.INTEGER) {
            throw new IllegalStateException("The type of primary key is not INTEGER.");
        }
        return (Long)this.value;
    }

    public byte[] asBinary() {
        if (this.type != PrimaryKeyType.BINARY) {
            throw new IllegalStateException("The type of primary key is not BINARY");
        }
        return (byte[])this.value;
    }

    public boolean isInfMin() {
        return this.type == null && this.value.equals("INF_MIN");
    }

    public boolean isInfMax() {
        return this.type == null && this.value.equals("INF_MAX");
    }

    public boolean isPlaceHolderForAutoIncr() {
        return this.type == null && this.value.equals("AUTO_INCREMENT");
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PrimaryKeyValue)) {
            return false;
        }
        PrimaryKeyValue val = (PrimaryKeyValue)o;
        if (this.type == val.type) {
            if (this.type == PrimaryKeyType.BINARY) {
                return Bytes.equals((byte[])this.value, (byte[])val.value);
            }
            return this.value.equals(val.value);
        }
        return false;
    }

    public int hashCode() {
        if (this.type == PrimaryKeyType.BINARY) {
            return Arrays.hashCode(this.asBinary()) * 31 + this.type.hashCode();
        }
        return this.value.hashCode() * 31 + (this.type != null ? this.type.hashCode() : 0);
    }

    public String toString() {
        if (this.type == PrimaryKeyType.BINARY) {
            return Arrays.toString(this.asBinary());
        }
        return this.value.toString();
    }

    @Override
    public int compareTo(PrimaryKeyValue target) {
        if (this.type == null) {
            if (target.type == null && target.value.equals(this.value)) {
                return 0;
            }
            if (this.value.equals("INF_MIN")) {
                return -1;
            }
            if (this.value.equals("INF_MAX")) {
                return 1;
            }
            throw new IllegalArgumentException(this.value + " can't compare.");
        }
        if (target.type == null) {
            if (target.value.equals("INF_MIN")) {
                return 1;
            }
            return -1;
        }
        if (this.type != target.type) {
            throw new IllegalArgumentException("The type of primary key to compare must be the same.");
        }
        switch (this.type) {
            case STRING: {
                return ((String)this.value).compareTo(target.asString());
            }
            case INTEGER: {
                return ((Long)this.value).compareTo(target.asLong());
            }
            case BINARY: {
                byte[] b1 = (byte[])this.value;
                byte[] b2 = (byte[])target.value;
                return Bytes.compareByteArrayInLexOrder(b1, 0, b1.length, b2, 0, b2.length);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + (Object)((Object)this.type));
    }

    public static PrimaryKeyValue addOne(PrimaryKeyValue target) {
        if (target.getType() == null) {
            throw new IllegalArgumentException("cannot addOne for null type");
        }
        ColumnValue value = null;
        switch (target.getType()) {
            case INTEGER: {
                value = ColumnValue.fromLong(target.asLong());
                if (value.asLong() == Long.MAX_VALUE) {
                    return new PrimaryKeyValue("INF_MAX", null);
                }
                Long integerVal = value.asLong() + 1L;
                return new PrimaryKeyValue(integerVal, PrimaryKeyType.INTEGER);
            }
            case STRING: {
                value = ColumnValue.fromString(target.asString());
                String stringVal = value.asString() + "\u0000";
                return new PrimaryKeyValue(stringVal, PrimaryKeyType.STRING);
            }
            case BINARY: {
                value = ColumnValue.fromBinary(target.asBinary());
                byte[] binaryVal = new byte[value.getDataSize() + 1];
                System.arraycopy(value.asBinary(), 0, binaryVal, 0, value.getDataSize());
                binaryVal[value.getDataSize()] = 0;
                return new PrimaryKeyValue(binaryVal, PrimaryKeyType.BINARY);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + (Object)((Object)target.getType()));
    }
}

