/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.protocol.globaltable;

import com.alicloud.openservices.tablestore.core.protocol.globaltable.GlobalTable;
import com.alicloud.openservices.tablestore.model.BindGlobalTableRequest;
import com.alicloud.openservices.tablestore.model.CreateGlobalTableRequest;
import com.alicloud.openservices.tablestore.model.DescribeGlobalTableRequest;
import com.alicloud.openservices.tablestore.model.GlobalTableTypes;
import com.alicloud.openservices.tablestore.model.UnbindGlobalTableRequest;
import com.alicloud.openservices.tablestore.model.UpdateGlobalTableRequest;
import com.google.common.base.Strings;
import java.util.List;

public class GlobalTableProtocolBuilder {
    public static GlobalTable.CreateGlobalTableRequest buildCreateGlobalTableRequest(CreateGlobalTableRequest req) {
        GlobalTable.CreateGlobalTableRequest.Builder builder = GlobalTable.CreateGlobalTableRequest.newBuilder();
        GlobalTableTypes.BaseTable reqBaseTable = req.getBaseTable();
        if (reqBaseTable == null) {
            throw new IllegalArgumentException("Base table is null");
        }
        GlobalTable.BaseTable.Builder protoBase = GlobalTable.BaseTable.newBuilder();
        protoBase.setRegionId(reqBaseTable.getRegionId());
        protoBase.setInstanceName(reqBaseTable.getInstanceName());
        protoBase.setTableName(reqBaseTable.getTableName());
        builder.setBaseTable(protoBase);
        List<GlobalTableTypes.Placement> reqPlacements = req.getPlacements();
        if (reqPlacements != null) {
            for (GlobalTableTypes.Placement reqPlacement : reqPlacements) {
                GlobalTable.Placement.Builder protoPlacement = GlobalTable.Placement.newBuilder();
                protoPlacement.setRegionId(reqPlacement.getRegionId());
                protoPlacement.setInstanceName(reqPlacement.getInstanceName());
                protoPlacement.setWritable(reqPlacement.isWritable());
                builder.addPlacements(protoPlacement);
            }
        }
        builder.setSyncMode(req.getSyncMode().toProtocol());
        if (req.getServeMode() != null) {
            builder.setServeMode(req.getServeMode().toProtocol());
        }
        return builder.build();
    }

    public static GlobalTable.BindGlobalTableRequest buildBindGlobalTableRequest(BindGlobalTableRequest req) {
        GlobalTable.BindGlobalTableRequest.Builder builder = GlobalTable.BindGlobalTableRequest.newBuilder();
        builder.setGlobalTableId(req.getGlobalTableId());
        builder.setGlobalTableName(req.getGlobalTableName());
        List<GlobalTableTypes.Placement> reqPlacements = req.getPlacements();
        if (reqPlacements != null) {
            for (GlobalTableTypes.Placement reqPlacement : reqPlacements) {
                GlobalTable.Placement.Builder protoPlacement = GlobalTable.Placement.newBuilder();
                protoPlacement.setRegionId(reqPlacement.getRegionId());
                protoPlacement.setInstanceName(reqPlacement.getInstanceName());
                protoPlacement.setWritable(reqPlacement.isWritable());
                builder.addPlacements(protoPlacement);
            }
        }
        return builder.build();
    }

    public static GlobalTable.UnbindGlobalTableRequest buildUnbindGlobalTableRequest(UnbindGlobalTableRequest req) {
        GlobalTable.UnbindGlobalTableRequest.Builder builder = GlobalTable.UnbindGlobalTableRequest.newBuilder();
        builder.setGlobalTableId(req.getGlobalTableId());
        builder.setGlobalTableName(req.getGlobalTableName());
        List<GlobalTableTypes.Removal> reqRemovals = req.getRemovals();
        if (reqRemovals == null || reqRemovals.isEmpty()) {
            throw new IllegalArgumentException("Removals is null or empty");
        }
        for (GlobalTableTypes.Removal reqRemoval : reqRemovals) {
            GlobalTable.Removal.Builder protoRemoval = GlobalTable.Removal.newBuilder();
            protoRemoval.setRegionId(reqRemoval.getRegionId());
            protoRemoval.setInstanceName(reqRemoval.getInstanceName());
            builder.addRemovals(protoRemoval);
        }
        return builder.build();
    }

    public static GlobalTable.DescribeGlobalTableRequest buildDescribeGlobalTableRequest(DescribeGlobalTableRequest req) {
        GlobalTable.DescribeGlobalTableRequest.Builder builder = GlobalTable.DescribeGlobalTableRequest.newBuilder();
        if (!Strings.isNullOrEmpty((String)req.getGlobalTableId())) {
            builder.setGlobalTableId(req.getGlobalTableId());
        }
        if (Strings.isNullOrEmpty((String)req.getGlobalTableName())) {
            throw new IllegalArgumentException("GlobalTableName is null or empty");
        }
        builder.setGlobalTableName(req.getGlobalTableName());
        GlobalTableTypes.PhyTable sdkPhyTable = req.getPhyTable();
        if (sdkPhyTable != null) {
            GlobalTable.PhyTable.Builder protoPhyTable = GlobalTable.PhyTable.newBuilder();
            protoPhyTable.setRegionId(sdkPhyTable.getRegionId());
            protoPhyTable.setInstanceName(sdkPhyTable.getInstanceName());
            protoPhyTable.setTableName(sdkPhyTable.getTableName());
            protoPhyTable.setWritable(sdkPhyTable.isWritable());
            builder.setPhyTable(protoPhyTable);
        }
        builder.setReturnRpo(req.isReturnRpo());
        return builder.build();
    }

    public static GlobalTable.UpdateGlobalTableRequest buildUpdateGlobalTableRequest(UpdateGlobalTableRequest req) {
        GlobalTable.UpdateGlobalTableRequest.Builder builder = GlobalTable.UpdateGlobalTableRequest.newBuilder();
        if (Strings.isNullOrEmpty((String)req.getGlobalTableId())) {
            throw new IllegalArgumentException("GlobalTableId is null or empty");
        }
        builder.setGlobalTableId(req.getGlobalTableId());
        if (Strings.isNullOrEmpty((String)req.getGlobalTableName())) {
            throw new IllegalArgumentException("GlobalTableName is null or empty");
        }
        builder.setGlobalTableName(req.getGlobalTableName());
        GlobalTableTypes.UpdatePhyTable sdkPhyTable = req.getUpdatePhyTable();
        if (sdkPhyTable == null) {
            throw new IllegalArgumentException("PhyTable is null or empty");
        }
        GlobalTable.UpdatePhyTable.Builder protoPhyTable = GlobalTable.UpdatePhyTable.newBuilder();
        protoPhyTable.setRegionId(sdkPhyTable.getRegionId());
        protoPhyTable.setInstanceName(sdkPhyTable.getInstanceName());
        protoPhyTable.setTableName(sdkPhyTable.getTableName());
        if (sdkPhyTable.getWritable() != null) {
            protoPhyTable.setWritable(sdkPhyTable.getWritable());
        }
        if (sdkPhyTable.getPrimaryEligible() != null) {
            protoPhyTable.setPrimaryEligible(sdkPhyTable.getPrimaryEligible());
        }
        builder.setPhyTable(protoPhyTable);
        return builder.build();
    }
}

