/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.writer.handle;

import com.alicloud.openservices.tablestore.AsyncClientInterface;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.model.BatchWriteRowRequest;
import com.alicloud.openservices.tablestore.model.BatchWriteRowResponse;
import com.alicloud.openservices.tablestore.model.BulkImportRequest;
import com.alicloud.openservices.tablestore.model.BulkImportResponse;
import com.alicloud.openservices.tablestore.model.ConsumedCapacity;
import com.alicloud.openservices.tablestore.model.DeleteRowRequest;
import com.alicloud.openservices.tablestore.model.DeleteRowResponse;
import com.alicloud.openservices.tablestore.model.Error;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.PutRowResponse;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.model.RowDeleteChange;
import com.alicloud.openservices.tablestore.model.RowPutChange;
import com.alicloud.openservices.tablestore.model.RowUpdateChange;
import com.alicloud.openservices.tablestore.model.UpdateRowRequest;
import com.alicloud.openservices.tablestore.model.UpdateRowResponse;
import com.alicloud.openservices.tablestore.writer.Group;
import com.alicloud.openservices.tablestore.writer.RowWriteResult;
import com.alicloud.openservices.tablestore.writer.config.BucketConfig;
import com.alicloud.openservices.tablestore.writer.enums.WriteMode;
import com.alicloud.openservices.tablestore.writer.handle.WriterHandleStatistics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlushCallback<Req, Res>
implements TableStoreCallback<Req, Res> {
    private static Logger logger = LoggerFactory.getLogger(FlushCallback.class);
    private final AsyncClientInterface ots;
    private final AtomicInteger count;
    private final Semaphore semaphore;
    private final BucketConfig bucketConfig;
    private final TableStoreCallback<RowChange, RowWriteResult> callback;
    private final Executor executor;
    private final WriterHandleStatistics writerStatistics;
    private final Semaphore bucketSemaphore;
    private final List<Group> groupList;
    public static AtomicLong counter = new AtomicLong(0L);

    public FlushCallback(AsyncClientInterface ots, AtomicInteger count, Semaphore semaphore, TableStoreCallback<RowChange, RowWriteResult> callback, Executor executor, WriterHandleStatistics writerStatistics, BucketConfig bucketConfig, Semaphore bucketSemaphore, List<Group> groupList) {
        this.ots = ots;
        this.count = count;
        this.semaphore = semaphore;
        this.bucketConfig = bucketConfig;
        this.callback = callback;
        this.executor = executor;
        this.writerStatistics = writerStatistics;
        this.bucketSemaphore = bucketSemaphore;
        this.groupList = groupList;
    }

    private void triggerSucceedCallback(final RowChange rowChange, final ConsumedCapacity consumedCapacity, final Row row, Group group) {
        this.writerStatistics.totalSucceedRowsCount.incrementAndGet();
        group.succeedOneRow(rowChange);
        if (this.callback == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                FlushCallback.this.callback.onCompleted(rowChange, new RowWriteResult(consumedCapacity, row));
            }
        });
    }

    private void triggerFailedCallback(final RowChange rowChange, final Exception exp, Group group) {
        this.writerStatistics.totalFailedRowsCount.incrementAndGet();
        group.failedOneRow(rowChange, exp);
        logger.error("RowChange Failed: ", (Throwable)exp);
        if (this.callback == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                FlushCallback.this.callback.onFailed(rowChange, exp);
            }
        });
    }

    private void triggerFailedCallback(final List<RowChange> rowChanges, final Exception exp, List<Group> groupList) {
        this.writerStatistics.totalFailedRowsCount.addAndGet(rowChanges.size());
        for (int i = 0; i < rowChanges.size(); ++i) {
            RowChange rowChange = rowChanges.get(i);
            Group group = groupList.get(i);
            group.failedOneRow(rowChange, exp);
            logger.error("RowChange Failed: ", (Throwable)exp);
        }
        if (this.callback == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (RowChange rowChange : rowChanges) {
                    FlushCallback.this.callback.onFailed(rowChange, exp);
                }
            }
        });
    }

    private void requestComplete() {
        int remain = this.count.decrementAndGet();
        if (remain == 0) {
            logger.debug("BucketSemaphore Release: " + counter.incrementAndGet());
            this.semaphore.release();
            this.bucketSemaphore.release();
            logger.debug("Release semaphore.");
        }
    }

    @Override
    public void onCompleted(BatchWriteRowRequest originRequest, BatchWriteRowResponse result) {
        ArrayList<BatchWriteRowResponse.RowResult> succeed = new ArrayList<BatchWriteRowResponse.RowResult>();
        ArrayList<BatchWriteRowResponse.RowResult> failed = new ArrayList<BatchWriteRowResponse.RowResult>();
        result.getResult(succeed, failed);
        for (BatchWriteRowResponse.RowResult status : succeed) {
            Group group = this.groupList.get(status.getIndex());
            this.triggerSucceedCallback(originRequest.getRowChange(status.getTableName(), status.getIndex()), status.getConsumedCapacity(), status.getRow(), group);
        }
        for (BatchWriteRowResponse.RowResult status : failed) {
            Error error = status.getError();
            Group group = this.groupList.get(status.getIndex());
            this.triggerFailedCallback(originRequest.getRowChange(status.getTableName(), status.getIndex()), (Exception)new TableStoreException(error.getMessage(), null, error.getCode(), result.getRequestId(), 0), group);
        }
    }

    @Override
    public void onCompleted(BulkImportRequest originRequest, BulkImportResponse result) {
        ArrayList<BulkImportResponse.RowResult> succeed = new ArrayList<BulkImportResponse.RowResult>();
        ArrayList<BulkImportResponse.RowResult> failed = new ArrayList<BulkImportResponse.RowResult>();
        result.getResult(succeed, failed);
        for (BulkImportResponse.RowResult status : succeed) {
            Group group = this.groupList.get(status.getIndex());
            this.triggerSucceedCallback(originRequest.getRowChange(status.getIndex()), status.getConsumedCapacity(), null, group);
        }
        for (BulkImportResponse.RowResult status : failed) {
            Error error = status.getError();
            Group group = this.groupList.get(status.getIndex());
            this.triggerFailedCallback(originRequest.getRowChange(status.getIndex()), (Exception)new TableStoreException(error.getMessage(), null, error.getCode(), result.getRequestId(), 0), group);
        }
    }

    @Override
    public void onCompleted(Req request, Res response) {
        logger.debug("OnComplete: {}", (Object)request.getClass().getName());
        if (request instanceof BatchWriteRowRequest) {
            this.onCompleted((BatchWriteRowRequest)request, (BatchWriteRowResponse)response);
        } else if (request instanceof BulkImportRequest) {
            this.onCompleted((BulkImportRequest)request, (BulkImportResponse)response);
        } else if (request instanceof PutRowRequest) {
            PutRowRequest pr = (PutRowRequest)request;
            this.triggerSucceedCallback(pr.getRowChange(), ((PutRowResponse)response).getConsumedCapacity(), ((PutRowResponse)response).getRow(), this.groupList.get(0));
        } else if (request instanceof UpdateRowRequest) {
            UpdateRowRequest ur = (UpdateRowRequest)request;
            this.triggerSucceedCallback(ur.getRowChange(), ((UpdateRowResponse)response).getConsumedCapacity(), ((UpdateRowResponse)response).getRow(), this.groupList.get(0));
        } else if (request instanceof DeleteRowRequest) {
            DeleteRowRequest dr = (DeleteRowRequest)request;
            this.triggerSucceedCallback(dr.getRowChange(), ((DeleteRowResponse)response).getConsumedCapacity(), ((DeleteRowResponse)response).getRow(), this.groupList.get(0));
        }
        this.requestComplete();
    }

    @Override
    public void onFailed(Req request, Exception ex) {
        if (ex instanceof TableStoreException) {
            this.failedOnException(request, (TableStoreException)ex);
        } else {
            this.failedOnUnknownException(request, ex);
        }
        this.requestComplete();
    }

    public void failedOnException(Req request, TableStoreException ex) {
        logger.debug("OnFailed on TableStoreException: {}, {}", (Object)request.getClass().getName(), (Object)ex);
        if (request instanceof BatchWriteRowRequest) {
            this.retryBatchWrite((BatchWriteRowRequest)request);
        } else if (request instanceof BulkImportRequest) {
            this.retryBulkImport((BulkImportRequest)request);
        } else if (request instanceof PutRowRequest) {
            PutRowRequest pr = (PutRowRequest)request;
            this.triggerFailedCallback(pr.getRowChange(), (Exception)ex, this.groupList.get(0));
        } else if (request instanceof UpdateRowRequest) {
            UpdateRowRequest ur = (UpdateRowRequest)request;
            this.triggerFailedCallback(ur.getRowChange(), (Exception)ex, this.groupList.get(0));
        } else if (request instanceof DeleteRowRequest) {
            DeleteRowRequest dr = (DeleteRowRequest)request;
            this.triggerFailedCallback(dr.getRowChange(), (Exception)ex, this.groupList.get(0));
        }
    }

    public void failedOnUnknownException(Req request, Exception ex) {
        logger.debug("OnFailed on ClientException: {}, {}", (Object)request.getClass().getName(), (Object)ex);
        ArrayList<RowChange> failedRows = new ArrayList<RowChange>();
        if (request instanceof BatchWriteRowRequest) {
            BatchWriteRowRequest bwr = (BatchWriteRowRequest)request;
            for (Map.Entry<String, List<RowChange>> entry : bwr.getRowChange().entrySet()) {
                failedRows.addAll((Collection<RowChange>)entry.getValue());
            }
        } else if (request instanceof BulkImportRequest) {
            BulkImportRequest bir = (BulkImportRequest)request;
            failedRows.addAll(bir.getRowChange());
        } else if (request instanceof PutRowRequest) {
            PutRowRequest pr = (PutRowRequest)request;
            failedRows.add(pr.getRowChange());
        } else if (request instanceof UpdateRowRequest) {
            UpdateRowRequest ur = (UpdateRowRequest)request;
            failedRows.add(ur.getRowChange());
        } else if (request instanceof DeleteRowRequest) {
            DeleteRowRequest dr = (DeleteRowRequest)request;
            failedRows.add(dr.getRowChange());
        }
        this.triggerFailedCallback(failedRows, ex, this.groupList);
    }

    private void retryBatchWrite(BatchWriteRowRequest request) {
        for (Map.Entry<String, List<RowChange>> entry : request.getRowChange().entrySet()) {
            for (int i = 0; i < entry.getValue().size(); ++i) {
                Group group = this.groupList.get(i);
                this.retrySingleRowChange(entry.getValue().get(i), group);
            }
        }
    }

    private void retryBulkImport(BulkImportRequest request) {
        for (int i = 0; i < request.getRowChange().size(); ++i) {
            Group group = this.groupList.get(i);
            this.retrySingleRowChange(request.getRowChange(i), group);
        }
    }

    private void retrySingleRowChange(RowChange rowChange, Group group) {
        this.writerStatistics.totalSingleRowRequestCount.incrementAndGet();
        this.writerStatistics.totalRequestCount.incrementAndGet();
        if (WriteMode.SEQUENTIAL.equals((Object)this.bucketConfig.getWriteMode())) {
            this.retrySequentialWriteSingleRowChange(rowChange, group);
        } else {
            this.retryParallelWriteSingleRowChange(rowChange, group);
        }
    }

    private void retryParallelWriteSingleRowChange(RowChange rowChange, Group group) {
        ArrayList<Group> subGroupList = new ArrayList<Group>(1);
        subGroupList.add(group);
        this.count.incrementAndGet();
        if (rowChange instanceof RowPutChange) {
            RowPutChange rowPutChange = (RowPutChange)rowChange;
            PutRowRequest pr = new PutRowRequest();
            pr.setRowChange(rowPutChange);
            this.ots.putRow(pr, new FlushCallback<PutRowRequest, PutRowResponse>(this.ots, this.count, this.semaphore, this.callback, this.executor, this.writerStatistics, this.bucketConfig, this.bucketSemaphore, subGroupList));
        } else if (rowChange instanceof RowUpdateChange) {
            UpdateRowRequest ur = new UpdateRowRequest();
            RowUpdateChange rowUpdateChange = (RowUpdateChange)rowChange;
            ur.setRowChange(rowUpdateChange);
            this.ots.updateRow(ur, new FlushCallback<UpdateRowRequest, UpdateRowResponse>(this.ots, this.count, this.semaphore, this.callback, this.executor, this.writerStatistics, this.bucketConfig, this.bucketSemaphore, subGroupList));
        } else if (rowChange instanceof RowDeleteChange) {
            DeleteRowRequest dr = new DeleteRowRequest();
            RowDeleteChange rowDeleteChange = (RowDeleteChange)rowChange;
            dr.setRowChange(rowDeleteChange);
            this.ots.deleteRow(dr, new FlushCallback<DeleteRowRequest, DeleteRowResponse>(this.ots, this.count, this.semaphore, this.callback, this.executor, this.writerStatistics, this.bucketConfig, this.bucketSemaphore, subGroupList));
        }
    }

    private void retrySequentialWriteSingleRowChange(RowChange rowChange, Group group) {
        if (rowChange instanceof RowPutChange) {
            RowPutChange rowPutChange = (RowPutChange)rowChange;
            PutRowRequest pr = new PutRowRequest();
            pr.setRowChange(rowPutChange);
            try {
                PutRowResponse response = this.ots.asSyncClient().putRow(pr);
                this.triggerSucceedCallback(rowPutChange, response.getConsumedCapacity(), response.getRow(), group);
            }
            catch (Exception e) {
                this.triggerFailedCallback(rowPutChange, e, group);
            }
        } else if (rowChange instanceof RowUpdateChange) {
            UpdateRowRequest ur = new UpdateRowRequest();
            RowUpdateChange rowUpdateChange = (RowUpdateChange)rowChange;
            ur.setRowChange(rowUpdateChange);
            try {
                UpdateRowResponse response = this.ots.asSyncClient().updateRow(ur);
                this.triggerSucceedCallback(rowUpdateChange, response.getConsumedCapacity(), response.getRow(), group);
            }
            catch (Exception e) {
                this.triggerFailedCallback(rowUpdateChange, e, group);
            }
        } else if (rowChange instanceof RowDeleteChange) {
            DeleteRowRequest dr = new DeleteRowRequest();
            RowDeleteChange rowDeleteChange = (RowDeleteChange)rowChange;
            dr.setRowChange(rowDeleteChange);
            try {
                DeleteRowResponse response = this.ots.asSyncClient().deleteRow(dr);
                this.triggerSucceedCallback(rowDeleteChange, response.getConsumedCapacity(), response.getRow(), group);
            }
            catch (Exception e) {
                this.triggerFailedCallback(rowDeleteChange, e, group);
            }
        }
    }
}

