/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.writer.handle;

import com.alicloud.openservices.tablestore.AsyncClientInterface;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.model.BulkImportRequest;
import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.writer.Group;
import com.alicloud.openservices.tablestore.writer.RequestWithGroups;
import com.alicloud.openservices.tablestore.writer.RowChangeWithGroup;
import com.alicloud.openservices.tablestore.writer.RowWriteResult;
import com.alicloud.openservices.tablestore.writer.WriterConfig;
import com.alicloud.openservices.tablestore.writer.config.BucketConfig;
import com.alicloud.openservices.tablestore.writer.handle.BaseRequestManager;
import com.alicloud.openservices.tablestore.writer.handle.WriterHandleStatistics;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkImportRequestManager
extends BaseRequestManager {
    private static Logger logger = LoggerFactory.getLogger(BulkImportRequestManager.class);

    public BulkImportRequestManager(AsyncClientInterface ots, WriterConfig writerConfig, BucketConfig bucketConfig, Executor executor, WriterHandleStatistics writerStatistics, TableStoreCallback<RowChange, RowWriteResult> callback, Semaphore callbackSemaphore, Semaphore bucketSemaphore) {
        super(ots, writerConfig, bucketConfig, executor, writerStatistics, callback, callbackSemaphore, bucketSemaphore);
    }

    @Override
    public RequestWithGroups makeRequest() {
        if (this.rowChangeWithGroups.size() > 0) {
            BulkImportRequest request = new BulkImportRequest(this.bucketConfig.getTableName());
            ArrayList<Group> groupFutureList = new ArrayList<Group>(this.rowChangeWithGroups.size());
            for (RowChangeWithGroup rowChangeWithGroup : this.rowChangeWithGroups) {
                request.addRowChange(rowChangeWithGroup.rowChange);
                groupFutureList.add(rowChangeWithGroup.group);
            }
            this.clear();
            return new RequestWithGroups(request, groupFutureList);
        }
        return null;
    }

    @Override
    public void sendRequest(RequestWithGroups requestWithGroups) {
        BulkImportRequest finalRequest = (BulkImportRequest)requestWithGroups.getRequest();
        List<Group> finalGroupFuture = requestWithGroups.getGroupList();
        this.ots.bulkImport(finalRequest, this.callbackFactory.newInstance(finalGroupFuture));
    }
}

