/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.timeseries;

import com.alicloud.openservices.tablestore.core.utils.OptionalValue;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.timeseries.AnalyticalStoreSyncType;

public class TimeseriesAnalyticalStore {
    private final String analyticalStoreName;
    private OptionalValue<Integer> timeToLive = new OptionalValue("TimeToLive");
    private OptionalValue<AnalyticalStoreSyncType> syncOption = new OptionalValue("SyncOption");

    public TimeseriesAnalyticalStore(String analyticalStoreName) {
        Preconditions.checkArgument(analyticalStoreName != null && !analyticalStoreName.isEmpty(), "analyticalStoreName should not be null or empty.");
        this.analyticalStoreName = analyticalStoreName;
    }

    public String getAnalyticalStoreName() {
        return this.analyticalStoreName;
    }

    public int getTimeToLive() {
        if (!this.timeToLive.isValueSet()) {
            throw new IllegalStateException("The value of TimeToLive is not set.");
        }
        return this.timeToLive.getValue();
    }

    public AnalyticalStoreSyncType getSyncOption() {
        if (!this.syncOption.isValueSet()) {
            throw new IllegalStateException("The value of SyncOption is not set.");
        }
        return this.syncOption.getValue();
    }

    public boolean hasTimeToLive() {
        return this.timeToLive.isValueSet();
    }

    public boolean hasSyncOption() {
        return this.syncOption.isValueSet();
    }

    public void setTimeToLive(Integer timeToLive) {
        this.timeToLive.setValue(timeToLive);
    }

    public void setSyncOption(AnalyticalStoreSyncType syncOption) {
        this.syncOption.setValue(syncOption);
    }
}

