/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search;

import com.alicloud.openservices.tablestore.model.ExtensionRequest;
import com.alicloud.openservices.tablestore.model.search.ScanQuery;
import com.alicloud.openservices.tablestore.model.search.SearchRequest;
import com.google.gson.GsonBuilder;
import java.util.Arrays;
import java.util.List;

public class ParallelScanRequest
extends ExtensionRequest {
    private String tableName;
    private String indexName;
    private ScanQuery scanQuery;
    private SearchRequest.ColumnsToGet columnsToGet;
    private byte[] sessionId;
    private int timeoutInMillisecond = -1;

    public String getRequestInfo(boolean prettyFormat) {
        GsonBuilder builder = new GsonBuilder().disableHtmlEscaping().disableInnerClassSerialization().serializeNulls().serializeSpecialFloatingPointValues().enableComplexMapKeySerialization();
        if (prettyFormat) {
            return builder.setPrettyPrinting().create().toJson((Object)this);
        }
        return builder.create().toJson((Object)this);
    }

    public void printRequestInfo() {
        System.out.println(this.getRequestInfo(true));
    }

    public ParallelScanRequest() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getTableName() {
        return this.tableName;
    }

    public ParallelScanRequest setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public ParallelScanRequest setIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public ScanQuery getScanQuery() {
        return this.scanQuery;
    }

    public ParallelScanRequest setScanQuery(ScanQuery scanQuery) {
        this.scanQuery = scanQuery;
        return this;
    }

    public SearchRequest.ColumnsToGet getColumnsToGet() {
        return this.columnsToGet;
    }

    public ParallelScanRequest setColumnsToGet(SearchRequest.ColumnsToGet columnsToGet) {
        this.columnsToGet = columnsToGet;
        return this;
    }

    public byte[] getSessionId() {
        return this.sessionId;
    }

    public ParallelScanRequest setSessionId(byte[] sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public int getTimeoutInMillisecond() {
        return this.timeoutInMillisecond;
    }

    public ParallelScanRequest setTimeoutInMillisecond(int timeoutInMillisecond) {
        this.timeoutInMillisecond = timeoutInMillisecond;
        return this;
    }

    @Override
    public String getOperationName() {
        return "ParallelScan";
    }

    private ParallelScanRequest(Builder builder) {
        this.setTableName(builder.tableName);
        this.setIndexName(builder.indexName);
        this.setScanQuery(builder.scanQuery);
        this.setColumnsToGet(builder.columnsToGet);
        this.setSessionId(builder.sessionId);
        this.setTimeoutInMillisecond(builder.timeoutInMillisecond);
    }

    public static final class Builder {
        private String tableName;
        private String indexName;
        private ScanQuery scanQuery;
        private SearchRequest.ColumnsToGet columnsToGet;
        private byte[] sessionId;
        private int timeoutInMillisecond = -1;

        private Builder() {
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder scanQuery(ScanQuery scanQuery) {
            this.scanQuery = scanQuery;
            return this;
        }

        public Builder addColumnsToGet(List<String> columnsToGetList) {
            if (this.columnsToGet == null) {
                this.columnsToGet = new SearchRequest.ColumnsToGet();
            }
            this.columnsToGet.getColumns().addAll(columnsToGetList);
            return this;
        }

        public Builder addColumnsToGet(String ... columnsToGet) {
            if (this.columnsToGet == null) {
                this.columnsToGet = new SearchRequest.ColumnsToGet();
            }
            this.columnsToGet.getColumns().addAll(Arrays.asList(columnsToGet));
            return this;
        }

        public Builder returnAllColumnsFromIndex(boolean returnAllIndex) {
            if (this.columnsToGet == null) {
                this.columnsToGet = new SearchRequest.ColumnsToGet();
            }
            this.columnsToGet.setReturnAllFromIndex(returnAllIndex);
            return this;
        }

        public Builder sessionId(byte[] sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder timeout(int timeoutInMillisecond) {
            this.timeoutInMillisecond = timeoutInMillisecond;
            return this;
        }

        public ParallelScanRequest build() {
            return new ParallelScanRequest(this);
        }
    }
}

