/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.core.utils.StringUtils;
import com.alicloud.openservices.tablestore.model.DefinedColumnSchema;
import com.alicloud.openservices.tablestore.model.DefinedColumnType;
import com.alicloud.openservices.tablestore.model.PrimaryKeyOption;
import com.alicloud.openservices.tablestore.model.PrimaryKeySchema;
import com.alicloud.openservices.tablestore.model.PrimaryKeyType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;

public class TableMeta
implements Jsonizable {
    private String tableName;
    private List<PrimaryKeySchema> primaryKey = new ArrayList<PrimaryKeySchema>();
    private Map<String, PrimaryKeySchema> primaryKeySchemaMap;
    private List<DefinedColumnSchema> definedColumns = new ArrayList<DefinedColumnSchema>();
    private Map<String, DefinedColumnSchema> definedColumnsSchemaMap;
    private String tableId;
    private String globalTableId;

    public TableMeta(String tableName) {
        Preconditions.checkArgument(tableName != null && !tableName.isEmpty(), "The name of table should not be null or empty.");
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        Preconditions.checkArgument(tableName != null && !tableName.isEmpty(), "The name of table should not be null or empty.");
        this.tableName = tableName;
    }

    public Map<String, PrimaryKeyType> getPrimaryKeyMap() {
        LinkedHashMap<String, PrimaryKeyType> result = new LinkedHashMap<String, PrimaryKeyType>();
        for (PrimaryKeySchema key : this.primaryKey) {
            result.put(key.getName(), key.getType());
        }
        return result;
    }

    public Map<String, PrimaryKeySchema> getPrimaryKeySchemaMap() {
        if (this.primaryKeySchemaMap == null) {
            LinkedHashMap<String, PrimaryKeySchema> temp = new LinkedHashMap<String, PrimaryKeySchema>();
            for (PrimaryKeySchema key : this.primaryKey) {
                temp.put(key.getName(), key);
            }
            this.primaryKeySchemaMap = temp;
        }
        return Collections.unmodifiableMap(this.primaryKeySchemaMap);
    }

    public List<PrimaryKeySchema> getPrimaryKeyList() {
        return Collections.unmodifiableList(this.primaryKey);
    }

    public void addPrimaryKeyColumn(String name, PrimaryKeyType type) {
        Preconditions.checkArgument(name != null && !name.isEmpty(), "The name of primary key should not be null or empty.");
        Preconditions.checkNotNull(type, "The type of primary key should not be null.");
        this.primaryKey.add(new PrimaryKeySchema(name, type));
        this.primaryKeySchemaMap = null;
    }

    public void addPrimaryKeyColumn(String name, PrimaryKeyType type, PrimaryKeyOption option) {
        Preconditions.checkArgument(name != null && !name.isEmpty(), "The name of primary key should not be null or empty.");
        Preconditions.checkNotNull(type, "The type of primary key should not be null.");
        Preconditions.checkNotNull(option, "The option of primary key should not be null.");
        this.primaryKey.add(new PrimaryKeySchema(name, type, option));
        this.primaryKeySchemaMap = null;
    }

    public void addAutoIncrementPrimaryKeyColumn(String name) {
        Preconditions.checkArgument(name != null && !name.isEmpty(), "The name of primary key should not be null or empty.");
        this.primaryKey.add(new PrimaryKeySchema(name, PrimaryKeyType.INTEGER, PrimaryKeyOption.AUTO_INCREMENT));
        this.primaryKeySchemaMap = null;
    }

    public void addPrimaryKeyColumn(PrimaryKeySchema key) {
        Preconditions.checkNotNull(key, "The primary key schema should not be null.");
        this.primaryKey.add(key);
        this.primaryKeySchemaMap = null;
    }

    public void addPrimaryKeyColumns(List<PrimaryKeySchema> pks) {
        Preconditions.checkArgument(pks != null && !pks.isEmpty(), "The primary key schema should not be null or empty.");
        this.primaryKey.addAll(pks);
        this.primaryKeySchemaMap = null;
    }

    public void addPrimaryKeyColumns(PrimaryKeySchema[] pks) {
        Preconditions.checkArgument(pks != null && pks.length != 0, "The primary key schema should not be null or empty.");
        Collections.addAll(this.primaryKey, pks);
        this.primaryKeySchemaMap = null;
    }

    public Map<String, DefinedColumnType> getDefinedColumnMap() {
        LinkedHashMap<String, DefinedColumnType> result = new LinkedHashMap<String, DefinedColumnType>();
        for (DefinedColumnSchema key : this.definedColumns) {
            result.put(key.getName(), key.getType());
        }
        return result;
    }

    public Map<String, DefinedColumnSchema> getDefinedColumnSchemaMap() {
        if (this.definedColumnsSchemaMap == null) {
            LinkedHashMap<String, DefinedColumnSchema> temp = new LinkedHashMap<String, DefinedColumnSchema>();
            for (DefinedColumnSchema key : this.definedColumns) {
                temp.put(key.getName(), key);
            }
            this.definedColumnsSchemaMap = temp;
        }
        return Collections.unmodifiableMap(this.definedColumnsSchemaMap);
    }

    public List<DefinedColumnSchema> getDefinedColumnsList() {
        return Collections.unmodifiableList(this.definedColumns);
    }

    public void addDefinedColumn(String name, DefinedColumnType type) {
        Preconditions.checkArgument(name != null && !name.isEmpty(), "The name of defined column should not be null or empty.");
        Preconditions.checkNotNull(type, "The type of defined column should not be null.");
        this.definedColumns.add(new DefinedColumnSchema(name, type));
        this.definedColumnsSchemaMap = null;
    }

    public void addDefinedColumn(DefinedColumnSchema column) {
        Preconditions.checkNotNull(column, "The defined column schema should not be null.");
        this.definedColumns.add(column);
        this.definedColumnsSchemaMap = null;
    }

    public void addDefinedColumns(List<DefinedColumnSchema> columns) {
        Preconditions.checkArgument(columns != null && !columns.isEmpty(), "The defined column schema should not be null or empty.");
        this.definedColumns.addAll(columns);
        this.definedColumnsSchemaMap = null;
    }

    public void addDefinedColumns(DefinedColumnSchema[] columns) {
        Preconditions.checkArgument(columns != null && columns.length != 0, "The defined column schema should not be null or empty.");
        Collections.addAll(this.definedColumns, columns);
        this.definedColumnsSchemaMap = null;
    }

    public Optional<String> getTableId() {
        return Optional.ofNullable(this.tableId);
    }

    public void setTableId(String tableId) {
        Preconditions.checkArgument(!StringUtils.isNullOrEmpty(tableId), "The table id should not be null or empty.");
        this.tableId = tableId;
    }

    public Optional<String> getGlobalTableId() {
        return Optional.ofNullable(this.globalTableId);
    }

    public void setGlobalTableId(String globalTableId) {
        Preconditions.checkArgument(!StringUtils.isNullOrEmpty(globalTableId), "The global table id should not be null or empty.");
        this.globalTableId = globalTableId;
    }

    public String toString() {
        String s = "TableName: " + this.tableName + ", PrimaryKeySchema: ";
        boolean first = true;
        for (PrimaryKeySchema pk : this.primaryKey) {
            if (first) {
                first = false;
            } else {
                s = s + ",";
            }
            s = s + pk.toString();
        }
        s = s + ", DefinedColumnSchema: ";
        first = true;
        for (DefinedColumnSchema defCol : this.definedColumns) {
            if (first) {
                first = false;
            } else {
                s = s + ",";
            }
            s = s + defCol.toString();
        }
        return s;
    }

    @Override
    public String jsonize() {
        StringBuilder sb = new StringBuilder();
        this.jsonize(sb, "\n  ");
        return sb.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        DefinedColumnSchema defCol;
        PrimaryKeySchema pk;
        sb.append('{');
        sb.append(newline);
        sb.append("\"TableName\": \"");
        sb.append(this.tableName);
        sb.append('\"');
        sb.append(",");
        sb.append(newline);
        sb.append("\"PrimaryKey\": [");
        String curNewLine = newline + "  ";
        sb.append(curNewLine);
        ListIterator<PrimaryKeySchema> iter = this.primaryKey.listIterator();
        if (iter.hasNext()) {
            pk = iter.next();
            pk.jsonize(sb, curNewLine);
        }
        while (iter.hasNext()) {
            sb.append(",");
            sb.append(curNewLine);
            pk = iter.next();
            pk.jsonize(sb, curNewLine);
        }
        sb.append("],");
        sb.append(newline);
        sb.append("\"DefinedColumn\": [");
        sb.append(curNewLine);
        ListIterator<DefinedColumnSchema> defColIter = this.definedColumns.listIterator();
        if (defColIter.hasNext()) {
            defCol = defColIter.next();
            defCol.jsonize(sb, curNewLine);
        }
        while (defColIter.hasNext()) {
            sb.append(",");
            sb.append(newline);
            defCol = defColIter.next();
            defCol.jsonize(sb, curNewLine);
        }
        sb.append("]}");
    }
}

