/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.protocol.globaltable.GlobalTable;
import java.time.Instant;

public class GlobalTableTypes {

    public static class Removal {
        private String regionId;
        private String instanceName;

        public Removal(String regionId, String instanceName) {
            this.regionId = regionId;
            this.instanceName = instanceName;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }
    }

    public static class UpdatePhyTable {
        private String regionId;
        private String instanceName;
        private String tableName;
        private Boolean writable;
        private Boolean primaryEligible;

        public UpdatePhyTable(String regionId, String instanceName, String tableName) {
            this.regionId = regionId;
            this.instanceName = instanceName;
            this.tableName = tableName;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public Boolean getWritable() {
            return this.writable;
        }

        public void setWritable(Boolean writable) {
            this.writable = writable;
        }

        public Boolean getPrimaryEligible() {
            return this.primaryEligible;
        }

        public void setPrimaryEligible(Boolean primaryEligible) {
            this.primaryEligible = primaryEligible;
        }
    }

    public static enum PhyTableStatus {
        PENDING,
        INIT,
        SYNCDATA,
        READY,
        ACTIVE,
        UNBINDING,
        UNBOUND;


        public static PhyTableStatus parseFrom(GlobalTable.PhyTableStatus protoStatus) {
            if (protoStatus == GlobalTable.PhyTableStatus.PHY_PENDING) {
                return PENDING;
            }
            if (protoStatus == GlobalTable.PhyTableStatus.PHY_INIT) {
                return INIT;
            }
            if (protoStatus == GlobalTable.PhyTableStatus.PHY_SYNCDATA) {
                return SYNCDATA;
            }
            if (protoStatus == GlobalTable.PhyTableStatus.PHY_READY) {
                return READY;
            }
            if (protoStatus == GlobalTable.PhyTableStatus.PHY_ACTIVE) {
                return ACTIVE;
            }
            if (protoStatus == GlobalTable.PhyTableStatus.PHY_UNBINDING) {
                return UNBINDING;
            }
            if (protoStatus == GlobalTable.PhyTableStatus.PHY_UNBOUND) {
                return UNBOUND;
            }
            throw new IllegalArgumentException("Unknown PhyTableStatus: " + protoStatus);
        }

        public GlobalTable.PhyTableStatus toProtocol() {
            if (this == PENDING) {
                return GlobalTable.PhyTableStatus.PHY_PENDING;
            }
            if (this == INIT) {
                return GlobalTable.PhyTableStatus.PHY_INIT;
            }
            if (this == SYNCDATA) {
                return GlobalTable.PhyTableStatus.PHY_SYNCDATA;
            }
            if (this == READY) {
                return GlobalTable.PhyTableStatus.PHY_READY;
            }
            if (this == ACTIVE) {
                return GlobalTable.PhyTableStatus.PHY_ACTIVE;
            }
            if (this == UNBINDING) {
                return GlobalTable.PhyTableStatus.PHY_UNBINDING;
            }
            if (this == UNBOUND) {
                return GlobalTable.PhyTableStatus.PHY_UNBOUND;
            }
            throw new IllegalArgumentException("Unknown PhyTableStatus: " + (Object)((Object)this));
        }
    }

    public static enum GlobalTableStatus {
        INIT,
        RE_CONF,
        ACTIVE;


        public static GlobalTableStatus parseFrom(GlobalTable.GlobalTableStatus protoStatus) {
            if (protoStatus == GlobalTable.GlobalTableStatus.G_INIT) {
                return INIT;
            }
            if (protoStatus == GlobalTable.GlobalTableStatus.G_RE_CONF) {
                return RE_CONF;
            }
            if (protoStatus == GlobalTable.GlobalTableStatus.G_ACTIVE) {
                return ACTIVE;
            }
            throw new IllegalArgumentException("Unknown GlobalTableStatus: " + protoStatus);
        }
    }

    public static enum SyncStage {
        INIT,
        FULL,
        INCR;


        public static SyncStage parseFrom(GlobalTable.SyncStage stage) {
            if (stage == GlobalTable.SyncStage.SYNC_INIT) {
                return INIT;
            }
            if (stage == GlobalTable.SyncStage.SYNC_FULL) {
                return FULL;
            }
            if (stage == GlobalTable.SyncStage.SYNC_INCR) {
                return INCR;
            }
            throw new IllegalArgumentException("Unknown SyncStage: " + stage);
        }

        public GlobalTable.SyncStage toProtocol() {
            if (this == INIT) {
                return GlobalTable.SyncStage.SYNC_INIT;
            }
            if (this == FULL) {
                return GlobalTable.SyncStage.SYNC_FULL;
            }
            if (this == INCR) {
                return GlobalTable.SyncStage.SYNC_INCR;
            }
            throw new IllegalArgumentException("Unknown SyncStage: " + (Object)((Object)this));
        }
    }

    public static enum ServeMode {
        PRIMARY_SECONDARY,
        PEER_TO_PEER;


        public static ServeMode parseFrom(GlobalTable.ServeMode mode) {
            if (mode == GlobalTable.ServeMode.PRIMARY_SECONDARY) {
                return PRIMARY_SECONDARY;
            }
            if (mode == GlobalTable.ServeMode.PEER_TO_PEER) {
                return PEER_TO_PEER;
            }
            throw new IllegalArgumentException("Unknown ServeMode: " + mode);
        }

        public GlobalTable.ServeMode toProtocol() {
            if (this == PRIMARY_SECONDARY) {
                return GlobalTable.ServeMode.PRIMARY_SECONDARY;
            }
            if (this == PEER_TO_PEER) {
                return GlobalTable.ServeMode.PEER_TO_PEER;
            }
            throw new IllegalArgumentException("Unknown ServeMode: " + (Object)((Object)this));
        }
    }

    public static enum SyncMode {
        ROW,
        COLUMN;


        public static SyncMode parseFrom(GlobalTable.SyncMode mode) {
            if (mode == GlobalTable.SyncMode.SYNC_MODE_ROW) {
                return ROW;
            }
            if (mode == GlobalTable.SyncMode.SYNC_MODE_COLUMN) {
                return COLUMN;
            }
            throw new IllegalArgumentException("Unknown SyncMode: " + mode);
        }

        public GlobalTable.SyncMode toProtocol() {
            if (this == ROW) {
                return GlobalTable.SyncMode.SYNC_MODE_ROW;
            }
            if (this == COLUMN) {
                return GlobalTable.SyncMode.SYNC_MODE_COLUMN;
            }
            throw new IllegalArgumentException("Unknown SyncMode: " + (Object)((Object)this));
        }
    }

    public static class PhyTable {
        private String regionId;
        private String instanceName;
        private String tableName;
        private PhyTableStatus status;
        private long statusTimestamp;
        private boolean writable;
        private String role;
        private String tableId;
        private SyncStage stage;
        private Instant rpo;
        private boolean isFailed;
        private String message;

        public PhyTable(String regionId, String instanceName, String tableName, boolean writable) {
            this.regionId = regionId;
            this.instanceName = instanceName;
            this.tableName = tableName;
            this.writable = writable;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public PhyTableStatus getStatus() {
            return this.status;
        }

        public void setStatus(PhyTableStatus status) {
            this.status = status;
        }

        public long getStatusTimestamp() {
            return this.statusTimestamp;
        }

        public void setStatusTimestamp(long statusTimestamp) {
            this.statusTimestamp = statusTimestamp;
        }

        public boolean isWritable() {
            return this.writable;
        }

        public void setWritable(boolean writable) {
            this.writable = writable;
        }

        public String getTableId() {
            return this.tableId;
        }

        public void setTableId(String tableId) {
            this.tableId = tableId;
        }

        public SyncStage getStage() {
            return this.stage;
        }

        public void setStage(SyncStage stage) {
            this.stage = stage;
        }

        public boolean isFailed() {
            return this.isFailed;
        }

        public void setFailed(boolean failed) {
            this.isFailed = failed;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public Instant getRpo() {
            return this.rpo;
        }

        public void setRpo(Instant rpo) {
            this.rpo = rpo;
        }
    }

    public static class Placement {
        private String regionId;
        private String instanceName;
        private boolean writable;

        public Placement(String regionId, String instanceName, boolean writable) {
            this.regionId = regionId;
            this.instanceName = instanceName;
            this.writable = writable;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public boolean isWritable() {
            return this.writable;
        }

        public void setWritable(boolean writable) {
            this.writable = writable;
        }
    }

    public static class BaseTable {
        private String regionId;
        private String instanceName;
        private String tableName;

        public BaseTable(String regionId, String instanceName, String tableName) {
            this.regionId = regionId;
            this.instanceName = instanceName;
            this.tableName = tableName;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }
    }
}

