/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.protocol.PlainBufferCrc8;
import com.alicloud.openservices.tablestore.core.utils.Base64;
import com.alicloud.openservices.tablestore.core.utils.Bytes;
import com.alicloud.openservices.tablestore.core.utils.CalculateHelper;
import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.ColumnType;
import com.alicloud.openservices.tablestore.model.Measurable;
import java.io.IOException;
import java.util.Arrays;

public class ColumnValue
implements Comparable<ColumnValue>,
Jsonizable,
Measurable {
    public static ColumnValue INTERNAL_NULL_VALUE = new ColumnValue(null, ColumnType.STRING);
    private Object value;
    private byte[] rawData;
    private ColumnType type;
    private int dataSize = -1;

    public Object getValue() {
        return this.value;
    }

    public ColumnValue(Object value, ColumnType type) {
        this.value = value;
        this.type = type;
    }

    private int calculateDataSize() {
        int dataSize = 0;
        switch (this.type) {
            case INTEGER: {
                dataSize = 8;
                break;
            }
            case STRING: {
                if (this.value == null) {
                    dataSize = 0;
                    break;
                }
                dataSize = CalculateHelper.calcStringSizeInBytes(this.asString());
                break;
            }
            case BINARY: {
                dataSize = this.asBinary().length;
                break;
            }
            case DOUBLE: {
                dataSize = 8;
                break;
            }
            case BOOLEAN: {
                dataSize = 1;
                break;
            }
            default: {
                throw new IllegalStateException("Bug: not support the type : " + (Object)((Object)this.type));
            }
        }
        return dataSize;
    }

    @Override
    public int getDataSize() {
        if (this.dataSize == -1) {
            this.dataSize = this.calculateDataSize();
        }
        return this.dataSize;
    }

    public ColumnType getType() {
        return this.type;
    }

    public static ColumnValue fromString(String value) {
        Preconditions.checkNotNull(value, "The value of column should not be null.");
        return new ColumnValue(value, ColumnType.STRING);
    }

    public static ColumnValue fromString(String value, byte[] rawData) {
        Preconditions.checkNotNull(value, "The value of column should not be null.");
        Preconditions.checkNotNull(rawData, "The value of rawData should not be null.");
        ColumnValue columnValue = new ColumnValue(value, ColumnType.STRING);
        columnValue.rawData = rawData;
        return columnValue;
    }

    public static ColumnValue fromLong(long value) {
        return new ColumnValue(value, ColumnType.INTEGER);
    }

    public static ColumnValue fromBinary(byte[] value) {
        Preconditions.checkNotNull(value, "The value of column should not be null.");
        return new ColumnValue(value, ColumnType.BINARY);
    }

    public static ColumnValue fromDouble(double value) {
        return new ColumnValue(value, ColumnType.DOUBLE);
    }

    public static ColumnValue fromBoolean(boolean value) {
        return new ColumnValue(value, ColumnType.BOOLEAN);
    }

    public String asString() {
        if (this.type != ColumnType.STRING) {
            throw new IllegalStateException("The type of column is not STRING.");
        }
        return (String)this.value;
    }

    public byte[] asStringInBytes() {
        if (this.rawData == null) {
            this.rawData = Bytes.toBytes(this.asString());
        }
        return this.rawData;
    }

    public long asLong() {
        if (this.type != ColumnType.INTEGER) {
            throw new IllegalStateException("The type of column is not INTEGER.");
        }
        return (Long)this.value;
    }

    public byte[] asBinary() {
        if (this.type != ColumnType.BINARY) {
            throw new IllegalStateException("The type of column is not BINARY.");
        }
        return (byte[])this.value;
    }

    public double asDouble() {
        if (this.type != ColumnType.DOUBLE) {
            throw new IllegalStateException("The type of column is not DOUBLE.");
        }
        return (Double)this.value;
    }

    public boolean asBoolean() {
        if (this.type != ColumnType.BOOLEAN) {
            throw new IllegalStateException("The type of column is not BOOLEAN.");
        }
        return (Boolean)this.value;
    }

    public byte getChecksum(byte crc) throws IOException {
        switch (this.getType()) {
            case STRING: {
                byte[] rawData = this.asStringInBytes();
                crc = PlainBufferCrc8.crc8(crc, (byte)3);
                crc = PlainBufferCrc8.crc8(crc, rawData.length);
                crc = PlainBufferCrc8.crc8(crc, rawData);
                break;
            }
            case INTEGER: {
                crc = PlainBufferCrc8.crc8(crc, (byte)0);
                crc = PlainBufferCrc8.crc8(crc, this.asLong());
                break;
            }
            case BINARY: {
                byte[] rawData = this.asBinary();
                crc = PlainBufferCrc8.crc8(crc, (byte)7);
                crc = PlainBufferCrc8.crc8(crc, rawData.length);
                crc = PlainBufferCrc8.crc8(crc, rawData);
                break;
            }
            case DOUBLE: {
                crc = PlainBufferCrc8.crc8(crc, (byte)1);
                crc = PlainBufferCrc8.crc8(crc, Double.doubleToRawLongBits(this.asDouble()));
                break;
            }
            case BOOLEAN: {
                crc = PlainBufferCrc8.crc8(crc, (byte)2);
                crc = PlainBufferCrc8.crc8(crc, this.asBoolean() ? (byte)1 : 0);
                break;
            }
            default: {
                throw new IOException("Bug: unsupported column type: " + (Object)((Object)this.getType()));
            }
        }
        return crc;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ColumnValue)) {
            return false;
        }
        ColumnValue val = (ColumnValue)o;
        if (this.type == val.type) {
            if (this.type == ColumnType.BINARY) {
                return Bytes.equals((byte[])this.value, (byte[])val.value);
            }
            if (this.value == null) {
                return val.value == null;
            }
            return this.value.equals(val.value);
        }
        return false;
    }

    public int hashCode() {
        if (this.type == ColumnType.BINARY) {
            return Arrays.hashCode(this.asBinary()) * 31 + this.type.hashCode();
        }
        return this.value.hashCode() * 31 + this.type.hashCode();
    }

    public String toString() {
        if (this.value == null) {
            return "null";
        }
        if (this.type == ColumnType.BINARY) {
            return Arrays.toString(this.asBinary());
        }
        return this.value.toString();
    }

    @Override
    public int compareTo(ColumnValue target) {
        if (this.type != target.type) {
            throw new IllegalArgumentException("The type of column to compare must be the same.");
        }
        switch (this.type) {
            case STRING: {
                return ((String)this.value).compareTo(target.asString());
            }
            case INTEGER: {
                return ((Long)this.value).compareTo(target.asLong());
            }
            case BINARY: {
                byte[] b1 = (byte[])this.value;
                byte[] b2 = (byte[])target.value;
                int ret = Bytes.compareByteArrayInLexOrder(b1, 0, b1.length, b2, 0, b2.length);
                return ret;
            }
            case DOUBLE: {
                return ((Double)this.value).compareTo(target.asDouble());
            }
            case BOOLEAN: {
                return ((Boolean)this.value).compareTo(target.asBoolean());
            }
        }
        throw new IllegalArgumentException("Unknown type: " + (Object)((Object)this.type));
    }

    @Override
    public String jsonize() {
        StringBuilder sb = new StringBuilder();
        this.jsonize(sb, "\n  ");
        return sb.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        sb.append("{\"Type\": \"");
        sb.append(this.type.toString());
        sb.append("\", \"Value\": ");
        switch (this.type) {
            case INTEGER: {
                sb.append(this.asLong());
                break;
            }
            case BINARY: {
                sb.append("\"");
                sb.append(Base64.toBase64String(this.asBinary()));
                sb.append("\"");
                break;
            }
            case DOUBLE: {
                sb.append(this.asDouble());
                break;
            }
            case BOOLEAN: {
                sb.append(this.asBoolean() ? "true" : "false");
                break;
            }
            case STRING: {
                sb.append("\"");
                sb.append(this.asString());
                sb.append("\"");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + (Object)((Object)this.type));
            }
        }
        sb.append("}");
    }
}

