/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.protocol;

import com.alicloud.openservices.tablestore.core.utils.BinaryUtil;
import java.io.IOException;
import java.nio.ByteBuffer;

public class PlainBufferInputStream {
    private ByteBuffer buffer;
    private int lastTag;

    public PlainBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
        this.lastTag = 0;
    }

    public PlainBufferInputStream(byte[] buffer) {
        this(ByteBuffer.wrap(buffer));
    }

    public boolean isAtEnd() {
        return !this.buffer.hasRemaining();
    }

    public int readTag() throws IOException {
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = this.readRawByte();
        return this.lastTag;
    }

    public boolean checkLastTagWas(int tag) {
        return this.lastTag == tag;
    }

    public int getLastTag() {
        return this.lastTag;
    }

    public byte readRawByte() throws IOException {
        if (this.isAtEnd()) {
            throw new IOException("Read raw byte encountered EOF.");
        }
        return this.buffer.get();
    }

    public long readRawLittleEndian64() throws IOException {
        byte b1 = this.readRawByte();
        byte b2 = this.readRawByte();
        byte b3 = this.readRawByte();
        byte b4 = this.readRawByte();
        byte b5 = this.readRawByte();
        byte b6 = this.readRawByte();
        byte b7 = this.readRawByte();
        byte b8 = this.readRawByte();
        return (long)b1 & 0xFFL | ((long)b2 & 0xFFL) << 8 | ((long)b3 & 0xFFL) << 16 | ((long)b4 & 0xFFL) << 24 | ((long)b5 & 0xFFL) << 32 | ((long)b6 & 0xFFL) << 40 | ((long)b7 & 0xFFL) << 48 | ((long)b8 & 0xFFL) << 56;
    }

    public int readRawLittleEndian32() throws IOException {
        byte b1 = this.readRawByte();
        byte b2 = this.readRawByte();
        byte b3 = this.readRawByte();
        byte b4 = this.readRawByte();
        return b1 & 0xFF | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 16 | (b4 & 0xFF) << 24;
    }

    public boolean readBoolean() throws IOException {
        return this.readRawByte() != 0;
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    public int readUInt32() throws IOException {
        return this.readRawLittleEndian32();
    }

    public long readInt64() throws IOException {
        return this.readRawLittleEndian64();
    }

    public byte[] readBytes(int size) throws IOException {
        if (this.buffer.remaining() < size) {
            throw new IOException("Read bytes encountered EOF.");
        }
        byte[] result = new byte[size];
        this.buffer.get(result, 0, size);
        return result;
    }

    public String readUTFString(int size) throws IOException {
        return new String(this.readBytes(size), "utf-8");
    }

    public static String bytes2UTFString(byte[] bytes) throws IOException {
        return new String(bytes, "utf-8");
    }

    public String toString() {
        return BinaryUtil.toString(this.buffer);
    }
}

