/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.auth;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.auth.CredentialsFetcher;
import com.alicloud.openservices.tablestore.core.auth.ServiceCredentials;
import com.alicloud.openservices.tablestore.core.utils.HttpRequest;
import com.alicloud.openservices.tablestore.core.utils.HttpResponse;
import com.alicloud.openservices.tablestore.core.utils.MethodType;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpCredentialsFetcher
implements CredentialsFetcher {
    private static Logger logger = LoggerFactory.getLogger(HttpCredentialsFetcher.class);

    @Override
    public abstract URL buildUrl() throws ClientException;

    @Override
    public abstract ServiceCredentials parse(HttpResponse var1) throws ClientException;

    @Override
    public ServiceCredentials fetch() throws ClientException {
        URL url = this.buildUrl();
        HttpRequest request = new HttpRequest(url.toString());
        request.setMethod(MethodType.GET);
        for (Map.Entry<String, String> entry : this.getExtraHeaders().entrySet()) {
            request.putHeaderParameter(entry.getKey(), entry.getValue());
        }
        request.setConnectTimeout(5000);
        request.setReadTimeout(5000);
        HttpResponse response = null;
        try {
            response = this.send(request);
        }
        catch (IOException e) {
            logger.error("CredentialsFetcher.fetch failed.", (Throwable)e);
            throw new ClientException("CredentialsFetcher.fetch exception: " + e);
        }
        return this.parse(response);
    }

    @Override
    public HttpResponse send(HttpRequest request) throws IOException {
        HttpResponse response = HttpResponse.getResponse(request);
        if (response.getStatus() != 200) {
            throw new IOException("HttpCode=" + response.getStatus());
        }
        return response;
    }

    @Override
    public ServiceCredentials fetch(int retryTimes) throws ClientException {
        for (int i = 1; i <= retryTimes; ++i) {
            try {
                return this.fetch();
            }
            catch (Exception e) {
                if (i == retryTimes) {
                    throw new ClientException(e);
                }
                try {
                    Thread.sleep(retryTimes * 100);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        logger.error("Failed to connect ECS Metadata Service after retry '{}' times.", (Object)retryTimes);
        throw new ClientException("Failed to connect ECS Metadata Service: Max retry times exceeded.");
    }
}

