/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore;

import com.alicloud.openservices.tablestore.RequestTracer;
import com.alicloud.openservices.tablestore.TimeseriesConfiguration;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.DefaultRetryStrategy;
import com.alicloud.openservices.tablestore.model.RetryStrategy;

public class ClientConfiguration {
    private static final int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    private int ioThreadCount = AVAILABLE_PROCESSORS;
    private int maxConnections = 300;
    private int socketTimeoutInMillisecond = 30000;
    private int connectionTimeoutInMillisecond = 30000;
    private int connectionRequestTimeoutInMillisecond = -1;
    private int retryThreadCount = 1;
    private boolean enableRequestCompression = false;
    private boolean enableResponseCompression = false;
    private boolean enableResponseValidation = true;
    private boolean enableResponseContentMD5Checking = false;
    private RetryStrategy retryStrategy = new DefaultRetryStrategy();
    private int timeThresholdOfServerTracer = 500;
    private int timeThresholdOfTraceLogger = 1000;
    private String proxyHost;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String proxyDomain;
    private String proxyWorkstation;
    private long syncClientWaitFutureTimeoutInMillis = 60000L;
    private TimeseriesConfiguration timeseriesConfiguration;
    private boolean enableRequestTracer = false;
    private boolean enableDnsCache = false;
    private int dnsCacheMaxSize = 100;
    private int dnsCacheExpireAfterWriteSec = 600;
    private int dnsCacheRefreshAfterWriteSec = 300;
    private RequestTracer requestTracer;
    private int sslSessionCacheSize = -1;
    private int sslSessionTimeoutInSec = -1;

    public void setEnableRequestCompression(boolean enableRequestCompression) {
        this.enableRequestCompression = enableRequestCompression;
    }

    public boolean isEnableRequestCompression() {
        return this.enableRequestCompression;
    }

    public void setEnableResponseCompression(boolean enableResponseCompression) {
        this.enableResponseCompression = enableResponseCompression;
    }

    public boolean isEnableResponseCompression() {
        return this.enableResponseCompression;
    }

    public boolean isEnableResponseValidation() {
        return this.enableResponseValidation;
    }

    public void setEnableResponseValidation(boolean enableResponseValidation) {
        this.enableResponseValidation = enableResponseValidation;
    }

    public int getIoThreadCount() {
        return this.ioThreadCount;
    }

    public void setIoThreadCount(int ioThreadCount) {
        Preconditions.checkArgument(ioThreadCount > 0, "The io thread count must be greater than 0.");
        this.ioThreadCount = ioThreadCount;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        Preconditions.checkArgument(maxConnections > 0, "The max connection must be greater than 0.");
        this.maxConnections = maxConnections;
    }

    public int getSocketTimeoutInMillisecond() {
        return this.socketTimeoutInMillisecond;
    }

    public void setSocketTimeoutInMillisecond(int socketTimeoutInMillisecond) {
        Preconditions.checkArgument(socketTimeoutInMillisecond > 0, "The socket timeout must be greater than 0.");
        this.socketTimeoutInMillisecond = socketTimeoutInMillisecond;
    }

    public int getConnectionTimeoutInMillisecond() {
        return this.connectionTimeoutInMillisecond;
    }

    public void setConnectionTimeoutInMillisecond(int connectionTimeoutInMillisecond) {
        Preconditions.checkArgument(connectionTimeoutInMillisecond > 0, "The connection timeout must be greater than 0.");
        this.connectionTimeoutInMillisecond = connectionTimeoutInMillisecond;
    }

    public int getRetryThreadCount() {
        return this.retryThreadCount;
    }

    public void setRetryThreadCount(int retryThreadCount) {
        Preconditions.checkArgument(retryThreadCount > 0, "The retry thread count must be greater than 0.");
        this.retryThreadCount = retryThreadCount;
    }

    public boolean isEnableResponseContentMD5Checking() {
        return this.enableResponseContentMD5Checking;
    }

    public void setEnableResponseContentMD5Checking(boolean enableResponseContentMD5Checking) {
        this.enableResponseContentMD5Checking = enableResponseContentMD5Checking;
    }

    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public void setRetryStrategy(RetryStrategy retryStrategy) {
        Preconditions.checkArgument(retryStrategy != null, "The retry strategy should not be null.");
        this.retryStrategy = retryStrategy;
    }

    public int getTimeThresholdOfTraceLogger() {
        return this.timeThresholdOfTraceLogger;
    }

    public void setTimeThresholdOfTraceLogger(int timeThresholdOfTraceLogger) {
        Preconditions.checkArgument(timeThresholdOfTraceLogger > 0, "The time threshold of trace logger must be greater than 0.");
        this.timeThresholdOfTraceLogger = timeThresholdOfTraceLogger;
    }

    public int getTimeThresholdOfServerTracer() {
        return this.timeThresholdOfServerTracer;
    }

    public void setTimeThresholdOfServerTracer(int timeThresholdOfServerTracer) {
        Preconditions.checkArgument(timeThresholdOfServerTracer > 0, "The time threshold of server tracer must be greater than 0.");
        this.timeThresholdOfServerTracer = timeThresholdOfServerTracer;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyDomain() {
        return this.proxyDomain;
    }

    public void setProxyDomain(String proxyDomain) {
        this.proxyDomain = proxyDomain;
    }

    public String getProxyWorkstation() {
        return this.proxyWorkstation;
    }

    public void setProxyWorkstation(String proxyWorkstation) {
        this.proxyWorkstation = proxyWorkstation;
    }

    public long getSyncClientWaitFutureTimeoutInMillis() {
        return this.syncClientWaitFutureTimeoutInMillis;
    }

    public void setSyncClientWaitFutureTimeoutInMillis(long syncClientWaitFutureTimeoutInMillis) {
        this.syncClientWaitFutureTimeoutInMillis = syncClientWaitFutureTimeoutInMillis;
    }

    public TimeseriesConfiguration getTimeseriesConfiguration() {
        return this.timeseriesConfiguration;
    }

    public void setTimeseriesConfiguration(TimeseriesConfiguration timeseriesConfiguration) {
        this.timeseriesConfiguration = timeseriesConfiguration;
    }

    public int getConnectionRequestTimeoutInMillisecond() {
        return this.connectionRequestTimeoutInMillisecond;
    }

    public void setConnectionRequestTimeoutInMillisecond(int connectionRequestTimeoutInMillisecond) {
        this.connectionRequestTimeoutInMillisecond = connectionRequestTimeoutInMillisecond;
    }

    public boolean isEnableRequestTracer() {
        return this.enableRequestTracer;
    }

    public void setEnableRequestTracer(boolean enableRequestTracer) {
        this.enableRequestTracer = enableRequestTracer;
    }

    public boolean isEnableDnsCache() {
        return this.enableDnsCache;
    }

    public void setEnableDnsCache(boolean enableDnsCache) {
        this.enableDnsCache = enableDnsCache;
    }

    public int getDnsCacheMaxSize() {
        return this.dnsCacheMaxSize;
    }

    public int getDnsCacheExpireAfterWriteSec() {
        return this.dnsCacheExpireAfterWriteSec;
    }

    public void setDnsCacheExpireAfterWriteSec(int dnsCacheExpireAfterWriteSec) {
        Preconditions.checkArgument(dnsCacheExpireAfterWriteSec > 0, "The dns cache expire after write seconds must be greater than 0.");
        Preconditions.checkArgument(dnsCacheExpireAfterWriteSec <= 600, "The dns cache expire after write seconds must be less than or equal to 600s.");
        this.dnsCacheExpireAfterWriteSec = dnsCacheExpireAfterWriteSec;
    }

    public int getDnsCacheRefreshAfterWriteSec() {
        return this.dnsCacheRefreshAfterWriteSec;
    }

    public void setDnsCacheRefreshAfterWriteSec(int dnsCacheRefreshAfterWriteSec) {
        Preconditions.checkArgument(dnsCacheRefreshAfterWriteSec > 0, "The dns cache refresh after write seconds must be greater than 0.");
        Preconditions.checkArgument(dnsCacheRefreshAfterWriteSec < this.dnsCacheExpireAfterWriteSec, "The dns cache refresh after write seconds must be less than dnsCacheExpireAfterWriteSec.");
        this.dnsCacheRefreshAfterWriteSec = dnsCacheRefreshAfterWriteSec;
    }

    public void setRequestTracer(RequestTracer requestTracer) {
        this.requestTracer = requestTracer;
    }

    public RequestTracer getRequestTracer() {
        return this.requestTracer;
    }

    public void setSslSessionCacheSize(int sslSessionCacheSize) {
        Preconditions.checkArgument(sslSessionCacheSize >= 0, "SSL session cache size should be no less than 0.");
        this.sslSessionCacheSize = sslSessionCacheSize;
    }

    public int getSslSessionCacheSize() {
        return this.sslSessionCacheSize;
    }

    public void setSslSessionTimeoutInSec(int seconds) {
        Preconditions.checkArgument(seconds >= 0, "SSL session timeout should be no less than 0.");
        this.sslSessionTimeoutInSec = seconds;
    }

    public int getSslSessionTimeoutInSec() {
        return this.sslSessionTimeoutInSec;
    }
}

