/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.delivery;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.delivery.DataType;
import com.alicloud.openservices.tablestore.model.delivery.OSSFileEncoding;

public class ParquetSchema {
    private String columnName;
    private String ossColumnName;
    private DataType type;
    private OSSFileEncoding encode;
    private String typeExtend;

    public ParquetSchema() {
        this.setEncode(OSSFileEncoding.PLAIN);
    }

    public ParquetSchema(String columnName, DataType type) {
        this.setColumnName(columnName);
        this.setOssColumnName(columnName);
        this.setType(type);
        this.setEncode(OSSFileEncoding.PLAIN);
    }

    public ParquetSchema(String columnName, String ossColumnName, DataType type) {
        this.setColumnName(columnName);
        this.setOssColumnName(ossColumnName);
        this.setType(type);
        this.setEncode(OSSFileEncoding.PLAIN);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        Preconditions.checkArgument(columnName != null && !columnName.isEmpty(), "the columnName should not be null or empty");
        this.columnName = columnName;
    }

    public String getOssColumnName() {
        return this.ossColumnName;
    }

    public void setOssColumnName(String ossColumnName) {
        Preconditions.checkArgument(ossColumnName != null && !ossColumnName.isEmpty(), "the oss columnName should not be null or empty");
        this.ossColumnName = ossColumnName;
    }

    public DataType getType() {
        return this.type;
    }

    public void setType(DataType type) {
        Preconditions.checkNotNull(type);
        this.type = type;
    }

    public OSSFileEncoding getEncode() {
        return this.encode;
    }

    public void setEncode(OSSFileEncoding encode) {
        Preconditions.checkNotNull(encode);
        this.encode = encode;
    }

    public String getTypeExtend() {
        return this.typeExtend;
    }

    public void setTypeExtend(String typeExtend) {
        Preconditions.checkNotNull(typeExtend);
        this.typeExtend = typeExtend;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append("columnName: ").append(this.columnName).append(", ossColumnName: ").append(this.ossColumnName).append(", type: ").append((Object)this.type).append(", encode: ").append((Object)this.encode).append(", typeExtend: ").append(this.typeExtend).append("}");
        return sb.toString();
    }
}

