/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core;

import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.core.OperationLauncher;
import com.alicloud.openservices.tablestore.core.TraceLogger;
import com.alicloud.openservices.tablestore.core.auth.CredentialsProvider;
import com.alicloud.openservices.tablestore.core.http.AsyncServiceClient;
import com.alicloud.openservices.tablestore.core.http.DescribeStreamResponseConsumer;
import com.alicloud.openservices.tablestore.core.http.OTSUri;
import com.alicloud.openservices.tablestore.core.protocol.OTSProtocolBuilder;
import com.alicloud.openservices.tablestore.core.protocol.OtsInternalApi;
import com.alicloud.openservices.tablestore.core.protocol.ResultParserFactory;
import com.alicloud.openservices.tablestore.core.utils.LogUtil;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.DescribeStreamRequest;
import com.alicloud.openservices.tablestore.model.DescribeStreamResponse;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import com.aliyun.ots.thirdparty.org.apache.concurrent.FutureCallback;

public class DescribeStreamLauncher
extends OperationLauncher<DescribeStreamRequest, DescribeStreamResponse> {
    private OTSUri uri;
    private TraceLogger tracer;
    private RetryStrategy retry;

    public DescribeStreamLauncher(OTSUri uri, TraceLogger tracer, RetryStrategy retry, String instanceName, AsyncServiceClient client, CredentialsProvider crdsProvider, ClientConfiguration config, DescribeStreamRequest originRequest) {
        super(instanceName, client, crdsProvider, config, originRequest);
        Preconditions.checkNotNull(uri);
        Preconditions.checkNotNull(tracer);
        Preconditions.checkNotNull(retry);
        this.uri = uri;
        this.tracer = tracer;
        this.retry = retry;
    }

    @Override
    public void fire(DescribeStreamRequest req, FutureCallback<DescribeStreamResponse> cb) {
        LogUtil.logBeforeExecution(this.tracer, this.retry);
        OtsInternalApi.DescribeStreamResponse defaultResponse = OtsInternalApi.DescribeStreamResponse.getDefaultInstance();
        this.asyncInvokePost(this.uri, null, OTSProtocolBuilder.buildDescribeStreamRequest(req), this.tracer, new DescribeStreamResponseConsumer(ResultParserFactory.createFactory().createProtocolBufferResultParser(defaultResponse, this.tracer.getTraceId()), this.tracer, this.retry, (DescribeStreamResponse)this.lastResult), cb);
    }
}

