/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.groupby;

import com.alicloud.openservices.tablestore.core.protocol.SearchGroupByBuilder;
import com.alicloud.openservices.tablestore.model.search.agg.Aggregation;
import com.alicloud.openservices.tablestore.model.search.agg.AggregationBuilder;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupBy;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByBuilder;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByType;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;

public class GroupByComposite
implements GroupBy {
    private final GroupByType groupByType = GroupByType.GROUP_BY_COMPOSITE;
    private String groupByName;
    private List<GroupBy> sources;
    private String nextToken;
    private Integer size;
    private Integer suggestedSize;
    private List<GroupBy> subGroupBys;
    private List<Aggregation> subAggregations;

    public GroupByComposite() {
    }

    @Override
    public String getGroupByName() {
        return this.groupByName;
    }

    @Override
    public GroupByType getGroupByType() {
        return this.groupByType;
    }

    @Override
    public ByteString serialize() {
        return SearchGroupByBuilder.buildGroupByComposite(this).toByteString();
    }

    public void setGroupByName(String groupByName) {
        this.groupByName = groupByName;
    }

    public void setSources(List<GroupBy> sources) {
        this.sources = sources;
    }

    public List<GroupBy> getSources() {
        return this.sources;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public Integer getSize() {
        return this.size;
    }

    public Integer getSuggestedSize() {
        return this.suggestedSize;
    }

    public void setSuggestedSize(int suggestedSize) {
        this.suggestedSize = suggestedSize;
    }

    public void setSubGroupBys(List<GroupBy> subGroupBys) {
        this.subGroupBys = subGroupBys;
    }

    public List<GroupBy> getSubGroupBys() {
        return this.subGroupBys;
    }

    public void setSubAggregations(List<Aggregation> subAggregations) {
        this.subAggregations = subAggregations;
    }

    public List<Aggregation> getSubAggregations() {
        return this.subAggregations;
    }

    public GroupByComposite(Builder builder) {
        this.groupByName = builder.groupByName;
        this.sources = builder.sources;
        this.nextToken = builder.nextToken;
        this.size = builder.size;
        this.suggestedSize = builder.suggestedSize;
        this.subGroupBys = builder.subGroupBys;
        this.subAggregations = builder.subAggregations;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements GroupByBuilder {
        private String groupByName;
        private List<GroupBy> sources;
        private String nextToken;
        private Integer size;
        private Integer suggestedSize;
        private List<GroupBy> subGroupBys;
        private List<Aggregation> subAggregations;

        public Builder groupByName(String groupByName) {
            this.groupByName = groupByName;
            return this;
        }

        public Builder addSources(GroupBy sourceGroupBy) {
            if (this.sources == null) {
                this.sources = new ArrayList<GroupBy>();
            }
            this.sources.add(sourceGroupBy);
            return this;
        }

        public Builder addSources(GroupByBuilder sourceGroupByBuilder) {
            return this.addSources(sourceGroupByBuilder.build());
        }

        public Builder setSources(List<GroupBy> sources) {
            this.sources = sources;
            return this;
        }

        public Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder suggestedSize(int suggestedSize) {
            this.suggestedSize = suggestedSize;
            return this;
        }

        public Builder addSubAggregation(AggregationBuilder aggregationBuilder) {
            if (this.subAggregations == null) {
                this.subAggregations = new ArrayList<Aggregation>();
            }
            this.subAggregations.add(aggregationBuilder.build());
            return this;
        }

        public Builder addSubAggregation(Aggregation aggregation) {
            if (this.subAggregations == null) {
                this.subAggregations = new ArrayList<Aggregation>();
            }
            this.subAggregations.add(aggregation);
            return this;
        }

        public Builder addSubGroupBy(GroupByBuilder groupByBuilder) {
            if (this.subGroupBys == null) {
                this.subGroupBys = new ArrayList<GroupBy>();
            }
            this.subGroupBys.add(groupByBuilder.build());
            return this;
        }

        public Builder addSubGroupBy(GroupBy groupBy) {
            if (this.subGroupBys == null) {
                this.subGroupBys = new ArrayList<GroupBy>();
            }
            this.subGroupBys.add(groupBy);
            return this;
        }

        @Override
        public GroupByComposite build() {
            return new GroupByComposite(this);
        }
    }
}

