/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.http;

import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.ClientException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.nio.conn.NHttpClientConnectionManager;

class HttpFactory {
    HttpFactory() {
    }

    public static CloseableHttpAsyncClient createHttpAsyncClient(ClientConfiguration config, PoolingNHttpClientConnectionManager cm) {
        HttpAsyncClientBuilder httpClientBuilder = HttpAsyncClients.custom();
        httpClientBuilder.setConnectionManager((NHttpClientConnectionManager)cm);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectTimeout(config.getConnectionTimeoutInMillisecond()).setSocketTimeout(config.getSocketTimeoutInMillisecond());
        if (config.getConnectionRequestTimeoutInMillisecond() > 0) {
            requestConfigBuilder.setConnectionRequestTimeout(config.getConnectionRequestTimeoutInMillisecond());
        }
        httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        httpClientBuilder.setUserAgent("ots-java-sdk 5.17.5");
        httpClientBuilder.disableCookieManagement();
        String proxyHost = config.getProxyHost();
        int proxyPort = config.getProxyPort();
        if (proxyHost != null) {
            if (proxyPort <= 0) {
                throw new ClientException("The proxy port is invalid. Please check your configuration.");
            }
            HttpHost proxy = new HttpHost(proxyHost, proxyPort);
            httpClientBuilder.setProxy(proxy);
            String proxyUsername = config.getProxyUsername();
            String proxyPassword = config.getProxyPassword();
            if (proxyUsername != null && proxyPassword != null) {
                String proxyDomain = config.getProxyDomain();
                String proxyWorkstation = config.getProxyWorkstation();
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new NTCredentials(proxyUsername, proxyPassword, proxyWorkstation, proxyDomain));
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
        }
        return httpClientBuilder.build();
    }
}

