/*
 * Decompiled with CFR 0.152.
 */
package com.alicom.mns.tools.inter;

import com.alicom.mns.tools.inter.TokenForAlicom;
import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.client.MNSClient;
import com.aliyun.mns.common.http.ClientConfiguration;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dybaseapi.model.v20180501.QueryTokenForMnsQueueRequest;
import com.aliyuncs.dybaseapi.model.v20180501.QueryTokenForMnsQueueResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.http.HttpHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenGetterForAlicom {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenGetterForAlicom.class);
    private static final String PRODUCT_NAME = "Dybaseapi";
    private static final long BUFFER_TIME = 120000L;
    private String accessKeyId;
    private String accessKeySecret;
    private String endpointNameForPop;
    private String regionIdForPop;
    private String domainForPop;
    private HttpHost proxy;
    private IAcsClient iAcsClient;
    private Long ownerId;
    private final Object lock = new Object();
    private final ConcurrentMap<String, TokenForAlicom> tokenMap = new ConcurrentHashMap<String, TokenForAlicom>();

    public TokenGetterForAlicom(String accessKeyId, String accessKeySecret, String endpointNameForPop, String regionIdForPop, String domainForPop, Long ownerId) {
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.endpointNameForPop = endpointNameForPop;
        this.regionIdForPop = regionIdForPop;
        this.domainForPop = domainForPop;
        this.ownerId = ownerId;
        this.init();
    }

    public TokenGetterForAlicom(String accessKeyId, String accessKeySecret, String endpointNameForPop, String regionIdForPop, String domainForPop, Long ownerId, HttpHost proxy) {
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.endpointNameForPop = endpointNameForPop;
        this.regionIdForPop = regionIdForPop;
        this.domainForPop = domainForPop;
        this.ownerId = ownerId;
        this.proxy = proxy;
        this.init();
    }

    public TokenGetterForAlicom(IAcsClient client) {
        this.iAcsClient = client;
    }

    private void init() {
        DefaultProfile.addEndpoint((String)this.regionIdForPop, (String)PRODUCT_NAME, (String)this.domainForPop);
        DefaultProfile profile = DefaultProfile.getProfile((String)this.regionIdForPop, (String)this.accessKeyId, (String)this.accessKeySecret);
        if (this.proxy != null) {
            profile.getHttpClientConfig().setHttpProxy(this.proxy.toURI());
            profile.getHttpClientConfig().setHttpsProxy(this.proxy.toURI());
        }
        this.iAcsClient = new DefaultAcsClient((IClientProfile)profile);
    }

    private TokenForAlicom getTokenFromRemote(String messageType) throws ClientException, ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));
        QueryTokenForMnsQueueRequest request = new QueryTokenForMnsQueueRequest();
        request.setAcceptFormat(FormatType.JSON);
        request.setMessageType(messageType);
        request.setOwnerId(this.ownerId);
        request.setSysProtocol(ProtocolType.HTTPS);
        request.setSysMethod(MethodType.POST);
        QueryTokenForMnsQueueResponse response = (QueryTokenForMnsQueueResponse)this.iAcsClient.getAcsResponse((AcsRequest)request);
        String resultCode = response.getCode();
        if ("OK".equals(resultCode)) {
            QueryTokenForMnsQueueResponse.MessageTokenDTO dto = response.getMessageTokenDTO();
            TokenForAlicom token = new TokenForAlicom();
            String timeStr = dto.getExpireTime();
            token.setMessageType(messageType);
            token.setExpireTime(df.parse(timeStr).getTime());
            token.setToken(dto.getSecurityToken());
            token.setTempAccessKeyId(dto.getAccessKeyId());
            token.setTempAccessKeySecret(dto.getAccessKeySecret());
            return token;
        }
        LOGGER.error("getTokenFromRemote_error,messageType:" + messageType + ",code:" + response.getCode() + ",message:" + response.getMessage());
        throw new ServerException(response.getCode(), response.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenForAlicom getTokenByMessageType(String messageType, String queueName, String mnsAccountEndpoint) throws ClientException, ParseException {
        TokenForAlicom token = (TokenForAlicom)this.tokenMap.get(messageType);
        Long now = System.currentTimeMillis();
        if (token == null || token.getExpireTime() - now < 120000L) {
            Object object = this.lock;
            synchronized (object) {
                token = (TokenForAlicom)this.tokenMap.get(messageType);
                if (token == null || token.getExpireTime() - now < 120000L) {
                    CloudAccount account;
                    TokenForAlicom oldToken = null;
                    if (token != null) {
                        oldToken = token;
                    }
                    token = this.getTokenFromRemote(messageType);
                    if (this.proxy != null) {
                        ClientConfiguration cc = new ClientConfiguration();
                        cc.setExceptContinue(false);
                        cc.setProxyHost(this.proxy.getHostName());
                        cc.setProxyPort(this.proxy.getPort());
                        account = new CloudAccount(token.getTempAccessKeyId(), token.getTempAccessKeySecret(), mnsAccountEndpoint, token.getToken(), cc);
                    } else {
                        account = new CloudAccount(token.getTempAccessKeyId(), token.getTempAccessKeySecret(), mnsAccountEndpoint, token.getToken());
                    }
                    MNSClient client = account.getMNSClient();
                    CloudQueue queue = client.getQueueRef(queueName);
                    token.setClient(client);
                    token.setQueue(queue);
                    this.tokenMap.put(messageType, token);
                    if (oldToken != null) {
                        oldToken.closeClient();
                    }
                }
            }
        }
        return token;
    }
}

