/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.utils;

import com.aliyun.oss.internal.OSSUtils;
import java.util.List;

public class CodingUtils {
    public static void assertParameterNotNull(Object param2, String paramName) {
        if (param2 == null) {
            throw new NullPointerException(OSSUtils.COMMON_RESOURCE_MANAGER.getFormattedString("ParameterIsNull", paramName));
        }
    }

    public static void assertParameterInRange(long param2, long lower, long upper) {
        if (!CodingUtils.checkParamRange(param2, lower, true, upper, true)) {
            throw new IllegalArgumentException(String.format("%d not in valid range [%d, %d]", param2, lower, upper));
        }
    }

    public static void assertStringNotNullOrEmpty(String param2, String paramName) {
        CodingUtils.assertParameterNotNull(param2, paramName);
        if (param2.trim().length() == 0) {
            throw new IllegalArgumentException(OSSUtils.COMMON_RESOURCE_MANAGER.getFormattedString("ParameterStringIsEmpty", paramName));
        }
    }

    public static void assertListNotNullOrEmpty(List<?> param2, String paramName) {
        CodingUtils.assertParameterNotNull(param2, paramName);
        if (param2.size() == 0) {
            throw new IllegalArgumentException(OSSUtils.COMMON_RESOURCE_MANAGER.getFormattedString("ParameterListIsEmpty", paramName));
        }
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static void assertTrue(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean checkParamRange(long param2, long from, boolean leftInclusive, long to, boolean rightInclusive) {
        if (leftInclusive && rightInclusive) {
            return from <= param2 && param2 <= to;
        }
        if (leftInclusive && !rightInclusive) {
            return from <= param2 && param2 < to;
        }
        if (!leftInclusive && !rightInclusive) {
            return from < param2 && param2 < to;
        }
        return from < param2 && param2 <= to;
    }
}

