package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.OptionalValue;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;

public class DescribeStreamRequest implements Request {

    /**
     * StreamId, specifies a Stream.
     */
    private String streamId;

    /**
     * InclusiveStartShardId specifies the left boundary of the returned Shard list. Optional parameter.
     */
    private OptionalValue<String> inclusiveStartShardId = new OptionalValue<String>("InclusiveStartShardId");

    /**
     * ShardLimit specifies the maximum number of Shards to return. Optional parameter.
     */
    private OptionalValue<Integer> shardLimit = new OptionalValue<Integer>("ShardLimit");

    private boolean supportTimeseriesTable = false;

    public DescribeStreamRequest(String streamId) {
        setStreamId(streamId);
    }

    /**
     * Get the StreamId parameter.
     * StreamId is used to specify a Stream, and it is generated by the server when Stream is enabled on a table.
     * Users can obtain the StreamId through a ListStream request.
     *
     * @return streamId
     */
    public String getStreamId() {
        return streamId;
    }

    /**
     * Set the StreamId parameter.
     * StreamId is used to specify a Stream. When Stream is enabled on a table, the corresponding StreamId will be generated by the server.
     * Users can obtain StreamId through the ListStream request.
     *
     * @param streamId
     */
    public void setStreamId(String streamId) {
        Preconditions.checkArgument(streamId != null && !streamId.isEmpty(), "The streamId should not be null or empty.");
        this.streamId = streamId;
    }

    /**
     * Get the InclusiveStartShardId parameter.
     * The InclusiveStartShardId parameter is used to specify the left boundary (inclusive) of the returned Shard list.
     * If it returns null, it means that the parameter has not been set.
     *
     * @return inclusiveStartShardId
     */
    public String getInclusiveStartShardId() {
        return inclusiveStartShardId.getValue();
    }

    /**
     * Set the InclusiveStartShardId parameter.
     * The InclusiveStartShardId parameter is used to specify the left boundary (inclusive) of the returned Shard list.
     *
     * @param inclusiveStartShardId
     */
    public void setInclusiveStartShardId(String inclusiveStartShardId) {
        Preconditions.checkArgument(inclusiveStartShardId != null && !inclusiveStartShardId.isEmpty(),
                "The inclusiveStartShardId is null or empty.");
        this.inclusiveStartShardId.setValue(inclusiveStartShardId);
    }

    /**
     * Get the ShardLimit parameter.
     * The ShardLimit parameter is used to limit the maximum number of Shards returned.
     *
     * @return The ShardLimit parameter, if it is -1, it means that the parameter is not set.
     */
    public int getShardLimit() {
        if (shardLimit.isValueSet()) {
            return shardLimit.getValue();
        } else {
            return -1;
        }
    }

    /**
     * Set the ShardLimit parameter.
     * The ShardLimit parameter is used to limit the maximum number of Shards returned.
     *
     * @param shardLimit
     */
    public void setShardLimit(int shardLimit) {
        Preconditions.checkArgument(shardLimit > 0, "The limit must be greater than 0.");
        this.shardLimit.setValue(shardLimit);
    }

    public boolean isSupportTimeseriesTable() {
        return this.supportTimeseriesTable;
    }

    public void setSupportTimeseriesTable(boolean isSupport) {
        this.supportTimeseriesTable = isSupport;
    }

    @Override
    public String getOperationName() {
        return OperationNames.OP_DESCRIBE_STREAM;
    }
}
