/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.tunnel.pipeline;

import com.alicloud.openservices.tablestore.model.StreamRecord;
import com.alicloud.openservices.tablestore.model.tunnel.internal.CheckpointResponse;
import com.alicloud.openservices.tablestore.model.tunnel.internal.ReadRecordsRequest;
import com.alicloud.openservices.tablestore.model.tunnel.internal.ReadRecordsResponse;
import com.alicloud.openservices.tablestore.tunnel.pipeline.AbstractStage;
import com.alicloud.openservices.tablestore.tunnel.pipeline.Pipeline;
import com.alicloud.openservices.tablestore.tunnel.pipeline.ProcessDataBackoff;
import com.alicloud.openservices.tablestore.tunnel.pipeline.ProcessDataPipelineContext;
import com.alicloud.openservices.tablestore.tunnel.pipeline.Stage;
import com.alicloud.openservices.tablestore.tunnel.pipeline.StageException;
import com.alicloud.openservices.tablestore.tunnel.worker.ChannelConnect;
import com.alicloud.openservices.tablestore.tunnel.worker.ChannelConnectStatus;
import com.alicloud.openservices.tablestore.tunnel.worker.IChannelProcessor;
import com.alicloud.openservices.tablestore.tunnel.worker.ProcessRecordsInput;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDataPipeline
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessDataPipeline.class);
    private final ChannelConnect connect;
    private volatile boolean started = false;
    private final ThreadPoolExecutor readRecordsExecutor;
    private final ThreadPoolExecutor processRecordsExecutor;
    private Semaphore semaphore;
    private int readMaxTimesPerRound = 1;
    private int readMaxBytesPerRound = 0x400000;
    private final ExecutorService pipelineHelperExecutor;
    private ProcessDataBackoff backoff;
    private Pipeline<ReadRecordsRequest, CheckpointResponse> pipeline;
    private static final int COUNT_BAR = 500;
    private static final int SIZE_BAR = 921600;

    public ProcessDataPipeline(ChannelConnect connect, ExecutorService helperExecutor, ThreadPoolExecutor readRecordsExecutor, ThreadPoolExecutor processRecordsExecutor) {
        this.connect = connect;
        this.pipelineHelperExecutor = helperExecutor;
        this.readRecordsExecutor = readRecordsExecutor;
        this.processRecordsExecutor = processRecordsExecutor;
    }

    public ProcessDataPipeline(ChannelConnect connect, ExecutorService helperExecutor, ThreadPoolExecutor readRecordsExecutor, ThreadPoolExecutor processRecordsExecutor, Semaphore semaphore) {
        this.connect = connect;
        this.pipelineHelperExecutor = helperExecutor;
        this.readRecordsExecutor = readRecordsExecutor;
        this.processRecordsExecutor = processRecordsExecutor;
        this.semaphore = semaphore;
    }

    @Override
    public void run() {
        if (this.semaphore != null) {
            try {
                this.semaphore.acquire();
                LOG.info("Tunnel {}, Channel {} acquire semaphore succeed, permits remaining: {}", new Object[]{this.connect.getTunnelId(), this.connect.getChannelId(), this.semaphore.availablePermits()});
                LOG.debug("Semaphore permits remaining {}, queued {}", (Object)this.semaphore.availablePermits(), (Object)this.semaphore.getQueueLength());
            }
            catch (InterruptedException e) {
                LOG.warn("Acquire semaphore failed: {}, ChannelId: {}", (Object)e.toString(), (Object)this.connect.getChannelId());
                this.semaphore.release();
            }
        }
        if (!this.started) {
            LOG.info("Initial process data pipeline.");
            this.pipeline = this.buildPipeline();
            this.pipeline.init(new ProcessDataPipelineContext(this.connect, this.semaphore));
            this.started = true;
        }
        this.pipeline.process(new ReadRecordsRequest(this.connect.getTunnelId(), this.connect.getClientId(), this.connect.getChannelId(), this.connect.getToken()));
    }

    private Pipeline<ReadRecordsRequest, CheckpointResponse> buildPipeline() {
        Pipeline<ReadRecordsRequest, CheckpointResponse> pipeline = new Pipeline<ReadRecordsRequest, CheckpointResponse>(this.pipelineHelperExecutor);
        Stage<ReadRecordsRequest, ProcessRecordsInput> readRecordsStage = this.createReadRecordsStage();
        pipeline.addExecutorForStage(readRecordsStage, this.readRecordsExecutor);
        Stage<ProcessRecordsInput, Boolean> processRecordStage = this.createProcessRecordsStage();
        pipeline.addExecutorForStage(processRecordStage, this.processRecordsExecutor);
        return pipeline;
    }

    private Stage<ReadRecordsRequest, ProcessRecordsInput> createReadRecordsStage() {
        return new AbstractStage<ReadRecordsRequest, ProcessRecordsInput>(){

            @Override
            public ProcessRecordsInput doProcess(ReadRecordsRequest readRecordsRequest) throws StageException {
                if (ProcessDataPipeline.this.connect.getStatus() == ChannelConnectStatus.RUNNING) {
                    if (ProcessDataPipeline.this.connect.getToken() != null && !"finished".equals(ProcessDataPipeline.this.connect.getToken())) {
                        try {
                            LOG.debug("Begin read records, connect: {}", (Object)ProcessDataPipeline.this.connect);
                            long beginTs = System.currentTimeMillis();
                            ReadRecordsResponse resp = null;
                            LinkedList<StreamRecord> totalRecords = new LinkedList<StreamRecord>();
                            int totalBytes = 0;
                            int times = 0;
                            int totalRecordsCount = 0;
                            while (totalBytes < ProcessDataPipeline.this.readMaxBytesPerRound && times < ProcessDataPipeline.this.readMaxTimesPerRound) {
                                resp = ProcessDataPipeline.this.connect.getClient().readRecords(readRecordsRequest);
                                totalRecords.addAll(resp.getRecords());
                                totalRecordsCount += resp.getRecords().size();
                                totalBytes += resp.getMemoizedSerializedSize();
                                ++times;
                                if (resp.getNextToken() == null || "finished".equals(resp.getNextToken())) {
                                    LOG.info("Channel {} next token is null", (Object)ProcessDataPipeline.this.connect.getChannelId());
                                    break;
                                }
                                if (ProcessDataPipeline.this.backoff != null) {
                                    if (ProcessDataPipeline.this.needResetBackoff(resp.getRecords().size(), resp.getMemoizedSerializedSize(), resp.getMayMoreRecord())) {
                                        LOG.debug("Backoff is reset");
                                        ProcessDataPipeline.this.backoff.reset();
                                    } else {
                                        long sleepMills = ProcessDataPipeline.this.backoff.nextBackOffMillis();
                                        LOG.debug("Data is not full, sleep {} msec.", (Object)sleepMills);
                                        Thread.sleep(ProcessDataPipeline.this.backoff.nextBackOffMillis());
                                        break;
                                    }
                                }
                                readRecordsRequest.setToken(resp.getNextToken());
                            }
                            if (resp == null) {
                                LOG.info("ReadRecordsResponse is null, channelId: {}", (Object)ProcessDataPipeline.this.connect.getChannelId());
                                return new ProcessRecordsInput(totalRecords, null, null);
                            }
                            LOG.info("GetRecords, Num: {}, LoopTimes: {}, TotalBytes: {}, Channel connect: {}, Latency: {} ms, Next Token: {}", new Object[]{totalRecordsCount, times, totalBytes, ProcessDataPipeline.this.connect, System.currentTimeMillis() - beginTs, resp.getNextToken()});
                            return new ProcessRecordsInput(totalRecords, resp.getNextToken(), resp.getRequestId(), ProcessDataPipeline.this.connect.getChannelId());
                        }
                        catch (Exception e) {
                            throw new StageException(this, readRecordsRequest, e.getMessage(), e);
                        }
                    }
                    LOG.info("Channel is finished, channel will be closed.");
                    ProcessDataPipeline.this.connect.close(true);
                    throw new StageException(this, readRecordsRequest, "Channel connect is finished.");
                }
                throw new StageException(this, readRecordsRequest, "Channel is not running.");
            }
        };
    }

    private Stage<ProcessRecordsInput, Boolean> createProcessRecordsStage() {
        return new AbstractStage<ProcessRecordsInput, Boolean>(){

            @Override
            public Boolean doProcess(ProcessRecordsInput processRecordsInput) throws StageException {
                if (ProcessDataPipeline.this.connect.getStatus() == ChannelConnectStatus.RUNNING) {
                    try {
                        IChannelProcessor processor = ProcessDataPipeline.this.connect.getProcessor();
                        processor.process(processRecordsInput);
                        ProcessDataPipeline.this.connect.setToken(processRecordsInput.getNextToken());
                        LOG.info("Continue run pipeline, connect: {}", (Object)ProcessDataPipeline.this.connect);
                        ProcessDataPipeline.this.connect.getChannelExecutorService().submit(ProcessDataPipeline.this.connect.getProcessPipeline());
                        if (ProcessDataPipeline.this.semaphore != null) {
                            ProcessDataPipeline.this.semaphore.release();
                            LOG.info("Channel {} release semaphore succeed", (Object)ProcessDataPipeline.this.connect.getChannelId());
                            LOG.debug("Semaphore permits remaining {}, queued {}", (Object)ProcessDataPipeline.this.semaphore.availablePermits(), (Object)ProcessDataPipeline.this.semaphore.getQueueLength());
                        }
                        return true;
                    }
                    catch (Exception e) {
                        throw new StageException(this, processRecordsInput, e.getMessage(), e);
                    }
                }
                throw new StageException(this, processRecordsInput, "Channel is not running.");
            }
        };
    }

    private boolean needResetBackoff(int numRec, int size, Boolean mayMoreRecord) {
        if (mayMoreRecord != null) {
            return mayMoreRecord;
        }
        return this.checkDataEnough(numRec, size);
    }

    private boolean checkDataEnough(int numRec, int size) {
        return numRec > 500 || size > 921600;
    }

    public ProcessDataBackoff getBackoff() {
        return this.backoff;
    }

    public void setBackoff(ProcessDataBackoff backoff) {
        this.backoff = backoff;
    }

    public Semaphore getSemaphore() {
        return this.semaphore;
    }

    public void setSemaphore(Semaphore semaphore) {
        this.semaphore = semaphore;
    }

    public void setReadMaxTimesPerRound(int readMaxTimesPerRound) {
        this.readMaxTimesPerRound = readMaxTimesPerRound;
    }

    public void setReadMaxBytesPerRound(int readMaxBytesPerRound) {
        this.readMaxBytesPerRound = readMaxBytesPerRound;
    }
}

