/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.vector;

import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.model.search.vector.VectorDataType;
import com.alicloud.openservices.tablestore.model.search.vector.VectorMetricType;
import java.util.ArrayList;

public class VectorOptions
implements Jsonizable {
    private VectorDataType dataType;
    private Integer dimension;
    private VectorMetricType metricType;

    public VectorOptions() {
    }

    public VectorOptions(VectorDataType dataType, int dimension, VectorMetricType metricType) {
        this.dataType = dataType;
        this.dimension = dimension;
        this.metricType = metricType;
    }

    public VectorDataType getDataType() {
        return this.dataType;
    }

    public VectorOptions setDataType(VectorDataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public Integer getDimension() {
        return this.dimension;
    }

    public VectorOptions setDimension(Integer dimension) {
        this.dimension = dimension;
        return this;
    }

    public VectorMetricType getMetricType() {
        return this.metricType;
    }

    public VectorOptions setMetricType(VectorMetricType metricType) {
        this.metricType = metricType;
        return this;
    }

    @Override
    public String jsonize() {
        StringBuilder stringBuilder = new StringBuilder();
        this.jsonize(stringBuilder, "\n");
        return stringBuilder.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        sb.append('{');
        sb.append(newline);
        ArrayList<String> jsonItems = new ArrayList<String>();
        if (this.dataType != null) {
            jsonItems.add("\t\"dataType\": \"" + this.dataType.name() + "\"");
        }
        if (this.dimension != null) {
            jsonItems.add("\t\"dimension\": " + this.dimension);
        }
        if (this.metricType != null) {
            jsonItems.add("\t\"metricType\": \"" + this.metricType.name() + "\"");
        }
        for (int i = 0; i < jsonItems.size(); ++i) {
            if (i != 0) {
                sb.append(",").append(newline);
            }
            sb.append((String)jsonItems.get(i));
        }
        sb.append(newline);
        sb.append('}');
    }
}

