/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.model.GlobalTableTypes;
import com.alicloud.openservices.tablestore.model.Request;
import com.google.common.collect.Lists;
import java.util.List;

public class CreateGlobalTableRequest
implements Request {
    private GlobalTableTypes.BaseTable baseTable;
    private List<GlobalTableTypes.Placement> placements = Lists.newArrayList();
    private GlobalTableTypes.SyncMode syncMode;
    private GlobalTableTypes.ServeMode serveMode;

    public CreateGlobalTableRequest(GlobalTableTypes.BaseTable baseTable, GlobalTableTypes.SyncMode syncMode) {
        this.baseTable = baseTable;
        this.syncMode = syncMode;
    }

    public List<GlobalTableTypes.Placement> addPlacement(GlobalTableTypes.Placement placement) {
        if (placement == null) {
            throw new IllegalArgumentException("The placement should not be null.");
        }
        this.placements.add(placement);
        return this.placements;
    }

    @Override
    public String getOperationName() {
        return "CreateGlobalTable";
    }

    public GlobalTableTypes.BaseTable getBaseTable() {
        return this.baseTable;
    }

    public void setBaseTable(GlobalTableTypes.BaseTable baseTable) {
        this.baseTable = baseTable;
    }

    public List<GlobalTableTypes.Placement> getPlacements() {
        return this.placements;
    }

    public void setPlacements(List<GlobalTableTypes.Placement> placements) {
        this.placements = placements;
    }

    public GlobalTableTypes.SyncMode getSyncMode() {
        return this.syncMode;
    }

    public void setSyncMode(GlobalTableTypes.SyncMode syncMode) {
        this.syncMode = syncMode;
    }

    public GlobalTableTypes.ServeMode getServeMode() {
        return this.serveMode;
    }

    public void setServeMode(GlobalTableTypes.ServeMode serveMode) {
        this.serveMode = serveMode;
    }
}

