/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.auth;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.auth.HttpCredentialsFetcher;
import com.alicloud.openservices.tablestore.core.auth.InstanceProfileCredentials;
import com.alicloud.openservices.tablestore.core.auth.ServiceCredentials;
import com.alicloud.openservices.tablestore.core.utils.HttpRequest;
import com.alicloud.openservices.tablestore.core.utils.HttpResponse;
import com.alicloud.openservices.tablestore.core.utils.MethodType;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceProfileCredentialsFetcher
extends HttpCredentialsFetcher {
    private static Logger logger = LoggerFactory.getLogger(InstanceProfileCredentialsFetcher.class);
    private static final String HEADER_ECS_METADATA_TOKEN_TTL = "X-aliyun-ecs-metadata-token-ttl-seconds";
    private static final String HEADER_ECS_METADATA_TOKEN = "X-aliyun-ecs-metadata-token";
    private static final String URL_IN_ECS_TOKEN = "/latest/api/token";
    private static final String URL_IN_ECS_METADATA = "/latest/meta-data/ram/security-credentials/";
    private static final String metadataServiceHost = "100.100.100.200";
    private static final int DEFAULT_TOKEN_TTL_IN_SECONDS = 21600;
    private static final int TOKEN_EXPIRATION_BUFFER_IN_SECONDS = 600;
    private String token;
    private long tokenTimestamp = 0L;
    private String roleName;

    public void setRoleName(String roleName) {
        if (null == roleName || roleName.isEmpty()) {
            throw new IllegalArgumentException("You must specifiy a valid role name.");
        }
        this.roleName = roleName;
    }

    public InstanceProfileCredentialsFetcher withRoleName(String roleName) {
        this.setRoleName(roleName);
        return this;
    }

    @Override
    public URL buildUrl() throws ClientException {
        try {
            return new URL("http://100.100.100.200/latest/meta-data/ram/security-credentials/" + this.roleName);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public URL buildFetchTokenUrl() throws ClientException {
        try {
            return new URL("http://100.100.100.200/latest/api/token");
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    @Override
    public Map<String, String> getExtraHeaders() {
        return Collections.singletonMap(HEADER_ECS_METADATA_TOKEN, this.getToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getToken() {
        if (null == this.token || this.isTokenExpired()) {
            InstanceProfileCredentialsFetcher instanceProfileCredentialsFetcher = this;
            synchronized (instanceProfileCredentialsFetcher) {
                if (null == this.token || this.isTokenExpired()) {
                    this.refreshToken();
                }
            }
        }
        return this.token;
    }

    private boolean isTokenExpired() {
        return System.currentTimeMillis() - this.tokenTimestamp > 21000000L;
    }

    private void refreshToken() {
        URL url = this.buildFetchTokenUrl();
        HttpRequest request = new HttpRequest(url.toString());
        request.setMethod(MethodType.PUT);
        request.putHeaderParameter(HEADER_ECS_METADATA_TOKEN_TTL, String.valueOf(21600));
        request.setConnectTimeout(5000);
        request.setReadTimeout(5000);
        HttpResponse response = null;
        try {
            response = this.send(request);
        }
        catch (IOException e) {
            logger.error("InstanceProfileCredentialsFetcher.refreshToken failed.", (Throwable)e);
            throw new ClientException("InstanceProfileCredentialsFetcher.refreshToken exception: " + e);
        }
        if (response.getHttpContent() == null) {
            logger.error("Invalid response from ECS Metadata service: null.");
            throw new ClientException("Invalid response got from ECS Metadata service.");
        }
        this.token = new String(response.getHttpContent());
        this.tokenTimestamp = System.currentTimeMillis();
        logger.info("Refreshed RAM session credentials token: {}.", (Object)this.token);
    }

    @Override
    public ServiceCredentials parse(HttpResponse response) throws ClientException {
        if (response.getHttpContent() == null) {
            logger.error("Invalid response from ECS Metadata service: null.");
            throw new ClientException("Invalid json got from ECS Metadata service.");
        }
        String jsonContent = new String(response.getHttpContent());
        try {
            MetadataResponse res = (MetadataResponse)new Gson().fromJson(jsonContent, MetadataResponse.class);
            if (res == null) {
                logger.error("Invalid response from ECS Metadata service: {}.", (Object)jsonContent);
                throw new ClientException("Invalid json got from ECS Metadata service.");
            }
            if (res.code == null || res.accessKeyId == null || res.accessKeySecret == null || res.securityToken == null || res.expiration == null) {
                logger.error("Invalid response from ECS Metadata service: {}.", (Object)jsonContent);
                throw new ClientException("Invalid json got from ECS Metadata service.");
            }
            if (!"Success".equalsIgnoreCase(res.code)) {
                logger.error("Failed to get RAM session credentials from ECS Metadata service: {}.", (Object)jsonContent);
                throw new ClientException("Failed to get RAM session credentials from ECS metadata service.");
            }
            return new InstanceProfileCredentials(res.accessKeyId, res.accessKeySecret, res.securityToken, res.expiration);
        }
        catch (Exception e) {
            throw new ClientException("InstanceProfileCredentialsFetcher.parse [" + jsonContent + "] exception:", e);
        }
    }

    private static class MetadataResponse {
        @SerializedName(value="Code")
        String code;
        @SerializedName(value="AccessKeyId")
        String accessKeyId;
        @SerializedName(value="AccessKeySecret")
        String accessKeySecret;
        @SerializedName(value="SecurityToken")
        String securityToken;
        @SerializedName(value="Expiration")
        String expiration;

        private MetadataResponse() {
        }
    }
}

