/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core;

import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.core.OperationLauncher;
import com.alicloud.openservices.tablestore.core.TraceLogger;
import com.alicloud.openservices.tablestore.core.auth.CredentialsProvider;
import com.alicloud.openservices.tablestore.core.http.AsyncServiceClient;
import com.alicloud.openservices.tablestore.core.http.DescribeTunnelResponseConsumer;
import com.alicloud.openservices.tablestore.core.http.OTSUri;
import com.alicloud.openservices.tablestore.core.protocol.ResultParserFactory;
import com.alicloud.openservices.tablestore.core.protocol.TunnelProtocolBuilder;
import com.alicloud.openservices.tablestore.core.protocol.TunnelServiceApi;
import com.alicloud.openservices.tablestore.core.utils.LogUtil;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import com.alicloud.openservices.tablestore.model.tunnel.DescribeTunnelRequest;
import com.alicloud.openservices.tablestore.model.tunnel.DescribeTunnelResponse;
import com.aliyun.ots.thirdparty.org.apache.http.concurrent.FutureCallback;

public class DescribeTunnelLauncher
extends OperationLauncher<DescribeTunnelRequest, DescribeTunnelResponse> {
    private OTSUri uri;
    private TraceLogger tracer;
    private RetryStrategy retry;

    public DescribeTunnelLauncher(OTSUri uri, TraceLogger tracer, RetryStrategy retry, String instanceName, AsyncServiceClient client, CredentialsProvider crdsProvider, ClientConfiguration config, DescribeTunnelRequest originRequest) {
        super(instanceName, client, crdsProvider, config, originRequest);
        Preconditions.checkNotNull(uri);
        Preconditions.checkNotNull(tracer);
        Preconditions.checkNotNull(retry);
        this.uri = uri;
        this.tracer = tracer;
        this.retry = retry;
    }

    @Override
    public void fire(DescribeTunnelRequest req, FutureCallback<DescribeTunnelResponse> cb) {
        LogUtil.logBeforeExecution(this.tracer, this.retry);
        TunnelServiceApi.DescribeTunnelResponse defaultResponse = TunnelServiceApi.DescribeTunnelResponse.getDefaultInstance();
        this.asyncInvokePost(this.uri, null, TunnelProtocolBuilder.buildDescribeTunnelRequest(req), this.tracer, new DescribeTunnelResponseConsumer(ResultParserFactory.createFactory().createProtocolBufferResultParser(defaultResponse, this.tracer.getTraceId()), this.tracer, this.retry, (DescribeTunnelResponse)this.lastResult), cb);
    }
}

