/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ots.thirdparty.org.apache.http.impl.nio.client;

import com.aliyun.ots.thirdparty.org.apache.http.HttpHost;
import com.aliyun.ots.thirdparty.org.apache.http.HttpRequest;
import com.aliyun.ots.thirdparty.org.apache.http.HttpResponse;
import com.aliyun.ots.thirdparty.org.apache.http.annotation.ThreadSafe;
import com.aliyun.ots.thirdparty.org.apache.http.client.ClientProtocolException;
import com.aliyun.ots.thirdparty.org.apache.http.client.methods.HttpUriRequest;
import com.aliyun.ots.thirdparty.org.apache.http.client.utils.URIUtils;
import com.aliyun.ots.thirdparty.org.apache.http.concurrent.BasicFuture;
import com.aliyun.ots.thirdparty.org.apache.http.concurrent.FutureCallback;
import com.aliyun.ots.thirdparty.org.apache.http.nio.client.HttpAsyncClient;
import com.aliyun.ots.thirdparty.org.apache.http.nio.client.methods.HttpAsyncMethods;
import com.aliyun.ots.thirdparty.org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import com.aliyun.ots.thirdparty.org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import com.aliyun.ots.thirdparty.org.apache.http.protocol.BasicHttpContext;
import com.aliyun.ots.thirdparty.org.apache.http.protocol.HttpContext;
import com.aliyun.ots.thirdparty.org.apache.http.util.Args;
import java.io.Closeable;
import java.net.URI;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class CloseableHttpAsyncClient
implements HttpAsyncClient,
Closeable {
    public abstract boolean isRunning();

    public abstract void start();

    @Override
    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, FutureCallback<T> callback) {
        return this.execute(requestProducer, responseConsumer, (HttpContext)new BasicHttpContext(), callback);
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        return this.execute(HttpAsyncMethods.create(target, request), HttpAsyncMethods.createConsumer(), context, callback);
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, FutureCallback<HttpResponse> callback) {
        return this.execute(target, request, (HttpContext)new BasicHttpContext(), callback);
    }

    @Override
    public Future<HttpResponse> execute(HttpUriRequest request, FutureCallback<HttpResponse> callback) {
        return this.execute(request, new BasicHttpContext(), callback);
    }

    @Override
    public Future<HttpResponse> execute(HttpUriRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        HttpHost target;
        try {
            target = this.determineTarget(request);
        }
        catch (ClientProtocolException ex) {
            BasicFuture<HttpResponse> future = new BasicFuture<HttpResponse>(callback);
            future.failed(ex);
            return future;
        }
        return this.execute(target, request, context, callback);
    }

    private HttpHost determineTarget(HttpUriRequest request) throws ClientProtocolException {
        Args.notNull(request, "HTTP request");
        HttpHost target = null;
        URI requestURI = request.getURI();
        if (requestURI.isAbsolute() && (target = URIUtils.extractHost(requestURI)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + requestURI);
        }
        return target;
    }
}

