/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.writer.handle;

import com.alicloud.openservices.tablestore.AsyncClientInterface;
import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.writer.RequestManager;
import com.alicloud.openservices.tablestore.writer.RequestWithGroups;
import com.alicloud.openservices.tablestore.writer.RowChangeEvent;
import com.alicloud.openservices.tablestore.writer.RowChangeWithGroup;
import com.alicloud.openservices.tablestore.writer.RowWriteResult;
import com.alicloud.openservices.tablestore.writer.WriterConfig;
import com.alicloud.openservices.tablestore.writer.config.BucketConfig;
import com.alicloud.openservices.tablestore.writer.handle.BatchWriteRowRequestManager;
import com.alicloud.openservices.tablestore.writer.handle.BulkImportRequestManager;
import com.alicloud.openservices.tablestore.writer.handle.WriterHandleStatistics;
import com.lmax.disruptor.EventHandler;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowEventHandler
implements EventHandler<RowChangeEvent> {
    private static Logger logger = LoggerFactory.getLogger(RowEventHandler.class);
    private AsyncClientInterface ots;
    private int concurrency;
    private int bucketConcurrency;
    private WriterConfig writerConfig;
    private BucketConfig bucketConfig;
    private TableStoreCallback<RowChange, RowWriteResult> callback;
    private Executor executor;
    private WriterHandleStatistics writerStatistics;
    private Semaphore callbackSemaphore;
    private Semaphore bucketSemaphore;
    private RequestManager requestManager;

    public RowEventHandler(AsyncClientInterface ots, BucketConfig bucketConfig, WriterConfig writerConfig, TableStoreCallback<RowChange, RowWriteResult> callback, Executor executor, WriterHandleStatistics writerStatistics, Semaphore semaphore) {
        this.ots = ots;
        this.concurrency = writerConfig.getConcurrency();
        this.bucketConfig = bucketConfig;
        this.callbackSemaphore = semaphore;
        this.callback = callback;
        this.executor = executor;
        this.writerStatistics = writerStatistics;
        this.writerConfig = writerConfig;
        switch (writerConfig.getWriteMode()) {
            case SEQUENTIAL: {
                this.bucketConcurrency = 1;
                break;
            }
            default: {
                this.bucketConcurrency = this.concurrency;
            }
        }
        this.bucketSemaphore = new Semaphore(this.bucketConcurrency);
        this.initRequestManager();
    }

    private void initRequestManager() {
        switch (this.writerConfig.getBatchRequestType()) {
            case BULK_IMPORT: {
                this.requestManager = new BulkImportRequestManager(this.ots, this.writerConfig, this.bucketConfig, this.executor, this.writerStatistics, this.callback, this.callbackSemaphore, this.bucketSemaphore);
                break;
            }
            default: {
                this.requestManager = new BatchWriteRowRequestManager(this.ots, this.writerConfig, this.bucketConfig, this.executor, this.writerStatistics, this.callback, this.callbackSemaphore, this.bucketSemaphore);
            }
        }
    }

    public void setCallback(TableStoreCallback<RowChange, RowWriteResult> callback) {
        this.callback = callback;
        this.initRequestManager();
    }

    public void onEvent(RowChangeEvent rowChangeEvent, long sequence, boolean endOfBatch) throws Exception {
        boolean shouldWaitFlush = false;
        CountDownLatch latch = null;
        RequestWithGroups requestWithGroups = null;
        if (rowChangeEvent.type == RowChangeEvent.EventType.FLUSH) {
            logger.debug("FlushSignal with QueueSize: {}", (Object)this.requestManager.getTotalRowsCount());
            if (this.requestManager.getTotalRowsCount() > 0) {
                requestWithGroups = this.requestManager.makeRequest();
            }
            shouldWaitFlush = true;
            latch = rowChangeEvent.latch;
        } else {
            this.writerStatistics.totalRowsCount.incrementAndGet();
            final RowChange rowChange = rowChangeEvent.rowChange;
            final RowChangeWithGroup rowChangeWithGroup = new RowChangeWithGroup(rowChangeEvent.rowChange, rowChangeEvent.group);
            boolean succeed = this.requestManager.appendRowChange(rowChangeWithGroup);
            if (!succeed) {
                requestWithGroups = this.requestManager.makeRequest();
                succeed = this.requestManager.appendRowChange(rowChangeWithGroup);
                if (!succeed) {
                    this.executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            ((RowEventHandler)RowEventHandler.this).writerStatistics.totalFailedRowsCount.incrementAndGet();
                            ClientException exception = new ClientException("Can not even append only one row into buffer.");
                            logger.error("RowChange Failed: ", (Throwable)exception);
                            rowChangeWithGroup.group.failedOneRow(rowChangeWithGroup.rowChange, exception);
                            if (RowEventHandler.this.callback != null) {
                                RowEventHandler.this.callback.onFailed(rowChange, exception);
                            }
                        }
                    });
                }
            }
        }
        if (requestWithGroups != null) {
            final RequestWithGroups finalRequestWithGroups = requestWithGroups;
            this.bucketSemaphore.acquire();
            this.callbackSemaphore.acquire();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((RowEventHandler)RowEventHandler.this).writerStatistics.totalRequestCount.incrementAndGet();
                    RowEventHandler.this.requestManager.sendRequest(finalRequestWithGroups);
                }
            });
        }
        if (shouldWaitFlush) {
            this.bucketSemaphore.acquire(this.bucketConcurrency);
            this.bucketSemaphore.release(this.bucketConcurrency);
            logger.debug("Finish bucket waitFlush.");
            latch.countDown();
        }
    }
}

