/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timestream.internal;

import com.alicloud.openservices.tablestore.TableStoreWriter;
import com.alicloud.openservices.tablestore.model.RowUpdateChange;
import com.alicloud.openservices.tablestore.timestream.internal.Utils;
import com.alicloud.openservices.tablestore.timestream.model.TimestreamIdentifier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaCacheManager {
    private static Logger logger = LoggerFactory.getLogger(MetaCacheManager.class);
    private String tableName;
    private Cache<TimestreamIdentifier, Long> cache;
    private long intervalDumpMeta;
    private TableStoreWriter writer;

    public MetaCacheManager(String tableName, long intervalDumpMeta, long maxCacheSize, TableStoreWriter writer) {
        this.tableName = tableName;
        this.intervalDumpMeta = intervalDumpMeta;
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(intervalDumpMeta, TimeUnit.SECONDS).weigher((Weigher)new Weigher<TimestreamIdentifier, Long>(){

            public int weigh(TimestreamIdentifier k, Long v) {
                return k.getDataSize() + 8;
            }
        }).maximumWeight(maxCacheSize).build();
        this.writer = writer;
    }

    public void close() {
        this.writer.flush();
    }

    public void addTimestreamMeta(TimestreamIdentifier identifier, long updateTime) {
        Long lastUpdateTime = (Long)this.cache.getIfPresent((Object)identifier);
        if (lastUpdateTime == null || lastUpdateTime + TimeUnit.SECONDS.toMicros(this.intervalDumpMeta) <= updateTime) {
            RowUpdateChange rowChange = Utils.serializeTimestreamIdentifier(this.tableName, identifier, updateTime);
            if (!this.writer.tryAddRowChange(rowChange)) {
                logger.error("Failed update meta: " + identifier.toString());
            } else {
                this.cache.put((Object)identifier, (Object)updateTime);
            }
        }
    }

    public void updateTimestreamMeta(TimestreamIdentifier meta, long updateTime) {
        Long lastUpdateTime = (Long)this.cache.getIfPresent((Object)meta);
        if (lastUpdateTime == null || lastUpdateTime <= updateTime) {
            this.cache.put((Object)meta, (Object)updateTime);
        }
    }

    protected Long getTimestreamMetaLastUpdateTime(TimestreamIdentifier meta) {
        return (Long)this.cache.getIfPresent((Object)meta);
    }
}

