/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.reader;

import com.alicloud.openservices.tablestore.reader.RowReadResult;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class ReaderResult {
    private final int totalCount;
    private final AtomicReferenceArray<RowReadResult> resultList;
    private boolean isAllFinished = true;

    public ReaderResult(int totalCount, AtomicReferenceArray<RowReadResult> resultList) {
        this.totalCount = totalCount;
        this.resultList = resultList;
    }

    public List<RowReadResult> getSucceedRows() {
        LinkedList<RowReadResult> succeed = new LinkedList<RowReadResult>();
        for (int i = 0; i < this.resultList.length(); ++i) {
            RowReadResult result = this.resultList.get(i);
            if (!result.isSucceed()) continue;
            succeed.add(result);
        }
        return succeed;
    }

    public List<RowReadResult> getFailedRows() {
        LinkedList<RowReadResult> failed = new LinkedList<RowReadResult>();
        for (int i = 0; i < this.resultList.length(); ++i) {
            RowReadResult result = this.resultList.get(i);
            if (result.isSucceed()) continue;
            failed.add(result);
        }
        return failed;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public boolean isAllFinished() {
        return this.isAllFinished;
    }

    public boolean isAllSucceed() {
        LinkedList failed = new LinkedList();
        for (int i = 0; i < this.resultList.length(); ++i) {
            RowReadResult result = this.resultList.get(i);
            if (result.isSucceed()) continue;
            return false;
        }
        return true;
    }
}

